/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.shoin.bundle;

import shohaku.ginkgo.Document;
import shohaku.shoin.ResourceSet;
import shohaku.shoin.XResourceBundle;
import shohaku.shoin.XResourceBundleBase;

/**
 * Ginkgo API 用いた階層化リソースバンドルの抽象実装を提供します。
 */
public abstract class AbstractGinkgoXResourceBundle extends XResourceBundle {

    /* 個々のリソースのドキュメント。 */
    private final Document document;

    /**
     * 階層オブジェクトとGinkgo API のドキュメントを格納して初期化します。
     * 
     * @param parent
     *            親バンドル
     * @param bundleBase
     *            束縛基準
     * @param resources
     *            リソース集合
     * @param document
     *            ドキュメント
     */
    protected AbstractGinkgoXResourceBundle(XResourceBundle parent, XResourceBundleBase bundleBase, ResourceSet resources, Document document) {
        super(parent, bundleBase, resources);
        this.document = document;
    }

    /**
     * ドキュメントを返却します。
     * 
     * @return ドキュメント
     */
    protected Document getDocument() {
        return this.document;
    }

}
