/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.shoin;

import java.util.EventObject;

import shohaku.core.resource.IOResource;
import shohaku.core.resource.IOResourceLoader;

/**
 * 拡張可能な階層化リソースバンドルの生成イベントを提供します。
 */
public class XResourceBundleEvent extends EventObject {

    /* serialVersionUID */
    private static final long serialVersionUID = 4583063903198329156L;

    /* 基底名 */
    private String baseName;

    /* リソースの固有名 */
    private String bundleName;

    /* 束縛基準 */
    private XResourceBundleBase bundleBase;

    /* 親バンドル */
    private XResourceBundle parent;

    /* IOリソース生成機能 */
    private IOResourceLoader ioResourceLoader;

    /* クラスローダ */
    private ClassLoader classLoader;

    /* 生成対象のバンドルのIOリソース */
    private IOResource targetIOResource;

    /* 生成対象のリソースの固有名 */
    private String targetBundleName;

    /* 生成対象の束縛基準 */
    private XResourceBundleBase targetBundleBase;

    /* 生成対象の親バンドル */
    private XResourceBundle targetParent;

    /**
     * プロパティの初期値 null でイベントを初期化します。
     * 
     * @param source
     *            処理の実行元
     */
    public XResourceBundleEvent(Object source) {
        super(source);
    }

    /**
     * 基底名を返却します。
     * 
     * @return 基底名
     */
    public String getBaseName() {
        return baseName;
    }

    /**
     * 基底名を格納します。
     * 
     * @param baseName
     *            基底名
     */
    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    /**
     * 束縛基準を返却します。
     * 
     * @return 束縛基準
     */
    public XResourceBundleBase getBundleBase() {
        return bundleBase;
    }

    /**
     * 束縛基準を格納します。
     * 
     * @param bundleBase
     *            束縛基準
     */
    public void setBundleBase(XResourceBundleBase bundleBase) {
        this.bundleBase = bundleBase;
    }

    /**
     * リソースの固有名を返却します。
     * 
     * @return リソースの固有名
     */
    public String getBundleName() {
        return bundleName;
    }

    /**
     * リソースの固有名を格納します。
     * 
     * @param bundleName
     *            リソースの固有名
     */
    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    /**
     * クラスローダを返却します。
     * 
     * @return クラスローダ
     */
    public ClassLoader getClassLoader() {
        return classLoader;
    }

    /**
     * クラスローダを格納します。
     * 
     * @param classLoader
     *            クラスローダ
     */
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /**
     * IOリソース生成機能を返却します。
     * 
     * @return IOリソース生成機能
     */
    public IOResourceLoader getIOResourceLoader() {
        return ioResourceLoader;
    }

    /**
     * IOリソース生成機能を格納します。
     * 
     * @param ioResourceLoader
     *            IOリソース生成機能
     */
    public void setIOResourceLoader(IOResourceLoader ioResourceLoader) {
        this.ioResourceLoader = ioResourceLoader;
    }

    /**
     * 親のバンドルを返却します。
     * 
     * @return 親のバンドル
     */
    public XResourceBundle getParent() {
        return parent;
    }

    /**
     * 親のバンドルを格納します。
     * 
     * @param parent
     *            親のバンドル
     */
    public void setParent(XResourceBundle parent) {
        this.parent = parent;
    }

    /**
     * 生成対象のバンドルのIOリソースを返却します。
     * 
     * @return 生成対象のバンドルのIOリソース
     */
    public IOResource getTargetIOResource() {
        return targetIOResource;
    }

    /**
     * 生成対象のバンドルのIOリソースを格納します。
     * 
     * @param ioResource
     *            生成対象のバンドルのIOリソース
     */
    public void setTargetIOResource(IOResource ioResource) {
        this.targetIOResource = ioResource;
    }

    /**
     * 生成対象の束縛基準を返却します。
     * 
     * @return 生成対象の束縛基準
     */
    public XResourceBundleBase getTargetBundleBase() {
        return targetBundleBase;
    }

    /**
     * 生成対象の束縛基準を格納します。
     * 
     * @param targetBundleBase
     *            生成対象の束縛基準
     */
    public void setTargetBundleBase(XResourceBundleBase targetBundleBase) {
        this.targetBundleBase = targetBundleBase;
    }

    /**
     * 生成対象のリソースの固有名を返却します。
     * 
     * @return 生成対象のリソースの固有名
     */
    public String getTargetBundleName() {
        return targetBundleName;
    }

    /**
     * 生成対象のリソースの固有名を格納します。
     * 
     * @param targetBundleName
     *            生成対象のリソースの固有名
     */
    public void setTargetBundleName(String targetBundleName) {
        this.targetBundleName = targetBundleName;
    }

    /**
     * 生成対象の親バンドルを返却します。
     * 
     * @return 生成対象の親バンドル
     */
    public XResourceBundle getTargetParent() {
        return targetParent;
    }

    /**
     * 生成対象の親バンドルを格納します。
     * 
     * @param targetParent
     *            生成対象の親バンドル
     */
    public void setTargetParent(XResourceBundle targetParent) {
        this.targetParent = targetParent;
    }

}
