/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.shoin;

/**
 * ライブラリの集約機能のコンテキストを提供します。
 */
public class ShoinContext {

    /* 識別子とプロキシのマッピング */
    private ResourceSet lookup;

    /**
     * 識別子とプロキシを格納して初期化します。
     * 
     * @param lookup
     *            識別子とプロキシのマッピング
     */
    public ShoinContext(ResourceSet lookup) {
        this.lookup = lookup;
    }

    /**
     * 再生成を行わずに、識別子を持つリソース集合を返却します。<br>
     * 識別子が登録されていない場合は null が返却されます。
     * 
     * @param id
     *            識別子
     * @return 識別子を持つリソース集合
     * @throws ResourceSetCreationException
     *             リソース集合の生成に失敗した場合
     */
    public ResourceSet lookup(String id) throws ResourceSetCreationException {
        return lookup(id, false);
    }

    /**
     * 再生成を行うか指定して、識別子を持つリソース集合を返却します。<br>
     * 識別子が登録されていない場合は null が返却されます。
     * 
     * @param id
     *            識別子
     * @param create
     *            再生成を要求する場合は true
     * @return 識別子を持つリソース集合
     * @throws ResourceSetCreationException
     *             リソース集合の生成に失敗した場合
     */
    public ResourceSet lookup(String id, boolean create) throws ResourceSetCreationException {
        ResourceSetFactoryProxy proxy = (ResourceSetFactoryProxy) lookup.getObject(id);
        return (proxy != null) ? proxy.getResourceSet(create) : null;
    }

}
