/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.shoin;

/**
 * リソース集合の生成機能が、リソースキーに接頭辞を指定する機能をサポートする事を示すインターフェースを提供します。<br>
 * 接頭辞が指定されている場合に、その識別子が文字列以外の場合は、強制的に文字列変換されます。<br>
 * 接頭辞が空文字列の場合は、長さ 0 の接頭辞として処理されます。 <br>
 * 接頭辞が null の場合は、接頭辞の指定無しとして、接頭辞を付加する処理は実行されません。
 */
public interface ResourceKeyPrefixSupport {

    /**
     * 全てのリソースに対する接頭辞を返却します。
     * 
     * @return 全てのリソースに対する接頭辞
     */
    String getPrefix();

    /**
     * 全てのリソースに対する接頭辞を格納します。
     * 
     * @param prefix
     *            全てのリソースに対する接頭辞
     */
    void setPrefix(String prefix);

    /**
     * リソース単位での接頭辞の配列を返却します。
     * 
     * @return リソース単位での接頭辞の配列
     */
    String[] getSourcesPrefix();

    /**
     * リソース単位での接頭辞の配列を格納します。
     * 
     * @param prefixs
     *            リソース単位での接頭辞の配列
     */
    void setSourcesPrefix(String[] prefixs);

}
