/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.shoin;

/**
 * 何らかの理由によりリソースの生成に失敗したことを通知します。 <br>
 * <br>
 * この例外は数多くある生成の失敗の原因に対する一般化された意味合いを持ちます。<br>
 * 例外の原因は可能な限り起因例外に含まれる事が要求されます。
 */
public class ResourceCreationException extends RuntimeException {

    /* serialVersionUID */
    private static final long serialVersionUID = -5589586939136225308L;

    /**
     * デフォルトコンストラクタ。
     */
    public ResourceCreationException() {
        super();
    }

    /**
     * エラーメッセージを設定して初期化します。
     * 
     * @param message
     *            エラーメッセージ
     */
    public ResourceCreationException(String message) {
        super(message);
    }

    /**
     * 起因例外を設定して初期化します。
     * 
     * @param cause
     *            起因例外
     */
    public ResourceCreationException(Throwable cause) {
        super(cause);
    }

    /**
     * エラーメッセージと起因例外を設定して初期化します。
     * 
     * @param message
     *            エラーメッセージ
     * @param cause
     *            起因例外
     */
    public ResourceCreationException(String message, Throwable cause) {
        super(message, cause);
    }

}
