/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.shoin;

import shohaku.core.resource.IOResource;

/**
 * IOリソースからリソース集合を生成する機能を提供します。<br>
 * 複数のIOリソースから、リソース集合を生成します。
 */
public interface IOResourceSetFactory extends ResourceSetFactory {

    /**
     * IOリソースから、リソース集合を生成し返却します。
     * 
     * @return リソース集合
     * @throws ResourceSetCreationException
     *             リソース集合の生成に失敗した場合
     */
    ResourceSet getResourceSet() throws ResourceSetCreationException;

    /**
     * IOリソースの配列を返却します。
     * 
     * @return IOリソースの配列
     */
    IOResource[] getIOResources();

    /**
     * IOリソースの配列を格納します。
     * 
     * @param ioResources
     *            IOリソースの配列
     */
    void setIOResources(IOResource[] ioResources);

}
