/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.shoin;

import shohaku.ginkgo.Document;
import shohaku.ginkgo.DocumentCompositeRule;
import shohaku.ginkgo.NodeCompositeRule;

/**
 * Ginkgo API 用いてリソース集合を生成する機能を提供します。
 */
public interface GinkgoResourceSetFactory extends IOResourceSetFactory {

    /**
     * Ginkgo API 用いてIOリソースから、リソース集合を生成し返却します。
     * 
     * @return リソース集合
     * @throws ResourceSetCreationException
     *             リソース集合の生成に失敗した場合<br>
     *             GinkgoException の発生時も起因例外として格納して、この例外を返す。
     */
    ResourceSet getResourceSet() throws ResourceSetCreationException;

    /**
     * リソースの生成に使用する銀杏APIのノード構成ルールを返却します。
     * 
     * @return 銀杏APIの構成ルール
     */
    NodeCompositeRule getNodeCompositeRule();

    /**
     * リソースの生成に使用する銀杏APIのノード構成ルールを格納します。
     * 
     * @param nodeCompositeRule
     *            銀杏APIの構成ルール
     */
    void setNodeCompositeRule(NodeCompositeRule nodeCompositeRule);

    /**
     * リソースの生成に使用する銀杏APIのドキュメント構成ルールを返却します。
     * 
     * @return 銀杏APIのドキュメント構成ルール
     */
    DocumentCompositeRule getDocumentCompositeRule();

    /**
     * リソースの生成に使用する銀杏APIのドキュメント構成ルールを格納します。
     * 
     * @param documentCompositeRule
     *            銀杏APIのドキュメント構成ルール
     */
    void setDocumentCompositeRule(DocumentCompositeRule documentCompositeRule);

    /**
     * リソースの生成に指定する親のドキュメントを返却します。
     * 
     * @return 親のドキュメント
     */
    Document getParentDocument();

    /**
     * リソースの生成に指定する親のドキュメントを格納します。
     * 
     * @param parentDocument
     *            親のドキュメント
     */
    void setParentDocument(Document parentDocument);

    /**
     * 直前に解析したドキュメントを返却します。
     * 
     * @return 直前に解析したドキュメント
     */
    Document getParseDocument();

    /**
     * リソースの生成に使用するクラスローダを返却します。
     * 
     * @return クラスローダ
     */
    ClassLoader getClassLoader();

    /**
     * リソースの生成に使用するクラスローダを格納します。
     * 
     * @param classLoader
     *            クラスローダ
     */
    void setClassLoader(ClassLoader classLoader);

}
