/*
 * Decompiled with CFR 0.152.
 */
package shohaku.sugina.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import shohaku.core.helpers.HCoder;
import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.lang.feature.FeatureFactory;
import shohaku.core.util.XProperties;
import shohaku.ogdl.Ogdl;
import shohaku.ogdl.OgdlContext;
import shohaku.ogdl.OgdlHelper;
import shohaku.ogdl.OgdlSyntaxException;

public class OgdlXProperties
extends XProperties {
    private static final long serialVersionUID = 4109039838422671403L;
    final OgdlContext context;
    final Ogdl ogdl;

    public OgdlXProperties() {
        this(OgdlHelper.getOgdlContext(), OgdlXProperties.class.getClassLoader());
    }

    public OgdlXProperties(OgdlContext context, ClassLoader loader) {
        this.context = context;
        this.ogdl = new Ogdl();
        this.ogdl.setContext(context);
        context.setClassLoader(loader);
    }

    protected void putProperty(String key, String value, boolean isEscapes) throws IOException {
        block9: {
            String k = key;
            String v = value;
            if (isEscapes) {
                k = HCoder.decodePropertiesEscapes((CharSequence)k);
                v = HCoder.decodePropertiesEscapes((CharSequence)v);
            }
            try {
                if (k.charAt(0) == '$') {
                    this.context.setAttribute(k.substring(1), this.ogdl.evaluate(v));
                    break block9;
                }
                if (k.charAt(0) == '@') {
                    if (k.equals("@import")) {
                        Class c = null;
                        try {
                            c = FeatureFactory.getLoader().getClass(v);
                        }
                        catch (NoSuchResourceException e) {
                            throw new IOException(e.getMessage());
                        }
                        this.context.addImport(c);
                        break block9;
                    }
                    if (k.equals("@eval")) {
                        this.ogdl.evaluate(v);
                    }
                    break block9;
                }
                this.lookup.put(k, this.ogdl.evaluate(v));
            }
            catch (OgdlSyntaxException e) {
                IOException ie = new IOException("ogdl evaluation err.");
                ie.initCause(e);
                throw ie;
            }
        }
    }

    public void store(OutputStream outStream, Charset charset, String header) throws IOException {
        throw new UnsupportedOperationException("Un Supported OgdlXProperties#store().");
    }

    public void store(OutputStream outStream, String header) throws IOException {
        throw new UnsupportedOperationException("Un Supported OgdlXProperties#store().");
    }
}

