/*
 * Decompiled with CFR 0.152.
 */
package shohaku.sugina.dynbind;

import java.lang.reflect.Method;
import java.util.Map;
import shohaku.core.helpers.HBeans;
import shohaku.core.helpers.HLog;
import shohaku.core.lang.Eval;
import shohaku.core.lang.EvalSet;
import shohaku.core.lang.IntrospectionBeansException;
import shohaku.sugina.dynbind.BindArgumentRule;
import shohaku.sugina.dynbind.BindArgumentsDesc;

public final class BindMethod {
    private Class bindType;
    private Object bindObject;
    private Method method;
    private String methodName;
    private BindArgumentsDesc bindArgumentsDesc;
    private Class[] parameterTypes;
    private Object[] parameterValues;
    private String[] parameterNames;
    private BindArgumentRule[] parameterRules;
    private String _toString;

    private BindMethod(Class bindType, Object bindObject, String methodName, BindArgumentsDesc args) throws IntrospectionBeansException {
        this.methodName = methodName;
        this.bindType = bindType;
        this.bindObject = bindObject;
        this.bindArgumentsDesc = args;
        this.parameterTypes = args.getArgumentTypes();
        this.parameterRules = args.getArgumentRules();
        this.parameterNames = args.getArgumentNames();
        this.parameterValues = args.getArgumentValues();
        this.init();
    }

    public Object invoke(Map values) throws IntrospectionBeansException {
        return this.invokeMethod(this.getBindObject(), this.getMethod(), values);
    }

    public Class getBindType() {
        return this.bindType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object getBindObject() {
        return this.bindObject;
    }

    public Method getMethod() {
        return this.method;
    }

    public BindArgumentsDesc getBindArgumentsDesc() {
        return this.bindArgumentsDesc;
    }

    public String toString() {
        return this._toString;
    }

    private void init() throws IntrospectionBeansException {
        Class[] types = this.parameterTypes;
        Object[] values = this.parameterValues;
        Object[] names = this.parameterNames;
        BindArgumentRule[] rules = this.parameterRules;
        if (!Eval.isEqualLength((Object[])new Object[]{types, values, names, rules})) {
            throw new IntrospectionBeansException("parameter is illegal.");
        }
        if (EvalSet.isOrEmpty((Object[])names)) {
            throw new IntrospectionBeansException("parameter is illegal.");
        }
        try {
            this.initMethod(this.getMatchingAccessibleMethod());
        }
        catch (NoSuchMethodException e) {
            throw new IntrospectionBeansException("parameter is illegal.", (Throwable)e);
        }
        this.buildToString();
    }

    private void initMethod(Method initMethod) {
        this.method = initMethod;
    }

    private Object invokeMethod(Object obj, Method invokeMethod, Map params) throws IntrospectionBeansException {
        Object[] values = (Object[])this.parameterValues.clone();
        String[] names = this.parameterNames;
        BindArgumentRule[] rules = this.parameterRules;
        for (int i = 0; i < values.length; ++i) {
            BindArgumentRule rule = rules[i];
            String name = names[i];
            if (BindArgumentRule.FINAL == rule) {
                if (!params.containsKey(name)) continue;
                throw new IntrospectionBeansException("illegal parameter name is final. " + name);
            }
            if (BindArgumentRule.OVERWRITE == rule) {
                if (!params.containsKey(name)) continue;
                values[i] = params.get(name);
                continue;
            }
            if (BindArgumentRule.REQUIRED != rule) continue;
            if (params.containsKey(name)) {
                values[i] = params.get(name);
                continue;
            }
            throw new IntrospectionBeansException("required parameter isn't included. " + name);
        }
        return HBeans.invokeMethod((Object)obj, (Method)invokeMethod, (Object[])values);
    }

    private Method getMatchingAccessibleMethod() throws NoSuchMethodException, IntrospectionBeansException {
        Method m = HBeans.getAssignmentMethod((Class)this.getBindType(), (String)this.getMethodName(), (Class[])this.parameterTypes);
        if (m == null) {
            throw new NoSuchMethodException(HLog.list((String)"not find Method. ", (Object)this.getBindType(), (Object)this.getMethodName(), (Object)this.parameterTypes));
        }
        return m;
    }

    private void buildToString() {
        Class[] types = this.parameterTypes;
        Object[] values = this.parameterValues;
        String[] names = this.parameterNames;
        BindArgumentRule[] rules = this.parameterRules;
        StringBuffer sb = new StringBuffer();
        sb.append("bind method=");
        sb.append(this.getMethod());
        sb.append('{');
        for (int i = 0; i < types.length; ++i) {
            sb.append('{');
            sb.append(rules[i]);
            sb.append(',');
            sb.append(names[i]);
            sb.append(',');
            sb.append(values[i]);
            sb.append('}');
        }
        sb.append('}');
        this._toString = sb.toString();
    }

    public static BindMethod bind(String methodName, Class bindType, Object bindObject, BindArgumentsDesc args) throws IntrospectionBeansException {
        return new BindMethod(bindType, bindObject, methodName, args);
    }

    public static BindMethod valueOf(String pt) throws IntrospectionBeansException {
        return null;
    }
}

