/*
 * Decompiled with CFR 0.152.
 */
package shohaku.sugina.beans;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import shohaku.core.helpers.HBeans;
import shohaku.core.helpers.HSeek;
import shohaku.core.lang.Eval;
import shohaku.core.lang.IntrospectionBeansException;
import shohaku.ogdl.Ogdl;
import shohaku.ogdl.OgdlHelper;
import shohaku.ogdl.OgdlParseIndex;
import shohaku.ogdl.OgdlSyntaxException;
import shohaku.sugina.beans.MethodGraphSyntaxException;

public final class MethodGraph {
    public static final int LAST_ESC = 1;
    private static final char DIVIDE = '.';
    private static final char INDEX_OP = '[';
    private static final char INDEX_CL = ']';
    private static final char ARGS_OP = '(';
    private static final char ARGS_CL = ')';
    private final String _pattern;
    private final int _flags;
    private final Invoker _invoker;

    private MethodGraph(String pattern, int flags) {
        this._pattern = pattern;
        this._flags = flags;
        this._invoker = this.compileImpl(pattern);
    }

    private Invoker compileImpl(String pattern) {
        if (Eval.isBlank((CharSequence)pattern)) {
            throw new MethodGraphSyntaxException("pattern is blank.");
        }
        char[] openChars = new char[]{'.', '[', '('};
        LinkedList<Invoker> invokers = new LinkedList<Invoker>();
        OgdlParseIndex off = new OgdlParseIndex(0);
        Ogdl el = new Ogdl();
        el.setContext(OgdlHelper.getOgdlContext());
        el.getContext().setClassLoader(MethodGraph.class.getClassLoader());
        try {
            while (off.get() < pattern.length()) {
                String propertyName;
                if (pattern.charAt(off.get()) == '[') {
                    List args = el.evaluateList(pattern, off, '[', ']');
                    if (args.size() != 1) {
                        throw new MethodGraphSyntaxException(this.log(pattern, off));
                    }
                    invokers.add(new CollectionInvoker(args.get(0), pattern));
                    continue;
                }
                if (pattern.charAt(off.get()) == '.') {
                    off.increment();
                } else if (off.get() != 0) {
                    if (this.has(1)) break;
                    throw new MethodGraphSyntaxException(this.log(pattern, off));
                }
                int end = HSeek.orIndexOf((CharSequence)pattern, (int)off.get(), (char[])openChars, (int)1);
                if (-1 < end) {
                    if (pattern.charAt(end) == '(') {
                        String methodName = pattern.substring(off.get(), end);
                        off.set(end);
                        List args = el.evaluateList(pattern, off, '(', ')');
                        invokers.add(new MethodInvoker(methodName, args.toArray(), pattern));
                        continue;
                    }
                    propertyName = pattern.substring(off.get(), end);
                    invokers.add(new PropertyInvoker(propertyName));
                    off.set(end);
                    continue;
                }
                propertyName = pattern.substring(off.get());
                invokers.add(new PropertyInvoker(propertyName));
                off.set(pattern.length());
            }
            return new RootInvoker(invokers.toArray(new Invoker[invokers.size()]));
        }
        catch (OgdlSyntaxException e) {
            throw new MethodGraphSyntaxException(this.log(pattern, off), e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MethodGraphSyntaxException(this.log(pattern, off), e);
        }
        catch (NumberFormatException e) {
            throw new MethodGraphSyntaxException(this.log(pattern, off), e);
        }
    }

    private String log(String pattern, OgdlParseIndex off) {
        return "illegal pattern=" + pattern + ", offset=" + off;
    }

    public Object invoke(Object target) throws IntrospectionBeansException {
        return this._invoker.invoke(target, null, false);
    }

    public Object invoke(Object target, Object value) throws IntrospectionBeansException {
        return this._invoker.invoke(target, value, true);
    }

    public String pattern() {
        return this._pattern;
    }

    public String toString() {
        return this._pattern;
    }

    private boolean has(int f) {
        return (this._flags & f) > 0;
    }

    public static MethodGraph compile(String pattern) {
        return MethodGraph.compile(pattern, 0);
    }

    public static MethodGraph compile(String pattern, int flags) {
        return new MethodGraph(pattern, flags);
    }

    static class PropertyInvoker
    implements Invoker {
        private final String _propertyName;

        PropertyInvoker(String propertyName) {
            this._propertyName = propertyName;
        }

        public Object invoke(Object target, Object value, boolean isSetter) throws IntrospectionBeansException {
            if (!isSetter) {
                return HBeans.getProperty((Object)target, (String)this._propertyName);
            }
            HBeans.setProperty((Object)target, (String)this._propertyName, (Object)value);
            return null;
        }
    }

    static class MethodInvoker
    implements Invoker {
        private final String _methodName;
        private final Class[] _types;
        private final Object[] _args;
        private final String _pattern;

        MethodInvoker(String methodName, Object[] args, String pattern) {
            this._methodName = methodName;
            this._types = HBeans.toClassArray((Object[])args);
            this._args = args;
            this._pattern = pattern;
        }

        public Object invoke(Object target, Object value, boolean isSetter) throws IntrospectionBeansException {
            if (!isSetter) {
                return HBeans.invokeMethod((Object)target, (Method)HBeans.getAssignmentMethod(target.getClass(), (String)this._methodName, (Class[])this._types), (Object[])this._args);
            }
            throw new IntrospectionBeansException("no supported set method. " + this._pattern + ", " + this._methodName);
        }
    }

    static class CollectionInvoker
    implements Invoker {
        private final Object _key;
        private final Integer _index;
        private final String _pattern;

        CollectionInvoker(Object key, String pattern) {
            this._key = key;
            this._index = key instanceof Integer ? (Integer)key : null;
            this._pattern = pattern;
        }

        public Object invoke(Object target, Object value, boolean isSetter) throws IntrospectionBeansException {
            if (!isSetter) {
                if (target instanceof Map) {
                    return ((Map)target).get(this._key);
                }
                if (this._index != null) {
                    if (target instanceof List) {
                        return ((List)target).get(this._index);
                    }
                    if (Eval.isArray((Object)target)) {
                        return Array.get(target, this._index);
                    }
                }
            } else {
                if (target instanceof Map) {
                    return ((Map)target).put(this._key, value);
                }
                if (this._index != null) {
                    if (target instanceof List) {
                        return ((List)target).set(this._index, value);
                    }
                    if (Eval.isArray((Object)target)) {
                        Object oldValue = Array.get(target, this._index);
                        Array.set(target, this._index, value);
                        return oldValue;
                    }
                }
            }
            throw new IntrospectionBeansException("illegal arg type. " + this._pattern + ", " + ", " + target + ", " + this._key);
        }
    }

    static class RootInvoker
    implements Invoker {
        private final Invoker[] _invokers;

        RootInvoker(Invoker[] invokers) {
            this._invokers = invokers;
        }

        public Object invoke(Object target, Object value, boolean isSetter) throws IntrospectionBeansException {
            Object t = target;
            int size = this._invokers.length;
            for (int i = 0; i < size; ++i) {
                t = i + 1 < size ? this._invokers[i].invoke(t, value, false) : this._invokers[i].invoke(t, value, isSetter);
            }
            return t;
        }
    }

    static interface Invoker {
        public Object invoke(Object var1, Object var2, boolean var3) throws IntrospectionBeansException;
    }
}

