/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.sugina.beans;

/**
 * メソッドグラフの構文の誤りを示す未チェック例外を提供します。
 */
public class MethodGraphSyntaxException extends IllegalArgumentException {

    /* serialVersionUID */
    private static final long serialVersionUID = -102119494037127708L;

    /**
     * デフォルトコンストラクタ。
     */
    public MethodGraphSyntaxException() {
        super();
    }

    /**
     * エラーメッセージを設定して初期化します。
     * 
     * @param message
     *            エラーメッセージ
     */
    public MethodGraphSyntaxException(String message) {
        super(message);
    }

    /**
     * 起因例外を設定して初期化します。
     * 
     * @param cause
     *            起因例外
     */
    public MethodGraphSyntaxException(Throwable cause) {
        super();
        initCause(cause);
    }

    /**
     * エラーメッセージと起因例外を設定して初期化します。
     * 
     * @param message
     *            エラーメッセージ
     * @param cause
     *            起因例外
     */
    public MethodGraphSyntaxException(String message, Throwable cause) {
        super(message);
        initCause(cause);
    }

}