/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo.tags.core.logic;

import java.util.Iterator;
import shohaku.core.collections.IteratorUtils;
import shohaku.core.lang.Boxing;
import shohaku.core.lang.Eval;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.tags.AbstractLogicTag;
import shohaku.ginkgo.type.EvaluationValue;
import shohaku.ginkgo.type.IterateValue;

public class ForEachTag
extends AbstractLogicTag {
    private int begin = 0;
    private int end = Integer.MAX_VALUE;
    private String indexVar = "index";
    private String countVar = "count";
    private String itemVar = "item";
    private IterateValue items = null;
    private EvaluationValue test = null;
    private Iterator itemsIterator;
    private int index;
    private int count;

    public int doInitBody() {
        if (this.items != null) {
            this.itemsIterator = this.items.iterator();
            IteratorUtils.shift((Iterator)this.itemsIterator, (int)this.begin);
        } else {
            this.itemsIterator = IteratorUtils.infiniteLoopIterator();
        }
        this.index = this.begin;
        this.count = 0;
        return 0;
    }

    public int doEvalBody() {
        if (this.hasNext()) {
            this.getTagContext().getDocumentContext().setAttribute(this.indexVar, Boxing.box((int)this.index));
            this.getTagContext().getDocumentContext().setAttribute(this.countVar, Boxing.box((int)this.count));
            this.getTagContext().getDocumentContext().setAttribute(this.itemVar, this.itemsIterator.next());
            ++this.index;
            ++this.count;
            return 2;
        }
        this.getTagContext().getDocumentContext().removeAttribute(this.indexVar);
        this.getTagContext().getDocumentContext().removeAttribute(this.countVar);
        this.getTagContext().getDocumentContext().removeAttribute(this.itemVar);
        return 3;
    }

    private boolean hasNext() {
        return this.index < this.end && this.itemsIterator.hasNext() && (this.test == null || this.test.evaluate() != false);
    }

    public void setIndexVar(String indexVar) {
        if (Eval.isEmpty((CharSequence)indexVar)) {
            throw new GinkgoException("indexVar is empty." + indexVar);
        }
        this.indexVar = indexVar;
    }

    public void setCountVar(String countVar) {
        if (Eval.isEmpty((CharSequence)countVar)) {
            throw new GinkgoException("countVar is empty." + countVar);
        }
        this.countVar = countVar;
    }

    public void setItemVar(String itemVar) {
        if (Eval.isEmpty((CharSequence)itemVar)) {
            throw new GinkgoException("itemVar is empty." + itemVar);
        }
        this.itemVar = itemVar;
    }

    public void setEnd(int end) {
        if (0 > end) {
            throw new GinkgoException("end is negative number." + end);
        }
        this.end = end;
    }

    public void setBegin(int begin) {
        if (0 > begin) {
            throw new GinkgoException("begin is negative number." + begin);
        }
        this.begin = begin;
    }

    public void setItems(IterateValue items) {
        this.items = items;
    }

    protected void setTest(EvaluationValue test) {
        this.test = test;
    }
}

