/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo.tags.core.collections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import shohaku.core.lang.ObjectCreationException;
import shohaku.core.lang.feature.FeatureFactory;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.tags.AbstractValueTag;

public class ListTag
extends AbstractValueTag {
    private Class type = ArrayList.class;
    private final List elements = new LinkedList();

    protected Object generateValue() {
        List list;
        try {
            list = (List)FeatureFactory.getLoader().getInstance(this.type);
        }
        catch (ClassCastException e) {
            throw new GinkgoException("class name which is not a List class is specified. " + this.type, e);
        }
        catch (ObjectCreationException e) {
            throw new GinkgoException("illegal class name is specified. " + this.type, e);
        }
        list.addAll(this.elements);
        return Collections.unmodifiableList(list);
    }

    public void setType(Class type) {
        this.type = type;
    }

    public Class getType() {
        return this.type;
    }

    public void addElementTransferValue(Object element) {
        this.elements.add(element);
    }
}

