/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo.tags.core.collections;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import shohaku.core.lang.Eval;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.tags.AbstractValueTag;

public class ArrayTag
extends AbstractValueTag {
    private Class type = null;
    private final List elements = new LinkedList();

    protected Object generateValue() {
        Object array;
        if (this.type == null) {
            throw new GinkgoException("type is empty.");
        }
        if (!Eval.isArrayClass((Class)this.type)) {
            throw new GinkgoException("no Array class. " + this.type.getClass());
        }
        int index = 0;
        try {
            array = Array.newInstance(this.type.getComponentType(), this.elements.size());
            Iterator i = this.elements.iterator();
            while (i.hasNext()) {
                Array.set(array, index, i.next());
                ++index;
            }
        }
        catch (IllegalArgumentException e) {
            throw new GinkgoException("Illegal Array element type. " + this.type.getClass() + ", " + this.elements.get(index), e);
        }
        return array;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public Class getType() {
        return this.type;
    }

    public void addElementTransferValue(Object element) {
        this.elements.add(element);
    }
}

