/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo.rule;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import shohaku.core.helpers.HClass;
import shohaku.core.helpers.HCnv;
import shohaku.core.helpers.HCoder;
import shohaku.core.helpers.HCut;
import shohaku.core.helpers.HLog;
import shohaku.core.lang.Closure;
import shohaku.core.lang.Eval;
import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.lang.ObjectCreationException;
import shohaku.core.lang.ObjectCreationProxy;
import shohaku.core.lang.Predicate;
import shohaku.core.lang.ValueOf;
import shohaku.core.lang.feature.FeatureFactory;
import shohaku.core.resource.IOResource;
import shohaku.core.resource.IOResourceLoader;
import shohaku.ginkgo.Document;
import shohaku.ginkgo.DocumentContext;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.TagContext;
import shohaku.ginkgo.TagNode;
import shohaku.ginkgo.rule.OgdlContextImpl;
import shohaku.ginkgo.type.EvaluationValue;
import shohaku.ginkgo.type.ExpressionValue;
import shohaku.ginkgo.type.IterateValue;
import shohaku.ginkgo.type.ReferenceValue;
import shohaku.ogdl.Ogdl;
import shohaku.ogdl.OgdlContext;
import shohaku.ogdl.OgdlParseIndex;
import shohaku.ogdl.OgdlSyntaxException;

class TypeTransformHelper {
    static final Pattern TRUE_PATTERN = Pattern.compile("(?i)true|yes|on");
    static final Pattern BOOL_PATTERN = Pattern.compile("(?i)true|false|yes|no|on|off");
    static final Pattern NUMBER_FORMAT_PATTERN;
    static final Pattern NUMBER_REMOVE_PATTERN;

    TypeTransformHelper() {
    }

    static Boolean toBoolean(String value) {
        if (!TypeTransformHelper.isBoolean(value)) {
            throw new GinkgoException("illegal format of Boolean. " + value);
        }
        return TRUE_PATTERN.matcher(value).matches();
    }

    static Character toCharacter(String value) {
        if (Eval.isBlank((CharSequence)value)) {
            throw new GinkgoException("text isn't specified.");
        }
        String schar = value;
        if (Eval.isEnclose((CharSequence)schar, (char)'\'', (char)'\'')) {
            schar = (String)HCut.cut((CharSequence)schar, (int)1, (int)1);
        }
        if (schar.length() > 1) {
            try {
                schar = HCoder.decodeUnicodeEscapes((CharSequence)schar);
            }
            catch (IllegalArgumentException e) {
                throw new GinkgoException("illegal format of Character. " + schar);
            }
            if (schar.length() != 1) {
                throw new GinkgoException("not one Character. " + schar);
            }
        }
        return new Character(schar.charAt(0));
    }

    static String toString(String value) {
        return value;
    }

    static Byte toByte(String value) {
        try {
            String numValue = TypeTransformHelper.getNumberString(value);
            return Byte.decode(numValue);
        }
        catch (NumberFormatException e) {
            throw new GinkgoException("illegal format of Byte. " + value, e);
        }
    }

    static Short toShort(String value) {
        try {
            String numValue = TypeTransformHelper.getNumberString(value);
            return Short.decode(numValue);
        }
        catch (NumberFormatException e) {
            throw new GinkgoException("illegal format of Short. " + value, e);
        }
    }

    static Integer toInteger(String value) {
        try {
            String numValue = TypeTransformHelper.getNumberString(value);
            return Integer.decode(numValue);
        }
        catch (NumberFormatException e) {
            throw new GinkgoException("illegal format of Integer. " + value, e);
        }
    }

    static Long toLong(String value) {
        try {
            String numValue = TypeTransformHelper.getNumberString(value);
            return Long.decode(numValue);
        }
        catch (NumberFormatException e) {
            throw new GinkgoException("illegal format of Long. " + value, e);
        }
    }

    static Float toFloat(String value) {
        try {
            String numValue = TypeTransformHelper.getNumberString(value);
            return Float.valueOf(numValue);
        }
        catch (NumberFormatException e) {
            throw new GinkgoException("illegal format of Float. " + value, e);
        }
    }

    static Double toDouble(String value) {
        try {
            String numValue = TypeTransformHelper.getNumberString(value);
            return Double.valueOf(numValue);
        }
        catch (NumberFormatException e) {
            throw new GinkgoException("illegal format of Double. " + value, e);
        }
    }

    static BigInteger toBigInteger(String value) {
        try {
            String numValue = TypeTransformHelper.getNumberString(value);
            return new BigInteger(numValue);
        }
        catch (NumberFormatException e) {
            throw new GinkgoException("illegal format of java.math.BigInteger. " + value, e);
        }
    }

    static BigDecimal toBigDecimal(String value) {
        try {
            String numValue = TypeTransformHelper.getNumberString(value);
            return new BigDecimal(numValue);
        }
        catch (NumberFormatException e) {
            throw new GinkgoException("illegal format of java.math.BigDecimal. " + value, e);
        }
    }

    static Pattern toRegexPattern(String value) {
        try {
            return Pattern.compile(value);
        }
        catch (PatternSyntaxException e) {
            throw new GinkgoException("regex syntax error. " + value, e);
        }
    }

    static Properties toProperties(TagNode tag, String value) {
        return TypeTransformHelper.toProperties(tag, null, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Properties toProperties(TagNode tag, Properties defaults, String value) {
        Properties properties;
        InputStream inStream = null;
        try {
            try {
                IOResource ioResource = TypeTransformHelper.getIOResource(tag, value);
                inStream = ioResource.getInputStream();
                Properties properties2 = defaults == null ? new Properties() : new Properties(defaults);
                properties2.load(inStream);
                properties = properties2;
                Object var8_9 = null;
            }
            catch (IOException e) {
                throw new GinkgoException("load Properties err. " + value, e);
            }
            catch (URISyntaxException e) {
                throw new GinkgoException("load Properties err. " + value, e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (inStream == null) throw throwable;
                inStream.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return properties;
        }
        if (inStream == null) return properties;
        inStream.close();
        return properties;
    }

    static File toFile(String value) {
        try {
            return new File(value);
        }
        catch (NullPointerException e) {
            throw new GinkgoException("file path is null. " + value, e);
        }
    }

    static URI toURI(String value) {
        try {
            return new URI(value);
        }
        catch (URISyntaxException e) {
            throw new GinkgoException("illegal URI format. " + value, e);
        }
    }

    static Date toDateTime(String value) {
        try {
            return HCnv.asDataObject((Object)ValueOf.decodeDateTime((String)value));
        }
        catch (IllegalArgumentException e) {
            throw new GinkgoException("illegal Date format. value:" + value);
        }
    }

    static ReferenceValue toReferenceValue(TagNode tag, String value) {
        if (TypeTransformHelper.isContainsReferenceId(tag, value)) {
            Object resultValue = TypeTransformHelper.getReferenceValue(tag.getTagContext().getDocument(), value);
            return new ReferenceValue(value, resultValue);
        }
        return null;
    }

    static Object getReferenceValue(Document doc, String name) {
        Object resultValue = doc.getTagValueById(name);
        if (resultValue instanceof ObjectCreationProxy) {
            try {
                resultValue = ((ObjectCreationProxy)resultValue).create();
            }
            catch (ObjectCreationException e) {
                throw new GinkgoException(HLog.list((String)"object creation error. ", (Object)doc, (Object)name), e);
            }
        }
        return resultValue;
    }

    static Class toClass(TagNode tag, String value) {
        if (Eval.isBlank((CharSequence)value)) {
            return null;
        }
        return TypeTransformHelper.loadClass(tag.getTagContext(), value);
    }

    static ExpressionValue toExpressionValue(TagNode tag, String value) {
        try {
            OgdlContext context = TypeTransformHelper.getOgdlContext(tag.getTagContext().getDocument());
            Ogdl ogdl = new Ogdl();
            ogdl.setContext(context);
            context.setClassLoader(tag.getTagContext().getClassLoader());
            Object resultValue = ogdl.evaluate(value);
            return new ExpressionValue(value, resultValue);
        }
        catch (OgdlSyntaxException e) {
            throw new GinkgoException("expression err. " + value, e);
        }
    }

    static String toEmbeddedExpressionString(TagNode tag, String value) {
        return TypeTransformHelper.toEmbeddedExpressionString(tag.getTagContext().getDocument(), value);
    }

    static String toEmbeddedExpressionString(Document doc, String value) {
        int off = value.indexOf("#{");
        if (off >= 0) {
            try {
                OgdlContext context = TypeTransformHelper.getOgdlContext(doc);
                StringBuffer sb = new StringBuffer(value.length());
                sb.append(value.substring(0, off));
                Ogdl ogdl = new Ogdl();
                ogdl.setContext(context);
                context.setClassLoader(doc.getContext().getClassLoader());
                off += "#{".length();
                while (off >= 0) {
                    OgdlParseIndex varoff = new OgdlParseIndex(off);
                    Object ogdlValue = ogdl.evaluate(value, varoff);
                    off = varoff.get();
                    if ('}' != value.charAt(off)) {
                        throw new GinkgoException("not find el close literal. offset=" + off + ", value=" + value);
                    }
                    sb.append(ogdlValue);
                    int next = value.indexOf("#{", ++off);
                    if (next >= 0) {
                        sb.append(value.substring(off, next));
                        next += "#{".length();
                    } else {
                        sb.append(value.substring(off));
                    }
                    off = next;
                }
                return sb.toString();
            }
            catch (OgdlSyntaxException e) {
                throw new GinkgoException("el error. offset=" + off + ", value=" + value, e);
            }
        }
        return value;
    }

    static IterateValue toIterateValue(Object o) {
        return new IterateValue(o);
    }

    static EvaluationValue toEvaluationValue(TagNode tag, String value) {
        OgdlContext context = TypeTransformHelper.getOgdlContext(tag.getTagContext().getDocument());
        final String expression = value;
        final Ogdl ogdl = new Ogdl();
        ogdl.setContext(context);
        context.setClassLoader(tag.getTagContext().getClassLoader());
        Predicate predicate = new Predicate(){

            public boolean evaluate(Object o) {
                try {
                    Object resultValue = ogdl.evaluate(expression);
                    return Boolean.TRUE.equals(resultValue);
                }
                catch (OgdlSyntaxException e) {
                    throw new GinkgoException("expression err. " + expression, e);
                }
            }
        };
        return new EvaluationValue(predicate);
    }

    static IOResource toIOResource(TagNode tag, String value) {
        try {
            return TypeTransformHelper.getIOResource(tag, value);
        }
        catch (IOException e) {
            throw new GinkgoException("IOResource initialize error. " + value, e);
        }
        catch (URISyntaxException e) {
            throw new GinkgoException("IOResource initialize error. " + value, e);
        }
    }

    private static IOResource getIOResource(TagNode tag, String url) throws IOException, URISyntaxException {
        IOResourceLoader ioResourceLoader = TypeTransformHelper.getIOResourceLoader(tag);
        return ioResourceLoader.getIOResource(url);
    }

    private static IOResourceLoader getIOResourceLoader(TagNode tag) {
        IOResourceLoader ioResourceLoader = tag.getTagContext().getGinkgo().getIOResourceLoader();
        if (ioResourceLoader == null) {
            ioResourceLoader = FeatureFactory.getLoader().getIOResourceLoader();
        }
        ClassLoader classLoader = tag.getTagContext().getClassLoader();
        ioResourceLoader.setClassLoader(classLoader);
        return ioResourceLoader;
    }

    private static OgdlContext getOgdlContext(Document doc) {
        return new OgdlContextImpl(doc);
    }

    private static boolean isBoolean(String value) {
        return BOOL_PATTERN.matcher(value).matches();
    }

    private static String getNumberString(String value) {
        if (NUMBER_FORMAT_PATTERN.matcher(value).matches()) {
            return NUMBER_REMOVE_PATTERN.matcher(value).replaceAll("");
        }
        throw new NumberFormatException("value:" + value);
    }

    private static Class loadClass(TagContext context, String className) {
        try {
            final DocumentContext _context = context.getDocumentContext();
            return HClass.load((String)className, (ClassLoader)context.getClassLoader(), (Closure)new Closure(){

                public Object evaluate(Object o) {
                    return _context.forClass((String)o);
                }
            });
        }
        catch (NoSuchResourceException e) {
            throw new GinkgoException("Class couldn't be created. name:" + className, e);
        }
    }

    private static boolean isContainsReferenceId(TagNode tag, String id) {
        return !Eval.isBlank((CharSequence)id) && tag.getTagContext().getDocument().containsId(id);
    }

    static {
        StringBuffer sb = new StringBuffer();
        sb.append("(?:");
        sb.append("[-+]?Infinity");
        sb.append("|");
        sb.append("[-+]?NaN");
        sb.append("|");
        sb.append("[-+]?(?:[\\p{Digit}]|0|0X|0x|\\.)(?:(?:[\\p{XDigit},]|[eE][-+])*)");
        sb.append("(?:\\.(?:[\\p{Digit}]|[eE][-+])*)?");
        sb.append("[lLfFdD]?");
        sb.append(")");
        NUMBER_FORMAT_PATTERN = Pattern.compile(sb.toString());
        NUMBER_REMOVE_PATTERN = Pattern.compile("^\\+|,");
    }
}

