/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo.rule;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import shohaku.core.beans.DefaultTypeTransformer;
import shohaku.core.functor.FTransformer;
import shohaku.core.functor.FunctorException;
import shohaku.core.helpers.HBeans;
import shohaku.core.helpers.HCnv;
import shohaku.core.helpers.HCut;
import shohaku.core.lang.Eval;
import shohaku.core.lang.IntrospectionBeansException;
import shohaku.ginkgo.Document;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.TagAttributes;
import shohaku.ginkgo.TagContext;
import shohaku.ginkgo.TagNode;
import shohaku.ginkgo.TagPropertyTransfer;
import shohaku.ginkgo.ValueNode;
import shohaku.ginkgo.rule.DefaultTagPropertyTypeTransformer;
import shohaku.ginkgo.rule.TypeTransformHelper;
import shohaku.ginkgo.type.ExpressionValue;

public class DefaultTagPropertyTransfer
implements TagPropertyTransfer {
    final DefaultTypeTransformer typeTransformer;

    public DefaultTagPropertyTransfer() {
        this(new DefaultTagPropertyTypeTransformer());
    }

    public DefaultTagPropertyTransfer(DefaultTypeTransformer transformer) {
        this.typeTransformer = transformer;
    }

    public void substitut(Document document, TagAttributes atts) {
        for (int i = 0; i < atts.getLength(); ++i) {
            String value = atts.getValue(i);
            if (this.isExpressionValue(value)) continue;
            value = TypeTransformHelper.toEmbeddedExpressionString(document, value);
            atts.setValue(i, value);
        }
    }

    public void substitut(Document document, StringBuffer text) {
        String value = text.toString();
        if (!this.isExpressionValue(value)) {
            value = TypeTransformHelper.toEmbeddedExpressionString(document, value);
            text.setLength(value.length());
            text.replace(0, value.length(), value);
        }
    }

    public void setAttributes(TagNode tag) {
        TagContext context = tag.getTagContext();
        try {
            Class<?> tagType = tag.getClass();
            Map pds = HBeans.getPropertyDescriptorMap(tagType);
            Iterator i = context.getAttributeMapView().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                String propertyName = this.getPropertyName((String)e.getKey());
                PropertyDescriptor pd = (PropertyDescriptor)pds.get(propertyName);
                if (pd == null || pd.getWriteMethod() == null) continue;
                this.setProperty(tag, pd, (String)e.getValue());
            }
        }
        catch (FunctorException e) {
            throw new GinkgoException("attributes transfer functor error. " + tag.getClass() + ", " + context.getTagAttributes(), e);
        }
        catch (IntrospectionBeansException e) {
            throw new GinkgoException("tag introspection error. " + tag.getClass() + ", " + context.getTagAttributes(), e);
        }
    }

    public void setText(TagNode tag) {
        TagContext context = tag.getTagContext();
        Class<?> tagType = tag.getClass();
        try {
            PropertyDescriptor pd = HBeans.getPropertyDescriptor(tagType, (String)"textTransferValue");
            if (pd != null && pd.getWriteMethod() != null) {
                this.setProperty(tag, pd, context.getTextNode().getText());
            }
        }
        catch (FunctorException e) {
            throw new GinkgoException("transform functor error. " + tagType + ", " + context.getTagAttributes(), e);
        }
        catch (IntrospectionBeansException e) {
            throw new GinkgoException("tag introspection error. " + tagType + ", " + context.getTagAttributes(), e);
        }
    }

    public void addElement(TagNode tag, TagNode element) {
        if (!(element instanceof ValueNode)) {
            return;
        }
        String propertyName = this.getPropertyName(tag.getTagContext().getTagName());
        Class<?> tagType = tag.getClass();
        Object value = ((ValueNode)((Object)element)).getNodeValue();
        try {
            String methodName = HBeans.propertyAsMethodName((String)"add", (String)propertyName);
            if (HBeans.containsMethod(tagType, (String)methodName)) {
                this.invokeMethod(tagType, tag, methodName, value);
                return;
            }
            if (HBeans.containsAccessibleMethod(tagType, (String)"addElementTransferValue")) {
                this.invokeAccessibleMethod(tagType, tag, "addElementTransferValue", value);
                return;
            }
        }
        catch (IntrospectionBeansException e) {
            throw new GinkgoException("tag introspection error. " + tag.getClass() + ", " + element, e);
        }
    }

    public FTransformer add(Class clazz, FTransformer transformer) {
        return this.typeTransformer.add(clazz, transformer);
    }

    public void clear() {
        this.typeTransformer.clear();
    }

    public FTransformer remove(Class clazz) {
        return this.typeTransformer.remove(clazz);
    }

    private String getPropertyName(String propertyName) {
        if (propertyName.equals("class")) {
            return "clazz";
        }
        if (Eval.isContains((String)propertyName, (char)'-')) {
            StringBuffer sb = new StringBuffer();
            String[] elems = propertyName.split("-");
            sb.append(elems[0]);
            for (int i = 1; i < elems.length; ++i) {
                sb.append(HCnv.capitalize((String)elems[i]));
            }
            return sb.toString();
        }
        return propertyName;
    }

    private void invokeMethod(Class clazz, Object o, String methodName, Object value) throws IntrospectionBeansException {
        Class paramType = value != null ? value.getClass() : Object.class;
        Method method = null;
        try {
            method = HBeans.getAssignmentMethod((Class)clazz, (String)methodName, (Class[])new Class[]{paramType});
        }
        catch (IntrospectionBeansException e) {
            throw new GinkgoException(methodName + " illegal type. " + paramType, e);
        }
        if (method != null) {
            HBeans.invokeMethod((Object)o, (Method)method, (Object)value);
        }
    }

    private void invokeAccessibleMethod(Class clazz, Object o, String methodName, Object value) throws IntrospectionBeansException {
        Class paramType = value != null ? value.getClass() : Object.class;
        Method method = null;
        try {
            method = HBeans.getAssignmentAccessibleMethod((Class)clazz, (String)methodName, (Class[])new Class[]{paramType});
        }
        catch (IntrospectionBeansException e) {
            throw new GinkgoException(methodName + " illegal type. " + paramType, e);
        }
        if (method != null) {
            HBeans.invokeMethod((Object)o, (Method)method, (Object)value);
        }
    }

    private boolean isExpressionValue(String attributeValue) {
        return Eval.isEnclose((CharSequence)attributeValue, (CharSequence)"${", (CharSequence)"}");
    }

    private Object executeExpression(TagNode tag, String attributeValue) {
        String value = (String)HCut.cut((CharSequence)attributeValue, (int)2, (int)1);
        ExpressionValue expValue = TypeTransformHelper.toExpressionValue(tag, value);
        return expValue.getResultValue();
    }

    private void setProperty(TagNode tag, PropertyDescriptor pd, String value) throws IntrospectionBeansException {
        Object propertyValue = this.getPropertyValue(tag, pd.getPropertyType(), value);
        HBeans.setProperty((Object)tag, (PropertyDescriptor)pd, (Object)propertyValue);
    }

    private Object getPropertyValue(TagNode tag, Class clazz, String value) {
        Object propertyValue = value;
        if (this.isExpressionValue(value)) {
            propertyValue = this.executeExpression(tag, value);
            if (!clazz.isInstance(propertyValue)) {
                propertyValue = this.getTransformValue(tag, clazz, propertyValue);
            }
        } else {
            propertyValue = this.getTransformValue(tag, clazz, propertyValue);
        }
        return propertyValue;
    }

    private Object getTransformValue(TagNode tag, Class clazz, Object value) {
        Object propertyValue = value;
        FTransformer transformer = this.typeTransformer.find(clazz);
        if (transformer != null) {
            Map<Class, TagNode> args = Collections.singletonMap(TagNode.class, tag);
            propertyValue = transformer.transform(value, args);
        }
        return propertyValue;
    }
}

