/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo.rule;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import shohaku.core.lang.Eval;
import shohaku.ginkgo.Ginkgo;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.NodeCompositeRule;
import shohaku.ginkgo.SAXDocumentParser;
import shohaku.ginkgo.TagPropertyTransfer;
import shohaku.ginkgo.TagRule;
import shohaku.ginkgo.TagRuleSet;
import shohaku.ginkgo.rule.DefaultTagPropertyTransfer;

public class DefaultNodeCompositeRule
implements NodeCompositeRule {
    private Boolean validating;
    private Boolean namespaceAware;
    private EntityResolver entityResolver;
    private DTDHandler dtdHandler;
    private ErrorHandler errorHandler;
    private Map features = new HashMap();
    private Map tagRuleSetNSMap = new HashMap();
    private TagPropertyTransfer tagPropertyTransfer;

    public TagRule findTagRule(String namespaceURI, String nodeURI, String tagName) {
        String nsuri = !Eval.isBlank((CharSequence)namespaceURI) ? namespaceURI : "";
        TagRuleSet tagRuleSet = (TagRuleSet)this.tagRuleSetNSMap.get(nsuri);
        if (tagRuleSet != null) {
            Iterator i = tagRuleSet.iterator();
            while (i.hasNext()) {
                TagRule tagRule = (TagRule)i.next();
                String pattern = tagRule.getPattern();
                if (!pattern.equals("*") && !nodeURI.endsWith(pattern)) continue;
                return tagRule;
            }
        }
        return null;
    }

    public void addTagRule(String namespaceURI, TagRuleSet tagRuleSet) {
        String nsuri = namespaceURI != null ? namespaceURI : "";
        this.tagRuleSetNSMap.put(nsuri, tagRuleSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFeature(Class id) {
        Map map = this.features;
        synchronized (map) {
            return this.features.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeature(Class id, Object feature) {
        if (!id.isInstance(feature)) {
            throw new GinkgoException("not assignable class, id:" + id + " , feature:" + feature);
        }
        Map map = this.features;
        synchronized (map) {
            this.features.put(id, feature);
        }
    }

    public TagPropertyTransfer getTagPropertyTransfer() {
        if (this.tagPropertyTransfer != null) {
            return this.tagPropertyTransfer;
        }
        return new DefaultTagPropertyTransfer();
    }

    public void setTagPropertyTransfer(TagPropertyTransfer tagAttributesTransfer) {
        this.tagPropertyTransfer = tagAttributesTransfer;
    }

    public void prepare(Ginkgo ginkgo) {
        ErrorHandler _errorHandler;
        DTDHandler _dtdHandler;
        EntityResolver _entityResolver;
        Boolean _namespaceAware;
        SAXDocumentParser _saxDocumentParser = ginkgo.getSAXDocumentParser();
        Boolean _validating = this.getValidating();
        if (_validating != null) {
            _saxDocumentParser.setValidating(_validating);
        }
        if ((_namespaceAware = this.getNamespaceAware()) != null) {
            _saxDocumentParser.setNamespaceAware(_namespaceAware);
        }
        if ((_entityResolver = this.getEntityResolver()) != null) {
            _saxDocumentParser.setEntityResolver(_entityResolver);
        }
        if ((_dtdHandler = this.getDTDHandler()) != null) {
            _saxDocumentParser.setDTDHandler(_dtdHandler);
        }
        if ((_errorHandler = this.getErrorHandler()) != null) {
            _saxDocumentParser.setErrorHandler(_errorHandler);
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        this.dtdHandler = dtdHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setValidating(Boolean validating) {
        this.validating = validating;
    }

    public Boolean getValidating() {
        return this.validating;
    }

    public void setNamespaceAware(Boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public Boolean getNamespaceAware() {
        return this.namespaceAware;
    }
}

