/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo;

import org.xml.sax.Attributes;
import shohaku.core.lang.Eval;

public class TagAttributes {
    private String[] values;

    public TagAttributes() {
        this.values = new String[0];
    }

    public TagAttributes(Attributes attributes) {
        int size = attributes.getLength();
        this.values = new String[size * 5];
        int k = 0;
        for (int i = 0; i < size; ++i) {
            this.values[k++] = attributes.getLocalName(i);
            this.values[k++] = attributes.getQName(i);
            this.values[k++] = attributes.getType(i);
            this.values[k++] = attributes.getURI(i);
            this.values[k++] = attributes.getValue(i);
        }
    }

    public TagAttributes(TagAttributes tagAttributes) {
        this.values = new String[tagAttributes.values.length];
        System.arraycopy(tagAttributes.values, 0, this.values, 0, this.values.length);
    }

    public int getLength() {
        return this.values.length / 5;
    }

    public String getLocalName(int index) {
        if (!Eval.isRange((int)index, (int)0, (int)(this.getLength() - 1))) {
            return null;
        }
        return this.values[index * 5 + 0];
    }

    public String getQName(int index) {
        if (!Eval.isRange((int)index, (int)0, (int)(this.getLength() - 1))) {
            return null;
        }
        return this.values[index * 5 + 1];
    }

    public String getType(int index) {
        if (!Eval.isRange((int)index, (int)0, (int)(this.getLength() - 1))) {
            return null;
        }
        return this.values[index * 5 + 2];
    }

    public String getURI(int index) {
        if (!Eval.isRange((int)index, (int)0, (int)(this.getLength() - 1))) {
            return null;
        }
        return this.values[index * 5 + 3];
    }

    public String getValue(int index) {
        if (!Eval.isRange((int)index, (int)0, (int)(this.getLength() - 1))) {
            return null;
        }
        return this.values[index * 5 + 4];
    }

    public int getIndex(String qName) {
        return this.findIndexByQName(qName);
    }

    public String getType(String qName) {
        int index = this.findIndexByQName(qName);
        if (index < 0) {
            return null;
        }
        return this.getType(index);
    }

    public String getValue(String qName) {
        int index = this.findIndexByQName(qName);
        if (index < 0) {
            return null;
        }
        return this.getValue(index);
    }

    private int findIndexByQName(String qName) {
        int size = this.getLength();
        for (int i = 0; i < size; ++i) {
            if (!qName.equals(this.getQName(i))) continue;
            return i;
        }
        return -1;
    }

    public void setValue(int index, String value) {
        if (!Eval.isRange((int)index, (int)0, (int)(this.getLength() - 1))) {
            throw new IllegalArgumentException();
        }
        this.values[index * 5 + 4] = value;
    }

    public void setValue(String qName, String value) {
        int index = this.findIndexByQName(qName);
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        this.values[index * 5 + 4] = value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append('{');
        for (int i = 0; i < this.values.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append('{');
            sb.append("LocalName").append('=').append(this.values[i++]).append(',');
            sb.append("QName").append('=').append(this.values[i++]).append(',');
            sb.append("Type").append('=').append(this.values[i++]).append(',');
            sb.append("URI").append('=').append(this.values[i++]).append(',');
            sb.append("Value").append('=').append(this.values[i]);
            sb.append('}');
        }
        sb.append('}');
        return sb.toString();
    }
}

