/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import shohaku.core.lang.feature.FeatureFactory;
import shohaku.core.lang.feature.LogFeature;
import shohaku.core.resource.IOResourceLoader;
import shohaku.ginkgo.Document;
import shohaku.ginkgo.DocumentCompositeRule;
import shohaku.ginkgo.DocumentCompositeRuleImpl;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.NodeCompositeRule;
import shohaku.ginkgo.SAXDocumentParser;

public class Ginkgo {
    private static final LogFeature defaultLogger = FeatureFactory.getLog((Class)Ginkgo.class);
    private final SAXDocumentParser saxDocumentParser;
    private DocumentCompositeRule documentCompositeRule;
    private NodeCompositeRule nodeCompositeRule;
    private Document parentDocument;
    private LogFeature logger;
    private IOResourceLoader ioResourceLoader;
    private ClassLoader classLoader;
    private boolean errThrowable;
    private Locale locale;
    private Document document;

    public Ginkgo() {
        this(Ginkgo.getDefaultDocumentCompositeRule());
    }

    public Ginkgo(DocumentCompositeRule docRule) {
        if (null == docRule) {
            throw new NullPointerException("DocumentCompositeRule is null.");
        }
        this.documentCompositeRule = docRule;
        this.logger = null;
        this.saxDocumentParser = new SAXDocumentParser(this);
        this.classLoader = null;
        this.nodeCompositeRule = null;
        this.errThrowable = false;
    }

    public void parse(InputStream inStream) {
        this.parse(new InputSource(inStream));
    }

    public void parse(InputSource input) {
        if (null == input) {
            throw new NullPointerException("input source is null.");
        }
        if (null == this.nodeCompositeRule) {
            throw new NullPointerException("this.nodeCompositeRule is null.");
        }
        Document parent = this.getParentDocument();
        if (parent != null && !parent.isPreserve()) {
            parent = parent.getPreserveDocument();
        }
        this.document = new Document(this, this.nodeCompositeRule, parent);
        this.nodeCompositeRule.prepare(this);
        try {
            this.getSAXDocumentParser().parse(input);
        }
        catch (SAXException e) {
            throw new GinkgoException("ginkgo parse err.", e);
        }
        catch (IOException e) {
            throw new GinkgoException("ginkgo parse err.", e);
        }
    }

    public SAXDocumentParser getSAXDocumentParser() {
        return this.saxDocumentParser;
    }

    public Document getDocument() {
        return this.document;
    }

    public LogFeature getLogger() {
        return this.logger != null ? this.logger : defaultLogger;
    }

    public void setLogger(LogFeature log) {
        this.logger = log;
    }

    public IOResourceLoader getIOResourceLoader() {
        return this.ioResourceLoader;
    }

    public void setIOResourceLoader(IOResourceLoader loader) {
        this.ioResourceLoader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader != null ? this.classLoader : this.getClass().getClassLoader();
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public boolean isErrThrowable() {
        return this.errThrowable;
    }

    public void setErrThrowable(boolean errThrowable) {
        this.errThrowable = errThrowable;
    }

    public Locale getLocale() {
        return this.locale != null ? this.locale : Locale.getDefault();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public DocumentCompositeRule getDocumentCompositeRule() {
        return this.documentCompositeRule;
    }

    public void setDocumentCompositeRule(DocumentCompositeRule docRule) {
        if (null == docRule) {
            throw new NullPointerException("DocumentCompositeRule is null.");
        }
        this.documentCompositeRule = docRule;
    }

    public NodeCompositeRule getNodeCompositeRule() {
        return this.nodeCompositeRule;
    }

    public void setNodeCompositeRule(NodeCompositeRule nodeCompositeRule) {
        if (null == nodeCompositeRule) {
            throw new NullPointerException("NodeCompositeRule is null.");
        }
        this.nodeCompositeRule = nodeCompositeRule;
    }

    public Document getParentDocument() {
        return this.parentDocument;
    }

    public void setParentDocument(Document parentDocument) {
        this.parentDocument = parentDocument;
    }

    static DocumentCompositeRule getDefaultDocumentCompositeRule() {
        return new DocumentCompositeRuleImpl();
    }
}

