/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

final class Widening {
    static final BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    static final BigInteger LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    static final BigInteger INT_MAX_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    static final BigInteger INT_MIN_VALUE = BigInteger.valueOf(Integer.MIN_VALUE);
    static final BigInteger SHORT_MAX_VALUE = BigInteger.valueOf(32767L);
    static final BigInteger SHORT_MIN_VALUE = BigInteger.valueOf(-32768L);
    static final BigInteger BYTE_MAX_VALUE = BigInteger.valueOf(127L);
    static final BigInteger BYTE_MIN_VALUE = BigInteger.valueOf(-128L);
    public static final int TYPE_BIGDECIMAL = 0;
    public static final int TYPE_BIGINTEGER = 1;
    public static final int TYPE_DOUBLE = 2;
    public static final int TYPE_FLOAT = 3;
    public static final int TYPE_LONG = 4;
    public static final int TYPE_INTEGER = 5;

    Widening() {
    }

    public static Short widenShort(Byte num) {
        return Widening.toShort(num);
    }

    public static Integer widenInteger(Character ch) {
        return new Integer(ch.charValue());
    }

    public static Integer widenInteger(Byte num) {
        return Widening.toInteger(num);
    }

    public static Integer widenInteger(Short num) {
        return Widening.toInteger(num);
    }

    public static Long widenLong(Character ch) {
        return new Long(ch.charValue());
    }

    public static Long widenLong(Byte num) {
        return Widening.toLong(num);
    }

    public static Long widenLong(Short num) {
        return Widening.toLong(num);
    }

    public static Long widenLong(Integer num) {
        return Widening.toLong(num);
    }

    public static BigInteger widenBigInteger(Long num) {
        return Widening.toBigInteger(num);
    }

    public static BigInteger widenBigInteger(Character ch) {
        return BigInteger.valueOf(ch.charValue());
    }

    public static BigInteger widenBigInteger(Byte num) {
        return Widening.toBigInteger(num);
    }

    public static BigInteger widenBigInteger(Short num) {
        return Widening.toBigInteger(num);
    }

    public static BigInteger widenBigInteger(Integer num) {
        return Widening.toBigInteger(num);
    }

    public static Float widenFloat(Character ch) {
        return new Float(ch.charValue());
    }

    public static Float widenFloat(Byte num) {
        return Widening.toFloat(num);
    }

    public static Float widenFloat(Short num) {
        return Widening.toFloat(num);
    }

    public static Float widenFloat(Integer num) {
        return Widening.toFloat(num);
    }

    public static Float widenFloat(Long num) {
        return Widening.toFloat(num);
    }

    public static Double widenDouble(Character ch) {
        return new Double(ch.charValue());
    }

    public static Double widenDouble(Byte num) {
        return Widening.toDouble(num);
    }

    public static Double widenDouble(Short num) {
        return Widening.toDouble(num);
    }

    public static Double widenDouble(Integer num) {
        return Widening.toDouble(num);
    }

    public static Double widenDouble(Long num) {
        return Widening.toDouble(num);
    }

    public static Double widenDouble(Float num) {
        return Widening.toDouble(num);
    }

    public static BigDecimal widenBigDecimal(Character ch) {
        return BigDecimal.valueOf(ch.charValue());
    }

    public static BigDecimal widenBigDecimal(Byte num) {
        return Widening.toBigDecimal(num);
    }

    public static BigDecimal widenBigDecimal(Short num) {
        return Widening.toBigDecimal(num);
    }

    public static BigDecimal widenBigDecimal(Integer num) {
        return Widening.toBigDecimal(num);
    }

    public static BigDecimal widenBigDecimal(Long num) {
        return Widening.toBigDecimal(num);
    }

    public static BigDecimal widenBigDecimal(Float num) {
        return Widening.toBigDecimal(num);
    }

    public static BigDecimal widenBigDecimal(Double num) {
        return Widening.toBigDecimal(num);
    }

    public static BigDecimal widenBigDecimal(BigInteger num) {
        return Widening.toBigDecimal(num);
    }

    public static Number widenType(Number num, Class forType) {
        Class<?> numType = num.getClass();
        if (BigDecimal.class.equals(forType)) {
            if (WidenBigDecimalTypeCache.cache.contains(numType)) {
                return Widening.toBigDecimal(num);
            }
        } else if (BigInteger.class.equals(forType)) {
            if (WidenBigIntegerTypeCache.cache.contains(numType)) {
                return Widening.toBigInteger(num);
            }
        } else if (Double.class.equals(forType)) {
            if (WidenDoubleTypeCache.cache.contains(numType)) {
                return Widening.toDouble(num);
            }
        } else if (Float.class.equals(forType)) {
            if (WidenFloatTypeCache.cache.contains(numType)) {
                return Widening.toFloat(num);
            }
        } else if (Long.class.equals(forType)) {
            if (WidenLongTypeCache.cache.contains(numType)) {
                return Widening.toLong(num);
            }
        } else if (Integer.class.equals(forType)) {
            if (WidenIntegerTypeCache.cache.contains(numType)) {
                return Widening.toInteger(num);
            }
        } else if (Short.class.equals(forType) && WidenShortTypeCache.cache.contains(numType)) {
            return Widening.toShort(num);
        }
        throw new IllegalArgumentException("widening error. " + num + "," + forType);
    }

    public static Character narrowCharacter(Byte num) {
        return Widening.toCharacter(num);
    }

    public static Character narrowCharacter(Short num) {
        return Widening.toCharacter(num);
    }

    public static Character narrowCharacter(Integer num) {
        return Widening.toCharacter(num);
    }

    public static Character narrowCharacter(Long num) {
        return Widening.toCharacter(num);
    }

    public static Character narrowCharacter(Float num) {
        return Widening.toCharacter(num);
    }

    public static Character narrowCharacter(Double num) {
        return Widening.toCharacter(num);
    }

    public static Character narrowCharacter(BigInteger num) {
        return Widening.toCharacter(num);
    }

    public static Character narrowCharacter(BigDecimal num) {
        return Widening.toCharacter(num);
    }

    public static Byte narrowByte(Character ch) {
        return new Byte((byte)ch.charValue());
    }

    public static Byte narrowByte(Short num) {
        return Widening.toByte(num);
    }

    public static Byte narrowByte(Integer num) {
        return Widening.toByte(num);
    }

    public static Byte narrowByte(Long num) {
        return Widening.toByte(num);
    }

    public static Byte narrowByte(Float num) {
        return Widening.toByte(num);
    }

    public static Byte narrowByte(Double num) {
        return Widening.toByte(num);
    }

    public static Byte narrowByte(BigInteger num) {
        return Widening.toByte(num);
    }

    public static Byte narrowByte(BigDecimal num) {
        return Widening.toByte(num);
    }

    public static Short narrowShort(Character ch) {
        return new Short((short)ch.charValue());
    }

    public static Short narrowShort(Integer num) {
        return Widening.toShort(num);
    }

    public static Short narrowShort(Long num) {
        return Widening.toShort(num);
    }

    public static Short narrowShort(Float num) {
        return Widening.toShort(num);
    }

    public static Short narrowShort(Double num) {
        return Widening.toShort(num);
    }

    public static Short narrowShort(BigInteger num) {
        return Widening.toShort(num);
    }

    public static Short narrowShort(BigDecimal num) {
        return Widening.toShort(num);
    }

    public static Integer narrowInteger(Long num) {
        return Widening.toInteger(num);
    }

    public static Integer narrowInteger(Float num) {
        return Widening.toInteger(num);
    }

    public static Integer narrowInteger(Double num) {
        return Widening.toInteger(num);
    }

    public static Integer narrowInteger(BigInteger num) {
        return Widening.toInteger(num);
    }

    public static Integer narrowInteger(BigDecimal num) {
        return Widening.toInteger(num);
    }

    public static Long narrowLong(Float num) {
        return Widening.toLong(num);
    }

    public static Long narrowLong(Double num) {
        return Widening.toLong(num);
    }

    public static Long narrowLong(BigInteger num) {
        return Widening.toLong(num);
    }

    public static Long narrowLong(BigDecimal num) {
        return Widening.toLong(num);
    }

    public static Float narrowFloat(Double num) {
        return Widening.toFloat(num);
    }

    public static Float narrowFloat(BigInteger num) {
        return Widening.toFloat(num);
    }

    public static Float narrowFloat(BigDecimal num) {
        return Widening.toFloat(num);
    }

    public static Double narrowDouble(BigInteger num) {
        return Widening.toDouble(num);
    }

    public static Double narrowDouble(BigDecimal num) {
        return Widening.toDouble(num);
    }

    public static BigInteger narrowBigInteger(BigDecimal num) {
        return Widening.toBigInteger(num);
    }

    public static Number narrowType(Number num, Class forType) {
        Class<?> numType = num.getClass();
        if (Byte.class.equals(forType)) {
            if (NarrowByteTypeCache.cache.contains(numType)) {
                return Widening.toByte(num);
            }
        } else if (Short.class.equals(forType)) {
            if (NarrowShortTypeCache.cache.contains(numType)) {
                return Widening.toShort(num);
            }
        } else if (Integer.class.equals(forType)) {
            if (NarrowIntegerTypeCache.cache.contains(numType)) {
                return Widening.toInteger(num);
            }
        } else if (Long.class.equals(forType)) {
            if (NarrowLongTypeCache.cache.contains(numType)) {
                return Widening.toLong(num);
            }
        } else if (Float.class.equals(forType)) {
            if (NarrowFloatTypeCache.cache.contains(numType)) {
                return Widening.toFloat(num);
            }
        } else if (Double.class.equals(forType)) {
            if (NarrowDoubleTypeCache.cache.contains(numType)) {
                return Widening.toDouble(num);
            }
        } else if (BigInteger.class.equals(forType) && NarrowBigIntegerTypeCache.cache.contains(numType)) {
            return Widening.toBigInteger(num);
        }
        throw new IllegalArgumentException("narrowing error. " + num + "," + forType);
    }

    public static boolean isNarrowByte(Short num) {
        int n = num.intValue();
        return -128 <= n && n <= 127;
    }

    public static boolean isNarrowByte(Integer num) {
        int n = num;
        return -128 <= n && n <= 127;
    }

    public static boolean isNarrowShort(Integer num) {
        int n = num;
        return Short.MIN_VALUE <= n && n <= Short.MAX_VALUE;
    }

    public static boolean isNarrowByte(Long num) {
        long n = num;
        return -128L <= n && n <= 127L;
    }

    public static boolean isNarrowShort(Long num) {
        long n = num;
        return -32768L <= n && n <= 32767L;
    }

    public static boolean isNarrowInteger(Long num) {
        long n = num;
        return Integer.MIN_VALUE <= n && n <= Integer.MAX_VALUE;
    }

    public static boolean isNarrowByte(BigInteger num) {
        return num.compareTo(BYTE_MIN_VALUE) >= 0 && num.compareTo(BYTE_MAX_VALUE) <= 0;
    }

    public static boolean isNarrowShort(BigInteger num) {
        return num.compareTo(SHORT_MIN_VALUE) >= 0 && num.compareTo(SHORT_MAX_VALUE) <= 0;
    }

    public static boolean isNarrowInteger(BigInteger num) {
        return num.compareTo(INT_MIN_VALUE) >= 0 && num.compareTo(INT_MAX_VALUE) <= 0;
    }

    public static boolean isNarrowLong(BigInteger num) {
        return num.compareTo(LONG_MIN_VALUE) >= 0 && num.compareTo(LONG_MAX_VALUE) <= 0;
    }

    public static int arithmetic(Number[] arithmetic) {
        if (arithmetic == null) {
            throw new IllegalArgumentException("widening error. arithmetic is null.");
        }
        if (arithmetic.length < 2) {
            throw new IllegalArgumentException("widening error. arithmetic.length=" + arithmetic.length);
        }
        Number n1 = arithmetic[0];
        Number n2 = arithmetic[1];
        if (Widening.isBigDecimalOperand(n1, n2)) {
            arithmetic[0] = Widening.toBigDecimal(n1);
            arithmetic[1] = Widening.toBigDecimal(n2);
            return 0;
        }
        if (n1 instanceof BigInteger || n2 instanceof BigInteger) {
            arithmetic[0] = Widening.toBigInteger(n1);
            arithmetic[1] = Widening.toBigInteger(n2);
            return 1;
        }
        if (n1 instanceof Double || n2 instanceof Double) {
            arithmetic[0] = Widening.toDouble(n1);
            arithmetic[1] = Widening.toDouble(n2);
            return 2;
        }
        if (n1 instanceof Float || n2 instanceof Float) {
            arithmetic[0] = Widening.toFloat(n1);
            arithmetic[1] = Widening.toFloat(n2);
            return 3;
        }
        if (n1 instanceof Long || n2 instanceof Long) {
            arithmetic[0] = Widening.toLong(n1);
            arithmetic[1] = Widening.toLong(n2);
            return 4;
        }
        if (Widening.isIntegerOperand(n1, n2)) {
            arithmetic[0] = Widening.toInteger(n1);
            arithmetic[1] = Widening.toInteger(n2);
            return 5;
        }
        throw new IllegalArgumentException("widening error. arithmetic= [" + n1 + "," + n2 + "]");
    }

    private static boolean isIntegerOperand(Number n1, Number n2) {
        return Widening.isIntegerOperand(n1) && Widening.isIntegerOperand(n2);
    }

    private static boolean isIntegerOperand(Number n) {
        return n instanceof Integer || n instanceof Short || n instanceof Byte;
    }

    private static boolean isBigDecimalOperand(Number n1, Number n2) {
        if (n1 instanceof BigDecimal || n2 instanceof BigDecimal) {
            return true;
        }
        if (n1 instanceof BigInteger && (n2 instanceof Double || n2 instanceof Float)) {
            return true;
        }
        return n2 instanceof BigInteger && (n1 instanceof Double || n1 instanceof Float);
    }

    private static Character toCharacter(Number num) {
        return new Character((char)num.intValue());
    }

    private static Byte toByte(Number num) {
        return num instanceof Byte ? (Byte)num : new Byte(num.byteValue());
    }

    private static Short toShort(Number num) {
        return num instanceof Short ? (Short)num : new Short(num.shortValue());
    }

    private static Integer toInteger(Number num) {
        return num instanceof Integer ? (Integer)num : new Integer(num.intValue());
    }

    private static Long toLong(Number num) {
        return num instanceof Long ? (Long)num : new Long(num.longValue());
    }

    private static Float toFloat(Number num) {
        return num instanceof Float ? (Float)num : new Float(num.floatValue());
    }

    private static Double toDouble(Number num) {
        return num instanceof Double ? (Double)num : new Double(num.doubleValue());
    }

    private static BigInteger toBigInteger(Number num) {
        return num instanceof BigInteger ? (BigInteger)num : Widening.toBigDecimal(num).toBigInteger();
    }

    private static BigDecimal toBigDecimal(Number num) {
        if (num instanceof BigDecimal) {
            return (BigDecimal)num;
        }
        if (num instanceof BigInteger) {
            return new BigDecimal((BigInteger)num);
        }
        return new BigDecimal(num.toString());
    }

    private static class NarrowBigIntegerTypeCache {
        static final Collection cache = Collections.singleton(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Widening.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);

        private NarrowBigIntegerTypeCache() {
        }
    }

    private static class NarrowDoubleTypeCache {
        static final Collection cache;

        private NarrowDoubleTypeCache() {
        }

        static {
            Class[] types = new Class[]{class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Widening.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$math$BigInteger == null ? (class$java$math$BigInteger = Widening.class$("java.math.BigInteger")) : class$java$math$BigInteger};
            cache = Collections.unmodifiableCollection(new HashSet<Class>(Arrays.asList(types)));
        }
    }

    private static class NarrowFloatTypeCache {
        static final Collection cache;

        private NarrowFloatTypeCache() {
        }

        static {
            Class[] types = new Class[]{class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Widening.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$math$BigInteger == null ? (class$java$math$BigInteger = Widening.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$java$lang$Double == null ? (class$java$lang$Double = Widening.class$("java.lang.Double")) : class$java$lang$Double};
            cache = Collections.unmodifiableCollection(new HashSet<Class>(Arrays.asList(types)));
        }
    }

    private static class NarrowLongTypeCache {
        static final Collection cache;

        private NarrowLongTypeCache() {
        }

        static {
            Class[] types = new Class[]{class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Widening.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$math$BigInteger == null ? (class$java$math$BigInteger = Widening.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$java$lang$Double == null ? (class$java$lang$Double = Widening.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Float == null ? (class$java$lang$Float = Widening.class$("java.lang.Float")) : class$java$lang$Float};
            cache = Collections.unmodifiableCollection(new HashSet<Class>(Arrays.asList(types)));
        }
    }

    private static class NarrowIntegerTypeCache {
        static final Collection cache;

        private NarrowIntegerTypeCache() {
        }

        static {
            Class[] types = new Class[]{class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Widening.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$math$BigInteger == null ? (class$java$math$BigInteger = Widening.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$java$lang$Double == null ? (class$java$lang$Double = Widening.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Float == null ? (class$java$lang$Float = Widening.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Long == null ? (class$java$lang$Long = Widening.class$("java.lang.Long")) : class$java$lang$Long};
            cache = Collections.unmodifiableCollection(new HashSet<Class>(Arrays.asList(types)));
        }
    }

    private static class NarrowShortTypeCache {
        static final Collection cache;

        private NarrowShortTypeCache() {
        }

        static {
            Class[] types = new Class[]{class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Widening.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$math$BigInteger == null ? (class$java$math$BigInteger = Widening.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$java$lang$Double == null ? (class$java$lang$Double = Widening.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Float == null ? (class$java$lang$Float = Widening.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Long == null ? (class$java$lang$Long = Widening.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Integer == null ? (class$java$lang$Integer = Widening.class$("java.lang.Integer")) : class$java$lang$Integer};
            cache = Collections.unmodifiableCollection(new HashSet<Class>(Arrays.asList(types)));
        }
    }

    private static class NarrowByteTypeCache {
        static final Collection cache;

        private NarrowByteTypeCache() {
        }

        static {
            Class[] types = new Class[]{class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Widening.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$math$BigInteger == null ? (class$java$math$BigInteger = Widening.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$java$lang$Double == null ? (class$java$lang$Double = Widening.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Float == null ? (class$java$lang$Float = Widening.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Long == null ? (class$java$lang$Long = Widening.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Integer == null ? (class$java$lang$Integer = Widening.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Short == null ? (class$java$lang$Short = Widening.class$("java.lang.Short")) : class$java$lang$Short};
            cache = Collections.unmodifiableCollection(new HashSet<Class>(Arrays.asList(types)));
        }
    }

    private static class WidenBigDecimalTypeCache {
        static final Collection cache;

        private WidenBigDecimalTypeCache() {
        }

        static {
            Class[] types = new Class[]{class$java$lang$Byte == null ? (class$java$lang$Byte = Widening.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Short == null ? (class$java$lang$Short = Widening.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Integer == null ? (class$java$lang$Integer = Widening.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = Widening.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Float == null ? (class$java$lang$Float = Widening.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Double == null ? (class$java$lang$Double = Widening.class$("java.lang.Double")) : class$java$lang$Double, class$java$math$BigInteger == null ? (class$java$math$BigInteger = Widening.class$("java.math.BigInteger")) : class$java$math$BigInteger};
            cache = Collections.unmodifiableCollection(new HashSet<Class>(Arrays.asList(types)));
        }
    }

    private static class WidenBigIntegerTypeCache {
        static final Collection cache;

        private WidenBigIntegerTypeCache() {
        }

        static {
            Class[] types = new Class[]{class$java$lang$Byte == null ? (class$java$lang$Byte = Widening.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Short == null ? (class$java$lang$Short = Widening.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Integer == null ? (class$java$lang$Integer = Widening.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = Widening.class$("java.lang.Long")) : class$java$lang$Long};
            cache = Collections.unmodifiableCollection(new HashSet<Class>(Arrays.asList(types)));
        }
    }

    private static class WidenDoubleTypeCache {
        static final Collection cache;

        private WidenDoubleTypeCache() {
        }

        static {
            Class[] types = new Class[]{class$java$lang$Byte == null ? (class$java$lang$Byte = Widening.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Short == null ? (class$java$lang$Short = Widening.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Integer == null ? (class$java$lang$Integer = Widening.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = Widening.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Float == null ? (class$java$lang$Float = Widening.class$("java.lang.Float")) : class$java$lang$Float};
            cache = Collections.unmodifiableCollection(new HashSet<Class>(Arrays.asList(types)));
        }
    }

    private static class WidenFloatTypeCache {
        static final Collection cache;

        private WidenFloatTypeCache() {
        }

        static {
            Class[] types = new Class[]{class$java$lang$Byte == null ? (class$java$lang$Byte = Widening.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Short == null ? (class$java$lang$Short = Widening.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Integer == null ? (class$java$lang$Integer = Widening.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = Widening.class$("java.lang.Long")) : class$java$lang$Long};
            cache = Collections.unmodifiableCollection(new HashSet<Class>(Arrays.asList(types)));
        }
    }

    private static class WidenLongTypeCache {
        static final Collection cache;

        private WidenLongTypeCache() {
        }

        static {
            Class[] types = new Class[]{class$java$lang$Byte == null ? (class$java$lang$Byte = Widening.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Short == null ? (class$java$lang$Short = Widening.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Integer == null ? (class$java$lang$Integer = Widening.class$("java.lang.Integer")) : class$java$lang$Integer};
            cache = Collections.unmodifiableCollection(new HashSet<Class>(Arrays.asList(types)));
        }
    }

    private static class WidenIntegerTypeCache {
        static final Collection cache;

        private WidenIntegerTypeCache() {
        }

        static {
            Class[] types = new Class[]{class$java$lang$Byte == null ? (class$java$lang$Byte = Widening.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Short == null ? (class$java$lang$Short = Widening.class$("java.lang.Short")) : class$java$lang$Short};
            cache = Collections.unmodifiableCollection(new HashSet<Class>(Arrays.asList(types)));
        }
    }

    private static class WidenShortTypeCache {
        static final Collection cache = Collections.singleton(class$java$lang$Byte == null ? (class$java$lang$Byte = Widening.class$("java.lang.Byte")) : class$java$lang$Byte);

        private WidenShortTypeCache() {
        }
    }
}

