/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class Utils {
    static final char OBJECT_SYMBOL = 'L';
    static final Map PRIMITIVE_FOR_TYPE_MAP;
    static final Map PRIMITIVE_CLASS_NAME_MAP;

    Utils() {
    }

    static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    static boolean isOrNull(Object o, Object o2) {
        return o == null || o2 == null;
    }

    static boolean isOrNull(Object o, Object o2, Object o3) {
        return o == null || o2 == null || o3 == null;
    }

    static boolean isContains(String source, char c) {
        return source != null && -1 < source.indexOf(c);
    }

    static boolean isInfiniteOrNaN(Float val) {
        return val.isInfinite() || val.isNaN();
    }

    static boolean isInfiniteOrNaN(Double val) {
        return val.isInfinite() || val.isNaN();
    }

    static String clazz(Object o) {
        return null == o ? String.valueOf(null) : o.getClass().toString();
    }

    static String clazz(String msg, Object o) {
        return msg + Utils.clazz(o);
    }

    static String log(String msg, Object o) {
        return msg + o;
    }

    static String log(String msg, int i) {
        return msg + i;
    }

    static String log(String msg, Object o, int i) {
        return msg + o + ", " + i;
    }

    static String log(String msg, Object o, Object o1) {
        return msg + o + ", " + o1;
    }

    static String log(String msg, Object o, Object o1, Object o2) {
        return msg + o + ", " + o1 + ", " + o2;
    }

    static String log(String msg, Object o, Object o1, Object o2, Object o3) {
        return msg + o + ", " + o1 + ", " + o2 + ", " + o3;
    }

    static String getShortClassName(Class clazz) {
        String s = clazz.getName();
        int off = s.lastIndexOf(46);
        int beginSize = -1 < off ? off + 1 : 0;
        return s.substring(beginSize, s.length());
    }

    static Class loadClass(String className, ClassLoader loader) {
        ClassLoader classLoader = loader;
        try {
            if (classLoader != null) {
                return Class.forName(className, true, loader);
            }
            return Class.forName(className);
        }
        catch (Exception e) {
            try {
                classLoader = Utils.getContextClassLoader();
                if (classLoader != null) {
                    return classLoader.loadClass(className);
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                classLoader = ClassLoader.getSystemClassLoader();
                return classLoader.loadClass(className);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    static Object toArray(Collection coll, Class type) {
        Object a = Array.newInstance(type, coll.size());
        if (type.isPrimitive()) {
            int i = 0;
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                Array.set(a, i++, iter.next());
            }
        } else {
            coll.toArray((Object[])a);
        }
        return a;
    }

    static {
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        m.put(Byte.TYPE.getName(), Byte.TYPE);
        m.put(Short.TYPE.getName(), Short.TYPE);
        m.put(Integer.TYPE.getName(), Integer.TYPE);
        m.put(Long.TYPE.getName(), Long.TYPE);
        m.put(Float.TYPE.getName(), Float.TYPE);
        m.put(Double.TYPE.getName(), Double.TYPE);
        m.put(Boolean.TYPE.getName(), Boolean.TYPE);
        m.put(Character.TYPE.getName(), Character.TYPE);
        m.put(Void.TYPE.getName(), Void.TYPE);
        PRIMITIVE_FOR_TYPE_MAP = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put(Byte.TYPE, "B");
        m.put(Short.TYPE, "S");
        m.put(Integer.TYPE, "I");
        m.put(Long.TYPE, "J");
        m.put(Float.TYPE, "F");
        m.put(Double.TYPE, "D");
        m.put(Boolean.TYPE, "Z");
        m.put(Character.TYPE, "C");
        m.put(Void.TYPE, "V");
        PRIMITIVE_CLASS_NAME_MAP = Collections.unmodifiableMap(m);
    }
}

