/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import shohaku.ogdl.Boxing;
import shohaku.ogdl.Utils;

class Progressions {
    private static final BigDecimal BIGDECIMAL_ZERO = new BigDecimal(BigInteger.ZERO, 0);

    Progressions() {
    }

    static int addDateTimeProgression(Collection coll, Date from, Date to, int field, int difference) {
        if (difference <= 0) {
            throw new IllegalArgumentException("difference <= 0");
        }
        if (from.compareTo(to) == 0) {
            return 0;
        }
        Calendar fc = Calendar.getInstance();
        Calendar tc = Calendar.getInstance();
        fc.setTimeInMillis(from.getTime());
        tc.setTimeInMillis(to.getTime());
        int add = 0;
        if (from.compareTo(to) < 0) {
            long maxTime = tc.getTimeInMillis();
            while (fc.getTimeInMillis() <= maxTime) {
                coll.add(fc.getTime());
                ++add;
                fc.add(field, difference);
            }
        } else {
            long minTime = tc.getTimeInMillis();
            while (fc.getTimeInMillis() >= minTime) {
                coll.add(fc.getTime());
                ++add;
                fc.add(field, -difference);
            }
        }
        return add;
    }

    static int addDateTimeInMillisProgression(Collection coll, Date from, Date to, int field, int difference) {
        if (difference <= 0) {
            throw new IllegalArgumentException("difference <= 0");
        }
        if (from.compareTo(to) == 0) {
            return 0;
        }
        Calendar fc = Calendar.getInstance();
        Calendar tc = Calendar.getInstance();
        fc.setTimeInMillis(from.getTime());
        tc.setTimeInMillis(to.getTime());
        int add = 0;
        if (from.compareTo(to) < 0) {
            long maxTime = tc.getTimeInMillis();
            while (fc.getTimeInMillis() <= maxTime) {
                coll.add(Boxing.box(fc.getTimeInMillis()));
                ++add;
                fc.add(field, difference);
            }
        } else {
            long minTime = tc.getTimeInMillis();
            while (fc.getTimeInMillis() >= minTime) {
                coll.add(Boxing.box(fc.getTimeInMillis()));
                ++add;
                fc.add(field, -difference);
            }
        }
        return add;
    }

    static int addArithmeticProgression(Collection coll, Character from, Character to, int difference) {
        if (difference <= 0) {
            throw new IllegalArgumentException("difference <= 0");
        }
        if (from.compareTo(to) == 0) {
            return 0;
        }
        int add = 0;
        if (from.compareTo(to) < 0) {
            char e = from.charValue();
            char maxValue = to.charValue();
            while (e <= maxValue) {
                coll.add(Boxing.box(e));
                ++add;
                e = (char)(e + difference);
            }
        } else {
            char e = from.charValue();
            char minValue = to.charValue();
            while (e >= minValue) {
                coll.add(Boxing.box(e));
                ++add;
                e = (char)(e - difference);
            }
        }
        return add;
    }

    static int addArithmeticProgression(Collection coll, Byte from, Byte to, byte difference) {
        if (difference <= 0) {
            throw new IllegalArgumentException("difference <= 0");
        }
        if (from.compareTo(to) == 0) {
            return 0;
        }
        int add = 0;
        if (from.compareTo(to) < 0) {
            byte e = from;
            byte maxValue = to;
            while (e <= maxValue) {
                coll.add(Boxing.box(e));
                ++add;
                e = (byte)(e + difference);
            }
        } else {
            byte e = from;
            byte minValue = to;
            while (e >= minValue) {
                coll.add(Boxing.box(e));
                ++add;
                e = (byte)(e - difference);
            }
        }
        return add;
    }

    static int addArithmeticProgression(Collection coll, Short from, Short to, short difference) {
        if (difference <= 0) {
            throw new IllegalArgumentException("difference <= 0");
        }
        if (from.compareTo(to) == 0) {
            return 0;
        }
        int add = 0;
        if (from.compareTo(to) < 0) {
            short e = from;
            short maxValue = to;
            while (e <= maxValue) {
                coll.add(Boxing.box(e));
                ++add;
                e = (short)(e + difference);
            }
        } else {
            short e = from;
            short minValue = to;
            while (e >= minValue) {
                coll.add(Boxing.box(e));
                ++add;
                e = (short)(e - difference);
            }
        }
        return add;
    }

    static int addArithmeticProgression(Collection coll, Integer from, Integer to, int difference) {
        if (difference <= 0) {
            throw new IllegalArgumentException("difference <= 0");
        }
        if (from.compareTo(to) == 0) {
            return 0;
        }
        int add = 0;
        if (from.compareTo(to) < 0) {
            int maxValue = to;
            for (int e = from.intValue(); e <= maxValue; e += difference) {
                coll.add(Boxing.box(e));
                ++add;
            }
        } else {
            int minValue = to;
            for (int e = from.intValue(); e >= minValue; e -= difference) {
                coll.add(Boxing.box(e));
                ++add;
            }
        }
        return add;
    }

    static int addArithmeticProgression(Collection coll, Long from, Long to, long difference) {
        if (difference <= 0L) {
            throw new IllegalArgumentException("difference <= 0");
        }
        if (from.compareTo(to) == 0) {
            return 0;
        }
        int add = 0;
        if (from.compareTo(to) < 0) {
            long maxValue = to;
            for (long e = from.longValue(); e <= maxValue; e += difference) {
                coll.add(Boxing.box(e));
                ++add;
            }
        } else {
            long minValue = to;
            for (long e = from.longValue(); e >= minValue; e -= difference) {
                coll.add(Boxing.box(e));
                ++add;
            }
        }
        return add;
    }

    static int addArithmeticProgression(Collection coll, Float from, Float to, int difference) {
        if (difference <= 0) {
            throw new IllegalArgumentException("difference <= 0");
        }
        if (Utils.isInfiniteOrNaN(from) || Utils.isInfiniteOrNaN(to)) {
            throw new IllegalArgumentException("Infinite or NaN");
        }
        if (from.compareTo(to) == 0) {
            return 0;
        }
        int add = 0;
        if (from.compareTo(to) < 0) {
            float maxValue = to.floatValue();
            for (float e = from.floatValue(); e <= maxValue; e += (float)difference) {
                coll.add(Boxing.box(e));
                ++add;
            }
        } else {
            float minValue = to.floatValue();
            for (float e = from.floatValue(); e >= minValue; e -= (float)difference) {
                coll.add(Boxing.box(e));
                ++add;
            }
        }
        return add;
    }

    static int addArithmeticProgression(Collection coll, Double from, Double to, long difference) {
        if (difference <= 0L) {
            throw new IllegalArgumentException("difference <= 0");
        }
        if (Utils.isInfiniteOrNaN(from) || Utils.isInfiniteOrNaN(to)) {
            throw new IllegalArgumentException("Infinite or NaN");
        }
        if (from.compareTo(to) == 0) {
            return 0;
        }
        int add = 0;
        if (from.compareTo(to) < 0) {
            double maxValue = to;
            for (double e = from.doubleValue(); e <= maxValue; e += (double)difference) {
                coll.add(Boxing.box(e));
                ++add;
            }
        } else {
            double minValue = to;
            for (double e = from.doubleValue(); e >= minValue; e -= (double)difference) {
                coll.add(Boxing.box(e));
                ++add;
            }
        }
        return add;
    }

    static int addArithmeticProgression(Collection coll, BigInteger from, BigInteger to, BigInteger difference) {
        if (difference.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException("difference <= 0");
        }
        if (from.compareTo(to) == 0) {
            return 0;
        }
        int add = 0;
        BigInteger e = from;
        if (from.compareTo(to) < 0) {
            while (0 > e.compareTo(to)) {
                coll.add(e);
                ++add;
                e = e.add(difference);
            }
        } else {
            while (0 < e.compareTo(to)) {
                coll.add(e);
                ++add;
                e = e.subtract(difference);
            }
        }
        return add;
    }

    static int addArithmeticProgression(Collection coll, BigDecimal from, BigDecimal to, BigInteger difference) {
        return Progressions.addArithmeticProgression(coll, from, to, new BigDecimal(difference));
    }

    static int addArithmeticProgression(Collection coll, BigDecimal from, BigDecimal to, BigDecimal difference) {
        if (difference.compareTo(BIGDECIMAL_ZERO) <= 0) {
            throw new IllegalArgumentException("difference <= 0");
        }
        if (from.compareTo(to) == 0) {
            return 0;
        }
        int add = 0;
        BigDecimal e = from;
        if (from.compareTo(to) < 0) {
            while (0 > e.compareTo(to)) {
                coll.add(e);
                ++add;
                e = e.add(difference);
            }
        } else {
            while (0 < e.compareTo(to)) {
                coll.add(e);
                ++add;
                e = e.subtract(difference);
            }
        }
        return add;
    }
}

