/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import shohaku.ogdl.Arithmetic;
import shohaku.ogdl.OgdlEvent;
import shohaku.ogdl.OgdlRuntime;
import shohaku.ogdl.OgdlSyntaxException;
import shohaku.ogdl.Utils;

class OgdlUnaryOperatorParser {
    OgdlUnaryOperatorParser() {
    }

    static Object evaluateBitwiseComplement(OgdlEvent ev) throws OgdlSyntaxException {
        ev.shift();
        Object o = OgdlRuntime.evaluate(ev);
        try {
            return Arithmetic.bitwiseNot(o);
        }
        catch (ArithmeticException e) {
            throw new OgdlSyntaxException(ev, Utils.log("arithmetic err. value=", o), e);
        }
    }

    static Object evaluateLogicalComplement(OgdlEvent ev) throws OgdlSyntaxException {
        ev.shift();
        Object o = OgdlRuntime.evaluate(ev);
        try {
            return Arithmetic.logicalNot(o);
        }
        catch (ArithmeticException e) {
            throw new OgdlSyntaxException(ev, Utils.log("arithmetic err. value=", o), e);
        }
    }

    static Object evaluateUnaryPlus(OgdlEvent ev) throws OgdlSyntaxException {
        ev.shift();
        Object o = OgdlRuntime.evaluate(ev);
        try {
            return Arithmetic.plus(o);
        }
        catch (ArithmeticException e) {
            throw new OgdlSyntaxException(ev, Utils.log("arithmetic err. value=", o), e);
        }
    }

    static Object evaluateUnaryMinus(OgdlEvent ev) throws OgdlSyntaxException {
        ev.shift();
        Object o = OgdlRuntime.evaluate(ev);
        try {
            return Arithmetic.minus(o);
        }
        catch (ArithmeticException e) {
            throw new OgdlSyntaxException(ev, Utils.log("arithmetic err. value=", o), e);
        }
    }
}

