/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import shohaku.ogdl.OgdlEvent;
import shohaku.ogdl.OgdlSyntaxException;
import shohaku.ogdl.Utils;

class OgdlSyntax {
    public static final int UPPER = 1;
    public static final int LOWER = 2;
    public static final int BINARY = 4;
    public static final int OCTAL = 8;
    public static final int DIGIT = 16;
    public static final int HEX = 32;
    public static final int SPACE = 64;
    public static final int PUNCT = 128;
    public static final int CNTRL = 256;
    public static final int BLANK = 512;
    public static final int PRINT = 1024;
    public static final int UNDER = 2048;
    public static final int ALPHA = 3;
    public static final int ALNUM = 19;
    public static final int GRAPH = 147;
    public static final int WORD = 2067;
    public static final int FLOAT = 4096;
    public static final int DOT = 8192;
    public static final int DOLLAR = 16384;
    public static final int COLON = 32768;
    public static final int MINUS = 65536;
    public static final int NUM_BEGIN = 131072;
    public static final int NUM_SUFFIX = 262144;
    public static final int MEMBER = 2067;
    public static final int MEMBER_BEGIN = 2051;
    public static final int CLAZZ = 26643;
    public static final int NUMBER = 69692;
    public static final int FUNC = 34835;
    public static final int OPERATOR = 130;
    public static final int DIFFERENCE = 71743;
    private static final int[] CHAR_CLAZZ = new int[255];

    OgdlSyntax() {
    }

    public static long getClazz(int ch) {
        return OgdlSyntax.isAscii(ch) ? (long)CHAR_CLAZZ[ch] : 0L;
    }

    public static boolean isClazz(int ch, int clazz) {
        return (OgdlSyntax.getClazz(ch) & (long)clazz) != 0L;
    }

    public static boolean isAscii(int ch) {
        return (ch & 0xFFFFFF80) == 0;
    }

    public static boolean isAlpha(int ch) {
        return OgdlSyntax.isClazz(ch, 3);
    }

    public static boolean isBinaryDigit(int ch) {
        return OgdlSyntax.isClazz(ch, 4);
    }

    public static boolean isOctDigit(int ch) {
        return OgdlSyntax.isClazz(ch, 8);
    }

    public static boolean isDigit(int ch) {
        return OgdlSyntax.isClazz(ch, 16);
    }

    public static boolean isHexDigit(int ch) {
        return OgdlSyntax.isClazz(ch, 32);
    }

    public static boolean isAlnum(int ch) {
        return OgdlSyntax.isClazz(ch, 19);
    }

    public static boolean isGraph(int ch) {
        return OgdlSyntax.isClazz(ch, 147);
    }

    public static boolean isPrint(int ch) {
        return OgdlSyntax.isClazz(ch, 1024);
    }

    public static boolean isPunct(int ch) {
        return OgdlSyntax.isClazz(ch, 128);
    }

    public static boolean isSpace(int ch) {
        return OgdlSyntax.isClazz(ch, 64);
    }

    public static boolean isCntrl(int ch) {
        return OgdlSyntax.isClazz(ch, 256);
    }

    public static boolean isLower(int ch) {
        return OgdlSyntax.isClazz(ch, 2);
    }

    public static boolean isUpper(int ch) {
        return OgdlSyntax.isClazz(ch, 1);
    }

    public static boolean isWord(int ch) {
        return OgdlSyntax.isClazz(ch, 2067);
    }

    public static int toLower(int ch) {
        return OgdlSyntax.isUpper(ch) ? ch + 32 : ch;
    }

    public static int toUpper(int ch) {
        return OgdlSyntax.isLower(ch) ? ch - 32 : ch;
    }

    public static boolean isBeginNumber(int ch) {
        return OgdlSyntax.isClazz(ch, 131072);
    }

    static int skip(OgdlEvent ev, int clazz) {
        int ch;
        int i;
        for (i = ev.offset(); i < ev.len && OgdlSyntax.isClazz(ch = ev.charAtIndex(i), clazz); ++i) {
        }
        return i;
    }

    static int skipSpace(OgdlEvent ev) {
        String cs = ev.ptn;
        int len = ev.len;
        int i = ev.offset();
        while (i < len) {
            if (OgdlSyntax.isNotation(cs, i = OgdlSyntax.skipSp(cs, i))) {
                i = OgdlSyntax.skipEncloseString(ev, cs, i);
                continue;
            }
            if (!OgdlSyntax.isEncloseNotation(cs, i)) break;
            ++i;
            i = OgdlSyntax.skipEncloseString(ev, cs, i);
        }
        return i;
    }

    private static int skipEncloseString(OgdlEvent ev, CharSequence cs, int index) {
        int off = index;
        OgdlSyntax.validIndexForThrow(ev, off);
        int close = OgdlSyntax.getEncloseCloseChar(cs, off);
        OgdlSyntax.validIndexForThrow(ev, ++off);
        int len = cs.length();
        while (off < len) {
            if (-1 == (off = OgdlSyntax.indexOf(cs, off, close))) {
                throw new OgdlSyntaxException(ev, Utils.log("not find close char. close=", close));
            }
            if (!OgdlSyntax.isCharAt(cs, off + 1, close)) break;
            ++off;
            ++off;
        }
        return ++off;
    }

    static int skipExtendNameClass(OgdlEvent ev) {
        int i = OgdlSyntax.skip(ev, 26643);
        return OgdlSyntax.skip(ev.ptn, "[]", i);
    }

    static int skipMemberName(OgdlEvent ev) {
        return OgdlSyntax.skip(ev, 2067);
    }

    static int skipOperator(OgdlEvent ev) {
        int i = OgdlSyntax.skip(ev, 130);
        if (ev.len > i && OgdlSyntax.isSpace(ev.ptn, i)) {
            return i;
        }
        return ev.offset();
    }

    static int skipFunctionName(OgdlEvent ev) {
        return OgdlSyntax.skip(ev, 34835);
    }

    static int skipNumberString(OgdlEvent ev) {
        int i = OgdlSyntax.skip(ev, 69692);
        if (ev.len > i && OgdlSyntax.isNumberSuffix(ev, i)) {
            ++i;
        }
        return i;
    }

    static String cutDifferenceString(OgdlEvent ev) {
        return ev.cutGroupStringForShift(71743);
    }

    static String cutEncloseString(OgdlEvent ev) {
        int off;
        ev.validIndexForThrow();
        int close = OgdlSyntax.getEncloseCloseChar(ev);
        ev.shift();
        ev.validIndexForThrow();
        StringBuffer buff = new StringBuffer(ev.cut(ev.len));
        int delete = 0;
        for (off = 0; off < buff.length(); ++off) {
            if (-1 == (off = OgdlSyntax.indexOf(buff, off, close))) {
                throw new OgdlSyntaxException(ev, Utils.log("not find close char. close=", close));
            }
            if (!OgdlSyntax.isCharAt(buff, off + 1, close)) break;
            ++delete;
            buff.deleteCharAt(off);
        }
        String value = buff.substring(0, off);
        ev.shift(++off + delete);
        return value;
    }

    static String cutExtendClassName(OgdlEvent ev) {
        int endIndex = OgdlSyntax.skipExtendNameClass(ev);
        return ev.cutForShift(endIndex);
    }

    static String cutMemberName(OgdlEvent ev) {
        int endIndex = OgdlSyntax.skipMemberName(ev);
        return ev.cutForShift(endIndex);
    }

    static String cutFunctionName(OgdlEvent ev) {
        int endIndex = OgdlSyntax.skipFunctionName(ev);
        return ev.cutForShift(endIndex);
    }

    static String cutNumberString(OgdlEvent ev) {
        int endIndex = OgdlSyntax.skipNumberString(ev);
        return ev.cutForShift(endIndex);
    }

    static boolean isArraylength(Class clazz, String memberName) {
        return clazz.isArray() && "length".equals(memberName);
    }

    static boolean isEncloseOpenChar(OgdlEvent ev) {
        return OgdlSyntax.isEncloseOpenChar(ev.ptn, ev.offset());
    }

    static boolean isBeginMember(OgdlEvent ev) {
        int ch = ev.charAt();
        return OgdlSyntax.isClazz(ch, 2051);
    }

    static int getEncloseCloseChar(OgdlEvent ev) {
        return OgdlSyntax.getEncloseCloseChar(ev.ptn, ev.offset());
    }

    private static boolean isSpace(CharSequence cs, int index) {
        return OgdlSyntax.isClazz(cs.charAt(index), 64);
    }

    private static boolean isNotation(CharSequence cs, int i) {
        return OgdlSyntax.isIndex(cs, i) && '#' == cs.charAt(i);
    }

    private static boolean isEncloseNotation(CharSequence cs, int i) {
        return OgdlSyntax.isIndex(cs, i + 1) && 'N' == cs.charAt(i) && OgdlSyntax.isEncloseOpenChar(cs, i + 1);
    }

    private static int skipSp(CharSequence cs, int fromIndex) {
        int i;
        int length = cs.length();
        for (i = fromIndex; i < length && OgdlSyntax.isSpace(cs, i); ++i) {
        }
        return i;
    }

    private static boolean isNumberSuffix(OgdlEvent ev, int index) {
        int ch = ev.charAtIndex(index);
        return OgdlSyntax.isClazz(ch, 262144);
    }

    private static boolean isEncloseOpenChar(CharSequence cs, int index) {
        char ch = cs.charAt(index);
        switch (ch) {
            case '!': 
            case '\"': 
            case '%': 
            case '\'': 
            case '(': 
            case '/': 
            case '<': 
            case '?': 
            case '@': 
            case '[': 
            case '`': 
            case '{': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    private static int getEncloseCloseChar(CharSequence cs, int index) {
        char ch = cs.charAt(index);
        switch (ch) {
            case '(': {
                return 41;
            }
            case '<': {
                return 62;
            }
            case '[': {
                return 93;
            }
            case '{': {
                return 125;
            }
        }
        return ch;
    }

    private static boolean isIndex(CharSequence cs, int index) {
        return index < cs.length();
    }

    private static boolean isCharAt(CharSequence cs, int index, int c) {
        return index < cs.length() && cs.charAt(index) == c;
    }

    private static int skip(String s, String chars, int fromIndex) {
        int i;
        int charslen = chars.length();
        for (i = fromIndex; i < s.length() && s.startsWith(chars, i); i += charslen) {
        }
        return i;
    }

    private static int indexOf(CharSequence cs, int fromIndex, int searchChar) {
        for (int i = fromIndex; i < cs.length(); ++i) {
            if (cs.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    private static void validIndexForThrow(OgdlEvent ev, int index) {
        if (!ev.hasIndex(index)) {
            throw new OgdlSyntaxException(ev, Utils.log("index err. index=", index));
        }
    }

    static {
        OgdlSyntax.CHAR_CLAZZ[0] = 256;
        OgdlSyntax.CHAR_CLAZZ[1] = 256;
        OgdlSyntax.CHAR_CLAZZ[2] = 256;
        OgdlSyntax.CHAR_CLAZZ[3] = 256;
        OgdlSyntax.CHAR_CLAZZ[4] = 256;
        OgdlSyntax.CHAR_CLAZZ[5] = 256;
        OgdlSyntax.CHAR_CLAZZ[6] = 256;
        OgdlSyntax.CHAR_CLAZZ[7] = 256;
        OgdlSyntax.CHAR_CLAZZ[8] = 256;
        OgdlSyntax.CHAR_CLAZZ[9] = 832;
        OgdlSyntax.CHAR_CLAZZ[10] = 320;
        OgdlSyntax.CHAR_CLAZZ[11] = 320;
        OgdlSyntax.CHAR_CLAZZ[12] = 320;
        OgdlSyntax.CHAR_CLAZZ[13] = 320;
        OgdlSyntax.CHAR_CLAZZ[14] = 256;
        OgdlSyntax.CHAR_CLAZZ[15] = 256;
        OgdlSyntax.CHAR_CLAZZ[16] = 256;
        OgdlSyntax.CHAR_CLAZZ[17] = 256;
        OgdlSyntax.CHAR_CLAZZ[18] = 256;
        OgdlSyntax.CHAR_CLAZZ[19] = 256;
        OgdlSyntax.CHAR_CLAZZ[20] = 256;
        OgdlSyntax.CHAR_CLAZZ[21] = 256;
        OgdlSyntax.CHAR_CLAZZ[22] = 256;
        OgdlSyntax.CHAR_CLAZZ[23] = 256;
        OgdlSyntax.CHAR_CLAZZ[24] = 256;
        OgdlSyntax.CHAR_CLAZZ[25] = 256;
        OgdlSyntax.CHAR_CLAZZ[26] = 256;
        OgdlSyntax.CHAR_CLAZZ[27] = 256;
        OgdlSyntax.CHAR_CLAZZ[28] = 256;
        OgdlSyntax.CHAR_CLAZZ[29] = 256;
        OgdlSyntax.CHAR_CLAZZ[30] = 256;
        OgdlSyntax.CHAR_CLAZZ[31] = 256;
        OgdlSyntax.CHAR_CLAZZ[32] = 1600;
        OgdlSyntax.CHAR_CLAZZ[33] = 1152;
        OgdlSyntax.CHAR_CLAZZ[34] = 1152;
        OgdlSyntax.CHAR_CLAZZ[35] = 1152;
        OgdlSyntax.CHAR_CLAZZ[36] = 17536;
        OgdlSyntax.CHAR_CLAZZ[37] = 1152;
        OgdlSyntax.CHAR_CLAZZ[38] = 1152;
        OgdlSyntax.CHAR_CLAZZ[39] = 1152;
        OgdlSyntax.CHAR_CLAZZ[40] = 1152;
        OgdlSyntax.CHAR_CLAZZ[41] = 1152;
        OgdlSyntax.CHAR_CLAZZ[42] = 1152;
        OgdlSyntax.CHAR_CLAZZ[43] = 5248;
        OgdlSyntax.CHAR_CLAZZ[44] = 1152;
        OgdlSyntax.CHAR_CLAZZ[45] = 70784;
        OgdlSyntax.CHAR_CLAZZ[46] = 13440;
        OgdlSyntax.CHAR_CLAZZ[47] = 1152;
        OgdlSyntax.CHAR_CLAZZ[48] = 136252;
        OgdlSyntax.CHAR_CLAZZ[49] = 136252;
        OgdlSyntax.CHAR_CLAZZ[50] = 136248;
        OgdlSyntax.CHAR_CLAZZ[51] = 136248;
        OgdlSyntax.CHAR_CLAZZ[52] = 136248;
        OgdlSyntax.CHAR_CLAZZ[53] = 136248;
        OgdlSyntax.CHAR_CLAZZ[54] = 136248;
        OgdlSyntax.CHAR_CLAZZ[55] = 136248;
        OgdlSyntax.CHAR_CLAZZ[56] = 136240;
        OgdlSyntax.CHAR_CLAZZ[57] = 136240;
        OgdlSyntax.CHAR_CLAZZ[58] = 33920;
        OgdlSyntax.CHAR_CLAZZ[59] = 1152;
        OgdlSyntax.CHAR_CLAZZ[60] = 1152;
        OgdlSyntax.CHAR_CLAZZ[61] = 1152;
        OgdlSyntax.CHAR_CLAZZ[62] = 1152;
        OgdlSyntax.CHAR_CLAZZ[63] = 1152;
        OgdlSyntax.CHAR_CLAZZ[64] = 1152;
        OgdlSyntax.CHAR_CLAZZ[65] = 1057;
        OgdlSyntax.CHAR_CLAZZ[66] = 1061;
        OgdlSyntax.CHAR_CLAZZ[67] = 1057;
        OgdlSyntax.CHAR_CLAZZ[68] = 263201;
        OgdlSyntax.CHAR_CLAZZ[69] = 5153;
        OgdlSyntax.CHAR_CLAZZ[70] = 263201;
        OgdlSyntax.CHAR_CLAZZ[71] = 263169;
        OgdlSyntax.CHAR_CLAZZ[72] = 263169;
        OgdlSyntax.CHAR_CLAZZ[73] = 398337;
        OgdlSyntax.CHAR_CLAZZ[74] = 1025;
        OgdlSyntax.CHAR_CLAZZ[75] = 1025;
        OgdlSyntax.CHAR_CLAZZ[76] = 263169;
        OgdlSyntax.CHAR_CLAZZ[77] = 1025;
        OgdlSyntax.CHAR_CLAZZ[78] = 136193;
        OgdlSyntax.CHAR_CLAZZ[79] = 1025;
        OgdlSyntax.CHAR_CLAZZ[80] = 1025;
        OgdlSyntax.CHAR_CLAZZ[81] = 1025;
        OgdlSyntax.CHAR_CLAZZ[82] = 1025;
        OgdlSyntax.CHAR_CLAZZ[83] = 263169;
        OgdlSyntax.CHAR_CLAZZ[84] = 1025;
        OgdlSyntax.CHAR_CLAZZ[85] = 263169;
        OgdlSyntax.CHAR_CLAZZ[86] = 1025;
        OgdlSyntax.CHAR_CLAZZ[87] = 1025;
        OgdlSyntax.CHAR_CLAZZ[88] = 1057;
        OgdlSyntax.CHAR_CLAZZ[89] = 1025;
        OgdlSyntax.CHAR_CLAZZ[90] = 1025;
        OgdlSyntax.CHAR_CLAZZ[91] = 1152;
        OgdlSyntax.CHAR_CLAZZ[92] = 1152;
        OgdlSyntax.CHAR_CLAZZ[93] = 1152;
        OgdlSyntax.CHAR_CLAZZ[94] = 1152;
        OgdlSyntax.CHAR_CLAZZ[95] = 3200;
        OgdlSyntax.CHAR_CLAZZ[96] = 1152;
        OgdlSyntax.CHAR_CLAZZ[97] = 5154;
        OgdlSyntax.CHAR_CLAZZ[98] = 1062;
        OgdlSyntax.CHAR_CLAZZ[99] = 1058;
        OgdlSyntax.CHAR_CLAZZ[100] = 263202;
        OgdlSyntax.CHAR_CLAZZ[101] = 5154;
        OgdlSyntax.CHAR_CLAZZ[102] = 267298;
        OgdlSyntax.CHAR_CLAZZ[103] = 263170;
        OgdlSyntax.CHAR_CLAZZ[104] = 263170;
        OgdlSyntax.CHAR_CLAZZ[105] = 267266;
        OgdlSyntax.CHAR_CLAZZ[106] = 1026;
        OgdlSyntax.CHAR_CLAZZ[107] = 1026;
        OgdlSyntax.CHAR_CLAZZ[108] = 263170;
        OgdlSyntax.CHAR_CLAZZ[109] = 1026;
        OgdlSyntax.CHAR_CLAZZ[110] = 5122;
        OgdlSyntax.CHAR_CLAZZ[111] = 1026;
        OgdlSyntax.CHAR_CLAZZ[112] = 1026;
        OgdlSyntax.CHAR_CLAZZ[113] = 1026;
        OgdlSyntax.CHAR_CLAZZ[114] = 1026;
        OgdlSyntax.CHAR_CLAZZ[115] = 263170;
        OgdlSyntax.CHAR_CLAZZ[116] = 5122;
        OgdlSyntax.CHAR_CLAZZ[117] = 263170;
        OgdlSyntax.CHAR_CLAZZ[118] = 1026;
        OgdlSyntax.CHAR_CLAZZ[119] = 1026;
        OgdlSyntax.CHAR_CLAZZ[120] = 1058;
        OgdlSyntax.CHAR_CLAZZ[121] = 5122;
        OgdlSyntax.CHAR_CLAZZ[122] = 1026;
        OgdlSyntax.CHAR_CLAZZ[123] = 1152;
        OgdlSyntax.CHAR_CLAZZ[124] = 1152;
        OgdlSyntax.CHAR_CLAZZ[125] = 1152;
        OgdlSyntax.CHAR_CLAZZ[126] = 1152;
        OgdlSyntax.CHAR_CLAZZ[127] = 256;
    }
}

