/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import shohaku.ogdl.OgdlEvent;
import shohaku.ogdl.OgdlSyntax;
import shohaku.ogdl.OgdlSyntaxException;
import shohaku.ogdl.Utils;
import shohaku.ogdl.ValueOf;

class OgdlPrimitiveParser {
    OgdlPrimitiveParser() {
    }

    static String evaluateString(OgdlEvent ev) {
        if (OgdlSyntax.isEncloseOpenChar(ev)) {
            return OgdlSyntax.cutEncloseString(ev);
        }
        throw new OgdlSyntaxException(ev, "is not enclose literal.");
    }

    static Character evaluateCharacter(OgdlEvent ev) {
        if (OgdlSyntax.isEncloseOpenChar(ev)) {
            String src = OgdlSyntax.cutEncloseString(ev);
            try {
                return ValueOf.decodeCharacter(src);
            }
            catch (IllegalArgumentException e) {
                throw new OgdlSyntaxException(ev, Utils.log("character format err. char=", src), e);
            }
        }
        throw new OgdlSyntaxException(ev, "is not enclose literal.");
    }

    static Object evaluateReference(OgdlEvent ev) {
        if (OgdlSyntax.isEncloseOpenChar(ev)) {
            String src = OgdlSyntax.cutEncloseString(ev);
            return ev.context.getAttribute(src);
        }
        String s = OgdlSyntax.cutMemberName(ev);
        return ev.context.getAttribute(s);
    }

    static Object evaluateDateTime(OgdlEvent ev) throws OgdlSyntaxException {
        if (OgdlSyntax.isEncloseOpenChar(ev)) {
            String src = OgdlSyntax.cutEncloseString(ev);
            try {
                return ValueOf.decodeDateTime(src);
            }
            catch (IllegalArgumentException e) {
                throw new OgdlSyntaxException(ev, Utils.log("date time format err. format=", src), e);
            }
        }
        throw new OgdlSyntaxException(ev, "is not enclose literal.");
    }

    static Pattern evaluateRegexPattern(OgdlEvent ev) throws OgdlSyntaxException {
        if (OgdlSyntax.isEncloseOpenChar(ev)) {
            String src = OgdlSyntax.cutEncloseString(ev);
            try {
                return Pattern.compile(src);
            }
            catch (PatternSyntaxException e) {
                throw new OgdlSyntaxException(ev, Utils.log("regex pattern err. pattern=", src), e);
            }
        }
        throw new OgdlSyntaxException(ev, "is not enclose literal.");
    }

    static Number evaluateNumber(OgdlEvent ev) {
        return OgdlPrimitiveParser.decodeNumber(ev, OgdlSyntax.cutNumberString(ev));
    }

    static Integer evaluateInteger(OgdlEvent ev) throws OgdlSyntaxException {
        return ValueOf.decodeInteger(OgdlSyntax.cutNumberString(ev));
    }

    static Class evaluateClassByExtendName(OgdlEvent ev) {
        return OgdlPrimitiveParser.loadClassByExtendClassName(ev, OgdlSyntax.cutExtendClassName(ev));
    }

    private static Number decodeNumber(OgdlEvent ev, String s) throws OgdlSyntaxException {
        try {
            return ValueOf.decodeNumber(s);
        }
        catch (NumberFormatException e) {
            throw new OgdlSyntaxException(ev, Utils.log("value is not Number format. format=", s), e);
        }
    }

    private static Class loadClassByExtendClassName(OgdlEvent ev, String extendClassName) {
        int off;
        StringBuffer symbol = new StringBuffer();
        for (off = extendClassName.length(); off >= 2 && extendClassName.charAt(off - 1) == ']' && extendClassName.charAt(off - 2) == '['; off -= 2) {
            symbol.append('[');
        }
        boolean isArray = symbol.length() > 0;
        String rootName = isArray ? extendClassName.substring(0, off) : extendClassName;
        Class clazz = OgdlPrimitiveParser.findClass(rootName, ev);
        if (isArray) {
            StringBuffer className = new StringBuffer();
            if (clazz != null) {
                String primitiveName = (String)Utils.PRIMITIVE_CLASS_NAME_MAP.get(clazz);
                if (primitiveName == null) {
                    className.append(symbol).append('L').append(clazz.getName()).append(';');
                } else {
                    className.append(symbol).append(primitiveName);
                }
            } else {
                className.append(symbol).append('L').append(rootName).append(';');
            }
            Class loadClass = Utils.loadClass(className.toString(), ev.loader);
            if (loadClass != null) {
                return loadClass;
            }
        } else {
            if (clazz != null) {
                return clazz;
            }
            Class loadClass = Utils.loadClass(rootName, ev.loader);
            if (loadClass != null) {
                return loadClass;
            }
        }
        throw new OgdlSyntaxException(ev, Utils.log("not find class. class=", extendClassName));
    }

    private static Class findClass(String className, OgdlEvent ev) {
        Class<?> clazz = (Class<?>)Utils.PRIMITIVE_FOR_TYPE_MAP.get(className);
        if (clazz == null && !Utils.isContains(className, '.')) {
            try {
                clazz = Class.forName("java.lang." + className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            clazz = ev.context.forImport(className);
        }
        return clazz;
    }
}

