/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import shohaku.ogdl.OgdlCollectionParser;
import shohaku.ogdl.OgdlEvent;
import shohaku.ogdl.OgdlFunctionParser;
import shohaku.ogdl.OgdlIntrospectParser;
import shohaku.ogdl.OgdlOperatorParser;
import shohaku.ogdl.OgdlPrimitiveParser;
import shohaku.ogdl.OgdlSyntax;
import shohaku.ogdl.OgdlSyntaxException;
import shohaku.ogdl.OgdlUnaryOperatorParser;

class OgdlParser {
    OgdlParser() {
    }

    static Object evaluateExpression(OgdlEvent ev) {
        int open = ev.charAt();
        switch (open) {
            case 33: {
                return OgdlUnaryOperatorParser.evaluateLogicalComplement(ev);
            }
            case 37: {
                return OgdlPrimitiveParser.evaluateRegexPattern(ev);
            }
            case 39: {
                return OgdlPrimitiveParser.evaluateString(ev);
            }
            case 40: {
                return OgdlOperatorParser.evaluateOperator(ev);
            }
            case 43: {
                return OgdlUnaryOperatorParser.evaluateUnaryPlus(ev);
            }
            case 45: {
                if (ev.hasNext() && OgdlSyntax.isBeginNumber(ev.charAt(1))) {
                    return OgdlPrimitiveParser.evaluateNumber(ev);
                }
                return OgdlUnaryOperatorParser.evaluateUnaryMinus(ev);
            }
            case 47: {
                return OgdlPrimitiveParser.evaluateDateTime(ev);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return OgdlPrimitiveParser.evaluateNumber(ev);
            }
            case 60: {
                return OgdlCollectionParser.evaluateDefaultSet(ev);
            }
            case 64: {
                if (OgdlParser.isLiteral(ev, "@@")) {
                    return OgdlPrimitiveParser.evaluateClassByExtendName(ev);
                }
                ev.shift();
                return OgdlPrimitiveParser.evaluateReference(ev);
            }
            case 68: {
                ev.shift();
                return OgdlPrimitiveParser.evaluateDateTime(ev);
            }
            case 70: {
                ev.shift();
                return OgdlOperatorParser.evaluateOperator(ev);
            }
            case 73: {
                return OgdlPrimitiveParser.evaluateNumber(ev);
            }
            case 78: {
                return OgdlPrimitiveParser.evaluateNumber(ev);
            }
            case 82: {
                ev.shift();
                return OgdlPrimitiveParser.evaluateRegexPattern(ev);
            }
            case 83: {
                ev.shift();
                return OgdlPrimitiveParser.evaluateString(ev);
            }
            case 85: {
                ev.shift();
                return OgdlPrimitiveParser.evaluateCharacter(ev);
            }
            case 91: {
                return OgdlCollectionParser.evaluateDefaultList(ev);
            }
            case 96: {
                return OgdlPrimitiveParser.evaluateCharacter(ev);
            }
            case 97: {
                if (!OgdlParser.isPrefixName(ev, "array:")) break;
                return OgdlCollectionParser.evaluateArray(ev);
            }
            case 99: {
                if (OgdlParser.isPrefixName(ev, "class:")) {
                    return OgdlPrimitiveParser.evaluateClassByExtendName(ev);
                }
                if (OgdlParser.isPrefixName(ev, "coll:")) {
                    return OgdlCollectionParser.evaluateCollection(ev);
                }
                if (!OgdlParser.isPrefixName(ev, "cons:")) break;
                return OgdlIntrospectParser.evaluateConstructor(ev);
            }
            case 102: {
                if (OgdlParser.isLiteral(ev, "false")) {
                    return Boolean.FALSE;
                }
                if (OgdlParser.isPrefixName(ev, "field:")) {
                    return OgdlIntrospectParser.evaluateField(ev);
                }
                if (!OgdlParser.isPrefixName(ev, "f:")) break;
                return OgdlFunctionParser.evaluateFunction(ev);
            }
            case 108: {
                if (!OgdlParser.isPrefixName(ev, "list:")) break;
                return OgdlCollectionParser.evaluateList(ev);
            }
            case 109: {
                if (OgdlParser.isPrefixName(ev, "map:")) {
                    return OgdlCollectionParser.evaluateMap(ev);
                }
                if (!OgdlParser.isPrefixName(ev, "method:")) break;
                return OgdlIntrospectParser.evaluateMethod(ev);
            }
            case 110: {
                if (OgdlParser.isLiteral(ev, "null")) {
                    return null;
                }
                if (!OgdlParser.isPrefixName(ev, "new:")) break;
                return OgdlIntrospectParser.evaluateNewInstance(ev);
            }
            case 114: {
                if (!OgdlParser.isPrefixName(ev, "ref:")) break;
                return OgdlPrimitiveParser.evaluateReference(ev);
            }
            case 115: {
                if (OgdlParser.isPrefixName(ev, "set:")) {
                    return OgdlCollectionParser.evaluateSet(ev);
                }
                if (OgdlParser.isPrefixName(ev, "sortedSet:")) {
                    return OgdlCollectionParser.evaluateSortedSet(ev);
                }
                if (!OgdlParser.isPrefixName(ev, "sortedMap:")) break;
                return OgdlCollectionParser.evaluateSortedMap(ev);
            }
            case 116: {
                if (!OgdlParser.isLiteral(ev, "true")) break;
                return Boolean.TRUE;
            }
            case 123: {
                return OgdlCollectionParser.evaluateDefaultMap(ev);
            }
            case 126: {
                return OgdlUnaryOperatorParser.evaluateBitwiseComplement(ev);
            }
        }
        throw new OgdlSyntaxException(ev, "not found expression.");
    }

    static Collection evaluateEncloseCollection(OgdlEvent ev) {
        return OgdlCollectionParser.evaluateEncloseCollection(ev);
    }

    static Collection evaluateCloseCollection(OgdlEvent ev) {
        return OgdlCollectionParser.evaluateCloseCollection(ev);
    }

    static Map evaluateEncloseMap(OgdlEvent ev) {
        return OgdlCollectionParser.evaluateEncloseMap(ev);
    }

    static Map evaluateCloseMap(OgdlEvent ev) {
        return OgdlCollectionParser.evaluateCloseMap(ev);
    }

    static List evaluateEncloseProgressionList(OgdlEvent ev) {
        return (List)OgdlCollectionParser.evaluateEncloseProgressionCollection(ev);
    }

    static List evaluateCloseProgressionList(OgdlEvent ev) {
        return (List)OgdlCollectionParser.evaluateCloseProgressionCollection(ev);
    }

    static Object evaluatePostfixExpression(OgdlEvent ev, Object returnValue) {
        int open = ev.charAt();
        switch (open) {
            case 35: 
            case 46: 
            case 91: {
                ev.target = returnValue;
                return OgdlIntrospectParser.evaluateObjectNavigate(ev);
            }
        }
        return returnValue;
    }

    private static boolean isLiteral(OgdlEvent ev, String literal) {
        if (ev.startsWith(literal)) {
            ev.shift(literal.length());
            return true;
        }
        return false;
    }

    private static boolean isPrefixName(OgdlEvent ev, String id) {
        if (ev.startsWith(id)) {
            ev.shift(id.length());
            ev.shiftSpace();
            if (!ev.hasNext()) {
                throw new OgdlSyntaxException(ev, "offset err.");
            }
            return true;
        }
        return false;
    }
}

