/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.util.LinkedList;
import java.util.List;
import shohaku.ogdl.Arithmetic;
import shohaku.ogdl.OgdlEvent;
import shohaku.ogdl.OgdlFunctionException;
import shohaku.ogdl.OgdlParser;
import shohaku.ogdl.OgdlRuntime;
import shohaku.ogdl.OgdlSyntax;
import shohaku.ogdl.OgdlSyntaxException;

class OgdlOperatorParser {
    OgdlOperatorParser() {
    }

    static Object evaluateOperator(OgdlEvent ev) {
        if (OgdlSyntax.isEncloseOpenChar(ev)) {
            return OgdlOperatorParser.evaluateEncloseOperator(ev);
        }
        throw new OgdlSyntaxException(ev, "is not enclose literal.");
    }

    private static Object evaluateEncloseOperator(OgdlEvent ev) {
        int size;
        int close = OgdlSyntax.getEncloseCloseChar(ev);
        int begin = ev.shift();
        int next = OgdlSyntax.skipOperator(ev);
        if (next == begin || next - begin > 4) {
            return OgdlOperatorParser.evaluateExpressionGroup(ev, close);
        }
        String name = ev.cut(next);
        int type = OgdlOperatorParser.asOperatorType(name, size = next - begin);
        if (-1 == type) {
            return OgdlOperatorParser.evaluateExpressionGroup(ev, close);
        }
        ev.setIndex(next);
        List args = OgdlOperatorParser.getArguments(ev, close);
        if (args.isEmpty()) {
            OgdlFunctionException fe = new OgdlFunctionException(ev, "empty arguments. ");
            throw fe.throwFor(ev, name, args);
        }
        try {
            return Arithmetic.evaluate(type, args);
        }
        catch (ArithmeticException e) {
            OgdlFunctionException fe = new OgdlFunctionException("arithmetic err.", e);
            throw fe.throwFor(ev, name, args);
        }
        catch (RuntimeException e) {
            OgdlFunctionException fe = new OgdlFunctionException("java runtime err.", e);
            throw fe.throwFor(ev, name, args);
        }
    }

    private static int asOperatorType(String name, int size) {
        int type = -1;
        block0 : switch (size) {
            case 1: {
                char c = name.charAt(0);
                switch (c) {
                    case '%': {
                        type = 4;
                        break block0;
                    }
                    case '&': {
                        type = 5;
                        break block0;
                    }
                    case '*': {
                        type = 2;
                        break block0;
                    }
                    case '+': {
                        type = 0;
                        break block0;
                    }
                    case '-': {
                        type = 1;
                        break block0;
                    }
                    case '/': {
                        type = 3;
                        break block0;
                    }
                    case '<': {
                        type = 34;
                        break block0;
                    }
                    case '>': {
                        type = 36;
                        break block0;
                    }
                    case '^': {
                        type = 6;
                        break block0;
                    }
                    case '|': {
                        type = 7;
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                if (name.equals("eq")) {
                    type = 32;
                    break;
                }
                if (name.equals("ne")) {
                    type = 33;
                    break;
                }
                if (name.equals("==")) {
                    type = 32;
                    break;
                }
                if (name.equals("!=")) {
                    type = 33;
                    break;
                }
                if (name.equals("lt")) {
                    type = 34;
                    break;
                }
                if (name.equals("gt")) {
                    type = 36;
                    break;
                }
                if (name.equals("le")) {
                    type = 35;
                    break;
                }
                if (name.equals("ge")) {
                    type = 37;
                    break;
                }
                if (name.equals("<=")) {
                    type = 35;
                    break;
                }
                if (name.equals(">=")) {
                    type = 37;
                    break;
                }
                if (name.equals("<<")) {
                    type = 16;
                    break;
                }
                if (name.equals(">>")) {
                    type = 17;
                    break;
                }
                if (name.equals("=>")) {
                    type = 50;
                    break;
                }
                if (name.equals("!>")) {
                    type = 51;
                    break;
                }
                if (name.equals("?>")) {
                    type = 48;
                    break;
                }
                if (!name.equals("+>")) break;
                type = 49;
                break;
            }
            case 3: {
                if (name.equals("mul")) {
                    type = 2;
                    break;
                }
                if (name.equals("add")) {
                    type = 0;
                    break;
                }
                if (name.equals("sub")) {
                    type = 1;
                    break;
                }
                if (name.equals("div")) {
                    type = 3;
                    break;
                }
                if (name.equals("mod")) {
                    type = 4;
                    break;
                }
                if (name.equals("xor")) {
                    type = 6;
                    break;
                }
                if (name.equals("bor")) {
                    type = 7;
                    break;
                }
                if (name.equals("shl")) {
                    type = 16;
                    break;
                }
                if (name.equals("shr")) {
                    type = 17;
                    break;
                }
                if (name.equals(">>>")) {
                    type = 18;
                    break;
                }
                if (name.equals("eqs")) {
                    type = 50;
                    break;
                }
                if (name.equals("nes")) {
                    type = 51;
                    break;
                }
                if (name.equals("iof")) {
                    type = 48;
                    break;
                }
                if (name.equals("sof")) {
                    type = 49;
                    break;
                }
                if (name.equals("===")) {
                    type = 52;
                    break;
                }
                if (name.equals("!==")) {
                    type = 53;
                    break;
                }
                if (name.equals("req")) {
                    type = 52;
                    break;
                }
                if (!name.equals("rne")) break;
                type = 53;
                break;
            }
            case 4: {
                if (name.equals("ushr")) {
                    type = 18;
                    break;
                }
                if (!name.equals("band")) break;
                type = 5;
            }
        }
        return type;
    }

    static Object evaluateExpressionGroup(OgdlEvent ev, int close) {
        Object output = null;
        if (ev.isNotCharAt(close)) {
            while (ev.hasNext()) {
                ev.shiftSpace();
                output = OgdlRuntime.evaluate(ev);
                ev.validIndexForThrow();
                ev.shiftSpace();
                if (ev.isCharAt(close)) break;
                if (ev.isNotSeparator()) {
                    throw new OgdlSyntaxException(ev, "is not separator.");
                }
                ev.shift();
            }
            ev.shiftSpace();
            if (ev.isNotCharAt(close)) {
                throw new OgdlSyntaxException(ev, "syntax err.");
            }
        }
        ev.shift();
        return output;
    }

    private static List getArguments(OgdlEvent ev, int close) {
        return (List)OgdlParser.evaluateCloseCollection(ev.get(0, close, new LinkedList()));
    }
}

