/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import shohaku.ogdl.BeanIntrospectHelper;
import shohaku.ogdl.Boxing;
import shohaku.ogdl.OgdlCollectionParser;
import shohaku.ogdl.OgdlEvent;
import shohaku.ogdl.OgdlParser;
import shohaku.ogdl.OgdlPrimitiveParser;
import shohaku.ogdl.OgdlRuntime;
import shohaku.ogdl.OgdlSyntax;
import shohaku.ogdl.OgdlSyntaxException;
import shohaku.ogdl.Utils;

class OgdlIntrospectParser {
    OgdlIntrospectParser() {
    }

    static Object evaluateObjectNavigate(OgdlEvent ev) {
        Object target = ev.target;
        try {
            Object o = target;
            block8: while (ev.hasNext(1)) {
                int open = ev.charAt();
                switch (open) {
                    case 91: {
                        Object key = OgdlIntrospectParser.readIndexingKeys(ev);
                        o = OgdlIntrospectParser.readIndexingValue(ev, key, o);
                        continue block8;
                    }
                    case 46: {
                        ev.shift();
                        String memberName = OgdlSyntax.cutMemberName(ev);
                        Class<?> clazz = o.getClass();
                        if (ev.isCharAt(40)) {
                            o = OgdlIntrospectParser.invokeMethod(ev, memberName, o, clazz);
                            continue block8;
                        }
                        if (ev.isCharAt(91)) {
                            o = OgdlIntrospectParser.readIndexPropertyOrFieldOrProperty(ev, memberName, o, clazz);
                            continue block8;
                        }
                        o = OgdlIntrospectParser.readFieldOrProperty(ev, memberName, o, clazz);
                        continue block8;
                    }
                    case 35: {
                        ev.shift();
                        String staticMemberName = OgdlSyntax.cutMemberName(ev);
                        if (ev.isCharAt(40)) {
                            o = OgdlIntrospectParser.invokeStaticMethod(ev, staticMemberName, o);
                            continue block8;
                        }
                        o = OgdlIntrospectParser.readStaticFieldValue(ev, staticMemberName, o);
                        continue block8;
                    }
                }
                return o;
            }
            return o;
        }
        catch (IndexOutOfBoundsException e) {
            throw new OgdlSyntaxException(ev, "syntax err.", e);
        }
        catch (NumberFormatException e) {
            throw new OgdlSyntaxException(ev, "syntax err.", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Object evaluateNewInstance(OgdlEvent ev) {
        Class clazz = OgdlPrimitiveParser.evaluateClassByExtendName(ev);
        Object obj = null;
        int offLiteral = ev.charAt();
        if (offLiteral == 35) {
            ev.shift();
            String memberName = OgdlSyntax.cutMemberName(ev);
            if (!ev.isCharAt(40)) throw new OgdlSyntaxException(ev, "syntax err.");
            Object[] args = OgdlIntrospectParser.evaluateEncloseArguments(ev.get(40, 41));
            try {
                obj = BeanIntrospectHelper.invokeMethod(clazz, null, memberName, args);
            }
            catch (OgdlSyntaxException e) {
                throw e.throwFor(ev);
            }
            int next_off = ev.shiftSpace();
            if (!ev.isCharAt(123, next_off)) return obj;
            ev.setIndex(next_off);
            OgdlIntrospectParser.writeInitProperties(ev.get(123, 125), obj);
            return obj;
        }
        if (offLiteral == 40) {
            Object[] args = OgdlIntrospectParser.evaluateEncloseArguments(ev.get(40, 41));
            try {
                obj = BeanIntrospectHelper.newInstance(clazz, args);
            }
            catch (OgdlSyntaxException e) {
                throw e.throwFor(ev);
            }
            int next_off = ev.shiftSpace();
            if (!ev.isCharAt(123, next_off)) return obj;
            ev.setIndex(next_off);
            OgdlIntrospectParser.writeInitProperties(ev.get(123, 125), obj);
            return obj;
        }
        if (offLiteral == 91) {
            Integer[] dimensions = OgdlIntrospectParser.evaluateDimensionArraySizes(ev);
            try {
                return Array.newInstance(clazz, Boxing.unbox(dimensions));
            }
            catch (IllegalArgumentException e) {
                throw new OgdlSyntaxException(ev, "arrays newInstance err.", e);
            }
            catch (NegativeArraySizeException e) {
                throw new OgdlSyntaxException(ev, "arrays newInstance err.", e);
            }
        }
        if (!clazz.isArray()) {
            throw new OgdlSyntaxException(ev, "no array type. " + clazz);
        }
        int next_off = ev.shiftSpace();
        if (!ev.isCharAt(123, next_off)) throw new OgdlSyntaxException(ev, "syntax err.");
        ev.setIndex(next_off);
        List list = (List)OgdlCollectionParser.evaluateEncloseProgressionCollection(ev.get(123, 125, new LinkedList()));
        try {
            return Utils.toArray(list, clazz.getComponentType());
        }
        catch (IllegalArgumentException e) {
            throw new OgdlSyntaxException(ev, "array item type mismatch.", e);
        }
    }

    static Object evaluateConstructor(OgdlEvent ev) {
        Class type = OgdlPrimitiveParser.evaluateClassByExtendName(ev);
        Class[] argsType = OgdlIntrospectParser.evaluateEncloseTypeArray(ev.get(40, 41));
        try {
            return BeanIntrospectHelper.getConstructor(type, argsType);
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }

    static Object evaluateMethod(OgdlEvent ev) {
        Class type = OgdlPrimitiveParser.evaluateClassByExtendName(ev);
        if (ev.isNotCharAt(35)) {
            throw new OgdlSyntaxException(ev, "method separator err. ");
        }
        ev.shift();
        String methodName = OgdlSyntax.cutMemberName(ev);
        Class[] argsType = OgdlIntrospectParser.evaluateEncloseTypeArray(ev.get(40, 41));
        try {
            return BeanIntrospectHelper.getMethod(type, methodName, argsType);
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }

    static Object evaluateField(OgdlEvent ev) {
        Class type = OgdlPrimitiveParser.evaluateClassByExtendName(ev);
        if (ev.isNotCharAt(35)) {
            throw new OgdlSyntaxException(ev, "field separator err. ");
        }
        ev.shift();
        String fieldName = OgdlSyntax.cutMemberName(ev);
        try {
            return BeanIntrospectHelper.getField(type, fieldName);
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }

    private static Class[] evaluateEncloseTypeArray(OgdlEvent ev) {
        if (ev.isNotOpen()) {
            throw new OgdlSyntaxException(ev, "syntax err.");
        }
        ev.shift();
        ev.shiftSpace();
        ArrayList<Class> list = new ArrayList<Class>();
        int close = ev.close;
        if (ev.isNotClose(close)) {
            while (ev.hasNext()) {
                list.add(OgdlPrimitiveParser.evaluateClassByExtendName(ev));
                ev.shiftSpace();
                if (ev.isClose(close)) break;
                if (ev.isNotSeparator()) {
                    throw new OgdlSyntaxException(ev, "is not comma.");
                }
                ev.shift();
                ev.shiftSpace();
            }
            ev.shiftSpace();
            if (ev.isNotClose(close)) {
                throw new OgdlSyntaxException(ev, "syntax err.");
            }
        }
        Class[] types = list.toArray(new Class[0]);
        ev.shift();
        return types;
    }

    private static Integer[] evaluateDimensionArraySizes(OgdlEvent ev) {
        LinkedList<Integer> output = new LinkedList<Integer>();
        while (ev.isCharAt(91)) {
            ev.shift();
            ev.shiftSpace();
            output.add(OgdlPrimitiveParser.evaluateInteger(ev));
            ev.validIndexForThrow();
            ev.shiftSpace();
            if (ev.isNotCharAt(93)) {
                throw new OgdlSyntaxException(ev, "syntax err.");
            }
            ev.shift();
        }
        return output.toArray(new Integer[output.size()]);
    }

    private static Object evaluateSkipSpace(OgdlEvent ev) {
        ev.shiftSpace();
        Object o = OgdlRuntime.evaluate(ev);
        ev.shiftSpace();
        return o;
    }

    private static Object readFieldOrProperty(OgdlEvent ev, String memberName, Object o, Class clazz) {
        try {
            PropertyDescriptor pd = BeanIntrospectHelper.getPropertyDescriptor(clazz, memberName);
            Object r = null;
            r = pd == null ? (OgdlSyntax.isArraylength(clazz, memberName) ? Boxing.box(Array.getLength(o)) : BeanIntrospectHelper.getFieldValue(clazz, o, memberName)) : BeanIntrospectHelper.getProperty(o, pd.getReadMethod());
            return r;
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }

    private static Object readStaticFieldValue(OgdlEvent ev, String memberName, Object o) {
        try {
            if (o instanceof Class) {
                return BeanIntrospectHelper.getFieldValue((Class)o, null, memberName);
            }
            throw new OgdlSyntaxException(ev, "is not Class class.");
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }

    private static Object readIndexedValue(OgdlEvent ev) {
        ev.shift();
        Object inx = OgdlIntrospectParser.evaluateSkipSpace(ev);
        if (ev.isNotCharAt(93)) {
            throw new OgdlSyntaxException(ev, "syntax err.");
        }
        if (!(inx instanceof Integer)) {
            throw new OgdlSyntaxException(ev, Utils.clazz("not indexing type. type=", inx));
        }
        ev.shift();
        return inx;
    }

    private static Object readIndexingKeys(OgdlEvent ev) {
        ev.shift();
        Object key = OgdlIntrospectParser.evaluateSkipSpace(ev);
        if (ev.isNotCharAt(93)) {
            throw new OgdlSyntaxException(ev, "syntax err.");
        }
        ev.shift();
        return key;
    }

    private static int toKeyAsIndex(OgdlEvent ev, Object key) {
        if (!(key instanceof Integer)) {
            throw new OgdlSyntaxException(ev, "syntax err.");
        }
        return (Integer)key;
    }

    private static Object readIndexingValue(OgdlEvent ev, Object key, Object o) {
        Object r = null;
        if (o instanceof Map) {
            r = ((Map)o).get(key);
        } else if (o instanceof List) {
            int index = OgdlIntrospectParser.toKeyAsIndex(ev, key);
            r = ((List)o).get(index);
        } else if (o.getClass().isArray()) {
            int index = OgdlIntrospectParser.toKeyAsIndex(ev, key);
            r = Array.get(o, index);
        } else if (o instanceof CharSequence) {
            int index = OgdlIntrospectParser.toKeyAsIndex(ev, key);
            r = Boxing.box(((CharSequence)o).charAt(index));
        } else {
            throw new OgdlSyntaxException(ev, Utils.clazz("not indexing type. type=", o));
        }
        return r;
    }

    private static Object readIndexPropertyOrFieldOrProperty(OgdlEvent ev, String memberName, Object o, Class clazz) {
        try {
            IndexedPropertyDescriptor ipd = BeanIntrospectHelper.getIndexedPropertyDescriptor(clazz, memberName);
            Object r = null;
            if (ipd != null) {
                Object inx = OgdlIntrospectParser.readIndexedValue(ev);
                r = BeanIntrospectHelper.getIndexedProperty(o, ipd.getIndexedReadMethod(), (Integer)inx);
            } else {
                r = OgdlIntrospectParser.readFieldOrProperty(ev, memberName, o, clazz);
            }
            return r;
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }

    private static Object invokeMethod(OgdlEvent ev, String memberName, Object o, Class clazz) {
        try {
            Object[] paramValues = OgdlIntrospectParser.evaluateEncloseArguments(ev.get(40, 41));
            return BeanIntrospectHelper.invokeMethod(clazz, o, memberName, paramValues);
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }

    private static Object invokeStaticMethod(OgdlEvent ev, String memberName, Object o) {
        try {
            Object[] paramValues = OgdlIntrospectParser.evaluateEncloseArguments(ev.get(40, 41));
            if (o instanceof Class) {
                return BeanIntrospectHelper.invokeMethod((Class)o, null, memberName, paramValues);
            }
            throw new OgdlSyntaxException(ev, "is not Class class.");
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }

    private static Object[] evaluateEncloseArguments(OgdlEvent ev) {
        Collection val = OgdlParser.evaluateEncloseCollection(ev.get(new LinkedList()));
        return ((List)val).toArray();
    }

    private static void writeInitProperties(OgdlEvent ev, Object obj) {
        Class<?> clazz = obj.getClass();
        if (ev.isNotOpen()) {
            throw new OgdlSyntaxException(ev, "syntax err.");
        }
        ev.shift();
        int close = ev.close;
        if (ev.isNotClose(close)) {
            while (ev.hasNext()) {
                ev.shiftSpace();
                String memberName = OgdlSyntax.cutMemberName(ev);
                if (ev.isCharAt(40)) {
                    OgdlIntrospectParser.invokeInitMethod(ev, memberName, obj, clazz);
                } else if (ev.isCharAt(91)) {
                    OgdlIntrospectParser.invokeInitIndexedProperty(ev, memberName, obj, clazz);
                } else {
                    OgdlIntrospectParser.invokeInitProperty(ev, memberName, obj, clazz);
                }
                ev.shiftSpace();
                if (ev.isClose(close)) break;
                if (ev.isNotSeparator()) {
                    throw new OgdlSyntaxException(ev, "is not comma.");
                }
                ev.shift();
                ev.shiftSpace();
            }
            ev.shiftSpace();
            if (ev.isNotClose(close)) {
                throw new OgdlSyntaxException(ev, "syntax err.");
            }
        }
        ev.shift();
        ev.shiftSpace();
    }

    private static void invokeInitIndexedProperty(OgdlEvent ev, String memberName, Object o, Class clazz) {
        try {
            Object inx;
            IndexedPropertyDescriptor ipd = BeanIntrospectHelper.getIndexedPropertyDescriptor(clazz, memberName);
            if (ipd != null) {
                inx = OgdlIntrospectParser.readIndexedValue(ev);
                ev.shiftSpace();
                if (ev.isNotMapSeparator()) {
                    throw new OgdlSyntaxException(ev, "is not equal.");
                }
            } else {
                throw new OgdlSyntaxException(ev, "is not Indexed property.");
            }
            ev.shift();
            ev.shiftSpace();
            BeanIntrospectHelper.setIndexedProperty(o, ipd.getIndexedWriteMethod(), (Integer)inx, OgdlRuntime.evaluate(ev));
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }

    private static void invokeInitMethod(OgdlEvent ev, String memberName, Object o, Class clazz) {
        try {
            Object[] paramValues = OgdlIntrospectParser.evaluateEncloseArguments(ev.get(40, 41));
            BeanIntrospectHelper.invokeMethod(clazz, o, memberName, paramValues);
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }

    private static void invokeInitProperty(OgdlEvent ev, String memberName, Object o, Class clazz) {
        try {
            PropertyDescriptor pd = BeanIntrospectHelper.getPropertyDescriptor(clazz, memberName);
            if (pd != null) {
                ev.shiftSpace();
                if (ev.isNotMapSeparator()) {
                    throw new OgdlSyntaxException(ev, "is not equal.");
                }
            } else {
                throw new OgdlSyntaxException(ev, "is not property.");
            }
            ev.shift();
            ev.shiftSpace();
            BeanIntrospectHelper.setProperty(o, pd.getWriteMethod(), OgdlRuntime.evaluate(ev));
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }
}

