/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import shohaku.ogdl.OgdlContext;
import shohaku.ogdl.OgdlParseIndex;
import shohaku.ogdl.OgdlSyntax;
import shohaku.ogdl.OgdlSyntaxException;
import shohaku.ogdl.Utils;

class OgdlEvent {
    final String ptn;
    final int len;
    final OgdlParseIndex off;
    final ClassLoader loader;
    final OgdlContext context;
    Object target;
    int open;
    int close;

    OgdlEvent(String pattern, OgdlParseIndex offset, ClassLoader loader, OgdlContext context) {
        this.ptn = pattern;
        this.len = pattern.length();
        this.off = offset;
        this.loader = loader;
        this.context = context;
    }

    OgdlEvent get(Object targetValue) {
        this.target = targetValue;
        return this;
    }

    OgdlEvent get(int openChar, int closeChar, Object targetValue) {
        this.open = openChar;
        this.close = closeChar;
        this.target = targetValue;
        return this;
    }

    OgdlEvent get(int openChar, int closeChar) {
        this.open = openChar;
        this.close = closeChar;
        return this;
    }

    boolean isCharAt(int c) {
        return this.off.get() < this.len && this.ptn.charAt(this.off.get()) == c;
    }

    boolean isCharAt(int c, int index) {
        return index < this.len && this.ptn.charAt(index) == c;
    }

    boolean isNotCharAt(int c) {
        return this.off.get() < this.len && this.ptn.charAt(this.off.get()) != c;
    }

    boolean isNotCharAt(int c, int index) {
        return index < this.len && this.ptn.charAt(index) != c;
    }

    boolean isClose(int closeChar) {
        return this.ptn.charAt(this.off.get()) == closeChar;
    }

    boolean isNotClose(int closeChar) {
        return this.ptn.charAt(this.off.get()) != closeChar;
    }

    boolean isNotOpen() {
        return this.ptn.charAt(this.off.get()) != this.open;
    }

    boolean isNotSeparator() {
        return this.ptn.charAt(this.off.get()) != ',';
    }

    boolean isNotMapSeparator() {
        return this.ptn.charAt(this.off.get()) != '=';
    }

    boolean isNotNextSpace() {
        return this.off.get() < this.len && this.ptn.charAt(this.off.get()) > ' ';
    }

    boolean startsWith(String prefix) {
        return this.ptn.startsWith(prefix, this.off.get());
    }

    int offset() {
        return this.off.get();
    }

    boolean hasNext() {
        return this.off.get() < this.len;
    }

    boolean hasNext(int add) {
        return this.off.get() + add < this.len;
    }

    boolean hasIndex(int index) {
        return index < this.len;
    }

    int charAt() {
        return this.ptn.charAt(this.off.get());
    }

    int charAt(int add) {
        return this.ptn.charAt(this.off.get() + add);
    }

    int charAtIndex(int index) {
        return this.ptn.charAt(index);
    }

    int charAtToUpper() {
        return OgdlSyntax.toUpper(this.ptn.charAt(this.off.get()));
    }

    int charAtToUpper(int add) {
        return OgdlSyntax.toUpper(this.ptn.charAt(this.off.get() + add));
    }

    int shift() {
        return this.off.increment();
    }

    int shift(int add) {
        return this.off.add(add);
    }

    void setIndex(int index) {
        this.off.set(index);
    }

    int shiftSpace() {
        this.off.set(OgdlSyntax.skipSpace(this));
        return this.off.get();
    }

    String cutForShift(int endIndex) {
        String sub = this.ptn.substring(this.off.get(), endIndex);
        this.off.set(endIndex);
        return sub;
    }

    String cutGroupStringForShift(int group) {
        int endIndex = OgdlSyntax.skip(this, group);
        String sub = this.ptn.substring(this.off.get(), endIndex);
        this.off.set(endIndex);
        return sub;
    }

    String cut(int endIndex) {
        return this.ptn.substring(this.off.get(), endIndex);
    }

    void validIndexForThrow() {
        if (!this.hasNext()) {
            throw new OgdlSyntaxException(this, Utils.log("index err.", (Object)this.ptn, this.off));
        }
    }

    void validIndexForThrow(int add) {
        if (!this.hasNext(add)) {
            throw new OgdlSyntaxException(this, Utils.log("index err.", (Object)this.ptn, this.off.get() + add));
        }
    }

    void validIndexForThrowIndex(int index) {
        if (!this.hasIndex(index)) {
            throw new OgdlSyntaxException(this, Utils.log("index err.", (Object)this.ptn, index));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("pattern=");
        sb.append(this.ptn);
        sb.append(",offset=");
        sb.append(this.off);
        sb.append(",target=");
        sb.append(this.target);
        sb.append("}");
        return sb.toString();
    }
}

