/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import shohaku.ogdl.OgdlContext;
import shohaku.ogdl.Utils;

public class OgdlContextMixIn
implements OgdlContext {
    private final Map _attributesMap;
    private final Map _classesMap;
    private final Map _functionsMap;
    private ClassLoader _classLoader;

    public OgdlContextMixIn(Map attributes, Map classes, Map functions) {
        this._attributesMap = attributes;
        this._classesMap = classes;
        this._functionsMap = functions;
    }

    public boolean addImport(Class clazz) {
        return null != this._classesMap.put(Utils.getShortClassName(clazz), clazz);
    }

    public Class forImport(String shortName) {
        return (Class)this._classesMap.get(shortName);
    }

    public void addFunctionsMap(String prefix, Map functionsMap) {
        if (!Utils.isEmpty(prefix)) {
            Iterator i = functionsMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                String funcName = (String)e.getKey();
                Collection func = (Collection)e.getValue();
                this._functionsMap.put(prefix + ':' + funcName, func);
            }
        } else {
            this._functionsMap.putAll(functionsMap);
        }
    }

    public Collection forFunctions(String name) {
        return (Collection)this._functionsMap.get(name);
    }

    public Iterator attributeNames() {
        return this._attributesMap.keySet().iterator();
    }

    public Object getAttribute(String name) {
        return this._attributesMap.get(name);
    }

    public void setAttribute(String name, Object value) {
        this._attributesMap.put(name, value);
    }

    public Object removeAttribute(String name) {
        return this._attributesMap.remove(name);
    }

    public boolean containsAttribute(String name) {
        return this._attributesMap.containsKey(name);
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public Map getClassesMap() {
        return this._classesMap;
    }

    public Map getFunctionsMap() {
        return this._functionsMap;
    }

    public Map getAttributesMap() {
        return this._attributesMap;
    }
}

