/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import shohaku.ogdl.BeanIntrospectHelper;
import shohaku.ogdl.Boxing;
import shohaku.ogdl.OgdlEvent;
import shohaku.ogdl.OgdlPrimitiveParser;
import shohaku.ogdl.OgdlRuntime;
import shohaku.ogdl.OgdlSyntax;
import shohaku.ogdl.OgdlSyntaxException;
import shohaku.ogdl.Progressions;
import shohaku.ogdl.Utils;

class OgdlCollectionParser {
    private static final BigDecimal BIGDECIMAL_ONE = new BigDecimal(BigInteger.ONE, 0);
    private static Map calendarConstants;

    OgdlCollectionParser() {
    }

    static Object evaluateArray(OgdlEvent ev) {
        if (OgdlCollectionParser.isSynchronizedView(ev)) {
            return OgdlCollectionParser.evaluateSynchronizedArrayAsList(ev);
        }
        if (OgdlCollectionParser.isUnmodifiableView(ev)) {
            return OgdlCollectionParser.evaluateUnmodifiableArrayAsList(ev);
        }
        if (OgdlCollectionParser.isFixedSizeView(ev)) {
            return OgdlCollectionParser.evaluateFixedSizeArrayAsList(ev);
        }
        if (OgdlCollectionParser.isUndecoratedView(ev)) {
            return OgdlCollectionParser.evaluateUndecoratedArray(ev);
        }
        return OgdlCollectionParser.evaluateUndecoratedArray(ev);
    }

    static Object evaluateCollection(OgdlEvent ev) {
        if (OgdlCollectionParser.isSynchronizedView(ev)) {
            return OgdlCollectionParser.evaluateSynchronizedCollection(ev);
        }
        if (OgdlCollectionParser.isUnmodifiableView(ev)) {
            return OgdlCollectionParser.evaluateUnmodifiableCollection(ev);
        }
        if (OgdlCollectionParser.isUndecoratedView(ev)) {
            return OgdlCollectionParser.evaluateUndecoratedCollection(ev);
        }
        return OgdlCollectionParser.evaluateUnmodifiableCollection(ev);
    }

    static Object evaluateSortedMap(OgdlEvent ev) {
        if (OgdlCollectionParser.isSynchronizedView(ev)) {
            return OgdlCollectionParser.evaluateSynchronizedSortedMap(ev);
        }
        if (OgdlCollectionParser.isUnmodifiableView(ev)) {
            return OgdlCollectionParser.evaluateUnmodifiableSortedMap(ev);
        }
        if (OgdlCollectionParser.isUndecoratedView(ev)) {
            return OgdlCollectionParser.evaluateUndecoratedSortedMap(ev);
        }
        return OgdlCollectionParser.evaluateUnmodifiableSortedMap(ev);
    }

    static Object evaluateMap(OgdlEvent ev) {
        if (OgdlCollectionParser.isSynchronizedView(ev)) {
            return OgdlCollectionParser.evaluateSynchronizedMap(ev);
        }
        if (OgdlCollectionParser.isUnmodifiableView(ev)) {
            return OgdlCollectionParser.evaluateUnmodifiableMap(ev);
        }
        if (OgdlCollectionParser.isUndecoratedView(ev)) {
            return OgdlCollectionParser.evaluateUndecoratedMap(ev);
        }
        return OgdlCollectionParser.evaluateUnmodifiableMap(ev);
    }

    static Object evaluateSortedSet(OgdlEvent ev) {
        if (OgdlCollectionParser.isSynchronizedView(ev)) {
            return OgdlCollectionParser.evaluateSynchronizedSortedSet(ev);
        }
        if (OgdlCollectionParser.isUnmodifiableView(ev)) {
            return OgdlCollectionParser.evaluateUnmodifiableSortedSet(ev);
        }
        if (OgdlCollectionParser.isUndecoratedView(ev)) {
            return OgdlCollectionParser.evaluateUndecoratedSortedSet(ev);
        }
        return OgdlCollectionParser.evaluateUnmodifiableSortedSet(ev);
    }

    static Object evaluateSet(OgdlEvent ev) {
        if (OgdlCollectionParser.isSynchronizedView(ev)) {
            return OgdlCollectionParser.evaluateSynchronizedSet(ev);
        }
        if (OgdlCollectionParser.isUnmodifiableView(ev)) {
            return OgdlCollectionParser.evaluateUnmodifiableSet(ev);
        }
        if (OgdlCollectionParser.isUndecoratedView(ev)) {
            return OgdlCollectionParser.evaluateUndecoratedSet(ev);
        }
        return OgdlCollectionParser.evaluateUnmodifiableSet(ev);
    }

    static Object evaluateList(OgdlEvent ev) {
        if (OgdlCollectionParser.isSynchronizedView(ev)) {
            return OgdlCollectionParser.evaluateSynchronizedList(ev);
        }
        if (OgdlCollectionParser.isUnmodifiableView(ev)) {
            return OgdlCollectionParser.evaluateUnmodifiableList(ev);
        }
        if (OgdlCollectionParser.isUndecoratedView(ev)) {
            return OgdlCollectionParser.evaluateUndecoratedList(ev);
        }
        return OgdlCollectionParser.evaluateUnmodifiableList(ev);
    }

    private static boolean isSynchronizedView(OgdlEvent ev) {
        if (ev.startsWith("syn:")) {
            ev.shift(4);
            return true;
        }
        return false;
    }

    private static boolean isUnmodifiableView(OgdlEvent ev) {
        if (ev.startsWith("unm:")) {
            ev.shift(4);
            return true;
        }
        return false;
    }

    private static boolean isUndecoratedView(OgdlEvent ev) {
        if (ev.startsWith("und:")) {
            ev.shift(4);
            return true;
        }
        return false;
    }

    private static boolean isFixedSizeView(OgdlEvent ev) {
        if (ev.startsWith("fix:")) {
            ev.shift(4);
            return true;
        }
        return false;
    }

    static Collection evaluateEncloseCollection(OgdlEvent ev) {
        if (ev.isNotOpen()) {
            throw new OgdlSyntaxException(ev, "syntax err.");
        }
        ev.shift();
        return OgdlCollectionParser.evaluateCloseCollection(ev);
    }

    static Collection evaluateCloseCollection(OgdlEvent ev) {
        Collection output = (Collection)ev.target;
        int close = ev.close;
        if (ev.isNotClose(close)) {
            while (ev.hasNext()) {
                ev.shiftSpace();
                output.add(OgdlRuntime.evaluate(ev));
                ev.validIndexForThrow();
                ev.shiftSpace();
                if (ev.isClose(close)) break;
                if (ev.isNotSeparator()) {
                    throw new OgdlSyntaxException(ev, "is not separator.");
                }
                ev.shift();
            }
            ev.shiftSpace();
            if (ev.isNotClose(close)) {
                throw new OgdlSyntaxException(ev, "syntax err.");
            }
        }
        ev.shift();
        return output;
    }

    static Map evaluateEncloseMap(OgdlEvent ev) {
        if (ev.isNotOpen()) {
            throw new OgdlSyntaxException(ev, "syntax err.");
        }
        ev.shift();
        return OgdlCollectionParser.evaluateCloseMap(ev);
    }

    static Map evaluateCloseMap(OgdlEvent ev) {
        Map output = (Map)ev.target;
        int close = ev.close;
        if (ev.isNotClose(close)) {
            while (ev.hasNext()) {
                ev.shiftSpace();
                Object rKey = OgdlRuntime.evaluate(ev);
                ev.shiftSpace();
                ev.validIndexForThrow();
                if (ev.isNotMapSeparator()) {
                    throw new OgdlSyntaxException(ev, "syntax err.");
                }
                ev.shift();
                ev.shiftSpace();
                Object val = OgdlRuntime.evaluate(ev);
                ev.shiftSpace();
                output.put(rKey, val);
                if (ev.isClose(close)) break;
                if (ev.isNotSeparator()) {
                    throw new OgdlSyntaxException(ev, "is not separator.");
                }
                ev.shift();
                ev.shiftSpace();
            }
            ev.shiftSpace();
            if (ev.isNotClose(close)) {
                throw new OgdlSyntaxException(ev, "syntax err.");
            }
        }
        ev.shift();
        return output;
    }

    static Collection evaluateEncloseProgressionCollection(OgdlEvent ev) {
        if (ev.isNotOpen()) {
            throw new OgdlSyntaxException(ev, "syntax err.");
        }
        ev.shift();
        return OgdlCollectionParser.evaluateCloseProgressionCollection(ev);
    }

    static Collection evaluateCloseProgressionCollection(OgdlEvent ev) {
        Collection output = (Collection)ev.target;
        int close = ev.close;
        if (ev.isNotClose(close)) {
            while (ev.hasNext()) {
                ev.shiftSpace();
                Object e = OgdlRuntime.evaluate(ev);
                ev.validIndexForThrow();
                if (ev.isClose(close)) {
                    output.add(e);
                    break;
                }
                if (ev.isCharAt(58)) {
                    ev.shift();
                    Object to = OgdlRuntime.evaluate(ev);
                    OgdlCollectionParser.addListProgressionValue(ev, output, e, to);
                } else {
                    output.add(e);
                }
                ev.validIndexForThrow();
                ev.shiftSpace();
                if (ev.isClose(close)) break;
                if (ev.isNotSeparator()) {
                    throw new OgdlSyntaxException(ev, "is not separator.");
                }
                ev.shift();
            }
            ev.shiftSpace();
            if (ev.isNotClose(close)) {
                throw new OgdlSyntaxException(ev, "syntax err.");
            }
        }
        ev.shift();
        return output;
    }

    private static void addListProgressionValue(OgdlEvent ev, Collection output, Object from, Object to) {
        String difference = null;
        ev.shiftSpace();
        if (ev.isCharAt(40)) {
            ev.shift();
            ev.shiftSpace();
            difference = OgdlSyntax.cutDifferenceString(ev);
            ev.shiftSpace();
            if (ev.isNotCharAt(41)) {
                throw new OgdlSyntaxException(ev, "syntax err.");
            }
            ev.shift();
            OgdlCollectionParser.addNumberDomain(ev, output, from, to, difference);
        } else {
            OgdlCollectionParser.addNumberDomain(ev, output, from, to);
        }
    }

    static Object evaluateDefaultMap(OgdlEvent ev) {
        LinkedHashMap output = new LinkedHashMap();
        return Collections.unmodifiableMap(OgdlCollectionParser.evaluateEncloseMap(ev.get(123, 125, output)));
    }

    static Object evaluateDefaultList(OgdlEvent ev) {
        ArrayList output = new ArrayList();
        return Collections.unmodifiableList((List)OgdlCollectionParser.evaluateEncloseProgressionCollection(ev.get(91, 93, output)));
    }

    static Object evaluateDefaultSet(OgdlEvent ev) {
        LinkedHashSet output = new LinkedHashSet();
        return Collections.unmodifiableSet((Set)OgdlCollectionParser.evaluateEncloseProgressionCollection(ev.get(60, 62, output)));
    }

    private static Object evaluateUndecoratedList(OgdlEvent ev) {
        List output = null;
        if (OgdlSyntax.isBeginMember(ev)) {
            Object val = OgdlCollectionParser.newCollectionInstance(ev);
            try {
                output = (List)val;
            }
            catch (ClassCastException e) {
                throw new OgdlSyntaxException(ev, "not list type. " + val.getClass(), e);
            }
        } else {
            output = new ArrayList();
        }
        ev.shiftSpace();
        return OgdlCollectionParser.evaluateEncloseProgressionCollection(ev.get(123, 125, output));
    }

    private static Object evaluateSynchronizedList(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedList(ev);
        return Collections.synchronizedList((List)val);
    }

    private static Object evaluateUnmodifiableList(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedList(ev);
        return Collections.unmodifiableList((List)val);
    }

    private static Object evaluateUndecoratedSet(OgdlEvent ev) {
        Set output = null;
        if (OgdlSyntax.isBeginMember(ev)) {
            Object val = OgdlCollectionParser.newCollectionInstance(ev);
            try {
                output = (Set)val;
            }
            catch (ClassCastException e) {
                throw new OgdlSyntaxException(ev, "not set type. " + val.getClass(), e);
            }
        } else {
            output = new LinkedHashSet();
        }
        ev.shiftSpace();
        return OgdlCollectionParser.evaluateEncloseProgressionCollection(ev.get(123, 125, output));
    }

    private static Object evaluateSynchronizedSet(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedSet(ev);
        Set set = Collections.synchronizedSet((Set)val);
        return set;
    }

    private static Object evaluateUnmodifiableSet(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedSet(ev);
        Set set = Collections.unmodifiableSet((Set)val);
        return set;
    }

    private static Object evaluateUndecoratedSortedSet(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedSet(ev);
        try {
            SortedSet sortedSet = Collections.synchronizedSortedSet((SortedSet)val);
            return sortedSet;
        }
        catch (ClassCastException e) {
            throw new OgdlSyntaxException(ev, "not SortedSet type. " + val.getClass(), e);
        }
    }

    private static Object evaluateSynchronizedSortedSet(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedSortedSet(ev);
        return Collections.synchronizedSortedSet((SortedSet)val);
    }

    private static Object evaluateUnmodifiableSortedSet(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedSortedSet(ev);
        return Collections.unmodifiableSortedSet((SortedSet)val);
    }

    private static Map evaluateUndecoratedMap(OgdlEvent ev) {
        Map output = null;
        if (OgdlSyntax.isBeginMember(ev)) {
            Object val = OgdlCollectionParser.newCollectionInstance(ev);
            try {
                output = (Map)val;
            }
            catch (ClassCastException e) {
                throw new OgdlSyntaxException(ev, "not map type. " + val.getClass(), e);
            }
        } else {
            output = new LinkedHashMap();
        }
        ev.shiftSpace();
        return OgdlCollectionParser.evaluateEncloseMap(ev.get(123, 125, output));
    }

    private static Object evaluateSynchronizedMap(OgdlEvent ev) {
        return Collections.synchronizedMap(OgdlCollectionParser.evaluateUndecoratedMap(ev));
    }

    private static Object evaluateUnmodifiableMap(OgdlEvent ev) {
        return Collections.unmodifiableMap(OgdlCollectionParser.evaluateUndecoratedMap(ev));
    }

    private static Object evaluateUndecoratedSortedMap(OgdlEvent ev) {
        Map val = OgdlCollectionParser.evaluateUndecoratedMap(ev);
        try {
            SortedMap sortedMap = Collections.synchronizedSortedMap((SortedMap)val);
            return sortedMap;
        }
        catch (ClassCastException e) {
            throw new OgdlSyntaxException(ev, "not SortedMap type. " + val.getClass(), e);
        }
    }

    private static Object evaluateSynchronizedSortedMap(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedSortedMap(ev);
        return Collections.synchronizedSortedMap((SortedMap)val);
    }

    private static Object evaluateUnmodifiableSortedMap(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedSortedMap(ev);
        SortedMap sortedMap = Collections.unmodifiableSortedMap((SortedMap)val);
        return sortedMap;
    }

    private static Object evaluateUndecoratedArray(OgdlEvent ev) {
        Class clazz = OgdlSyntax.isBeginMember(ev) ? OgdlPrimitiveParser.evaluateClassByExtendName(ev) : Object.class;
        ev.shiftSpace();
        List list = (List)OgdlCollectionParser.evaluateEncloseProgressionCollection(ev.get(123, 125, new LinkedList()));
        Object output = null;
        try {
            output = Utils.toArray(list, clazz);
        }
        catch (IllegalArgumentException e) {
            throw new OgdlSyntaxException(ev, "array item type mismatch.", e);
        }
        return output;
    }

    private static Object evaluateFixedSizeArrayAsList(OgdlEvent ev) {
        Class clazz = OgdlSyntax.isBeginMember(ev) ? OgdlPrimitiveParser.evaluateClassByExtendName(ev) : Object.class;
        ev.shiftSpace();
        List list = (List)OgdlCollectionParser.evaluateEncloseProgressionCollection(ev.get(123, 125, new LinkedList()));
        List<Object> output = null;
        try {
            output = clazz.isPrimitive() ? Arrays.asList((Object[])Utils.toArray(list, Boxing.boxClass(clazz))) : Arrays.asList((Object[])Utils.toArray(list, clazz));
        }
        catch (IllegalArgumentException e) {
            throw new OgdlSyntaxException(ev, "array item type mismatch.", e);
        }
        return output;
    }

    private static Object evaluateSynchronizedArrayAsList(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateFixedSizeArrayAsList(ev);
        return Collections.synchronizedList((List)val);
    }

    private static Object evaluateUnmodifiableArrayAsList(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateFixedSizeArrayAsList(ev);
        return Collections.unmodifiableList((List)val);
    }

    private static Object evaluateUndecoratedCollection(OgdlEvent ev) {
        Collection output = null;
        if (!OgdlSyntax.isBeginMember(ev)) {
            throw new OgdlSyntaxException(ev, "collection class is empty.");
        }
        Object val = OgdlCollectionParser.newCollectionInstance(ev);
        try {
            output = (Collection)val;
        }
        catch (ClassCastException e) {
            throw new OgdlSyntaxException(ev, "not collection type. " + val.getClass(), e);
        }
        ev.shiftSpace();
        return OgdlCollectionParser.evaluateEncloseProgressionCollection(ev.get(123, 125, output));
    }

    private static Object evaluateSynchronizedCollection(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedCollection(ev);
        Collection coll = Collections.synchronizedCollection((Collection)val);
        return coll;
    }

    private static Object evaluateUnmodifiableCollection(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedCollection(ev);
        Collection coll = Collections.unmodifiableCollection((Collection)val);
        return coll;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addNumberDomain(OgdlEvent ev, Collection coll, Object from, Object to) {
        if (from instanceof Number && to instanceof Number) {
            if (from instanceof Byte && to instanceof Byte) {
                Progressions.addArithmeticProgression(coll, (Byte)from, (Byte)to, (byte)1);
                return;
            } else if (from instanceof Short && to instanceof Short) {
                Progressions.addArithmeticProgression(coll, (Short)from, (Short)to, (short)1);
                return;
            } else if (from instanceof Integer && to instanceof Integer) {
                Progressions.addArithmeticProgression(coll, (Integer)from, (Integer)to, 1);
                return;
            } else if (from instanceof Long && to instanceof Long) {
                Progressions.addArithmeticProgression(coll, (Long)from, (Long)to, 1L);
                return;
            } else if (from instanceof Float && to instanceof Float) {
                Progressions.addArithmeticProgression(coll, (Float)from, (Float)to, 1);
                return;
            } else if (from instanceof Double && to instanceof Double) {
                Progressions.addArithmeticProgression(coll, (Double)from, (Double)to, 1L);
                return;
            } else if (from instanceof BigInteger && to instanceof BigInteger) {
                Progressions.addArithmeticProgression(coll, (BigInteger)from, (BigInteger)to, BigInteger.ONE);
                return;
            } else {
                if (!(from instanceof BigDecimal) || !(to instanceof BigDecimal)) throw new OgdlSyntaxException(ev, "no domain type. ");
                Progressions.addArithmeticProgression(coll, (BigDecimal)from, (BigDecimal)to, BIGDECIMAL_ONE);
            }
            return;
        } else if (from instanceof Character && to instanceof Character) {
            Progressions.addArithmeticProgression(coll, (Character)from, (Character)to, 1);
            return;
        } else {
            if (!(from instanceof Date) || !(to instanceof Date)) throw new OgdlSyntaxException(ev, "no domain type. ");
            Progressions.addDateTimeProgression(coll, (Date)from, (Date)to, 5, 1);
        }
    }

    private static void addNumberDomain(OgdlEvent ev, Collection coll, Object from, Object to, String difference) {
        block15: {
            try {
                if (from instanceof Number && to instanceof Number) {
                    if (from instanceof Byte && to instanceof Byte) {
                        Progressions.addArithmeticProgression(coll, (Byte)from, (Byte)to, Byte.parseByte(difference));
                        break block15;
                    }
                    if (from instanceof Short && to instanceof Short) {
                        Progressions.addArithmeticProgression(coll, (Short)from, (Short)to, Short.parseShort(difference));
                        break block15;
                    }
                    if (from instanceof Integer && to instanceof Integer) {
                        Progressions.addArithmeticProgression(coll, (Integer)from, (Integer)to, Integer.parseInt(difference));
                        break block15;
                    }
                    if (from instanceof Long && to instanceof Long) {
                        Progressions.addArithmeticProgression(coll, (Long)from, (Long)to, Long.parseLong(difference));
                        break block15;
                    }
                    if (from instanceof Float && to instanceof Float) {
                        Progressions.addArithmeticProgression(coll, (Float)from, (Float)to, Integer.parseInt(difference));
                        break block15;
                    }
                    if (from instanceof Double && to instanceof Double) {
                        Progressions.addArithmeticProgression(coll, (Double)from, (Double)to, Long.parseLong(difference));
                        break block15;
                    }
                    if (from instanceof BigInteger && to instanceof BigInteger) {
                        Progressions.addArithmeticProgression(coll, (BigInteger)from, (BigInteger)to, new BigInteger(difference));
                        break block15;
                    }
                    if (from instanceof BigDecimal && to instanceof BigDecimal) {
                        Progressions.addArithmeticProgression(coll, (BigDecimal)from, (BigDecimal)to, new BigDecimal(difference));
                        break block15;
                    }
                    throw new OgdlSyntaxException(ev, "no domain type. ");
                }
                if (from instanceof Character && to instanceof Character) {
                    Progressions.addArithmeticProgression(coll, (Character)from, (Character)to, Integer.parseInt(difference));
                    break block15;
                }
                if (from instanceof Date && to instanceof Date) {
                    int[] differences = OgdlCollectionParser.toDateDifferences(ev, difference);
                    if (differences[2] == 1) {
                        Progressions.addDateTimeInMillisProgression(coll, (Date)from, (Date)to, differences[0], differences[1]);
                    } else {
                        Progressions.addDateTimeProgression(coll, (Date)from, (Date)to, differences[0], differences[1]);
                    }
                    break block15;
                }
                throw new OgdlSyntaxException(ev, "no domain type. ");
            }
            catch (NumberFormatException e) {
                throw new OgdlSyntaxException(ev, "number syntax err.", e);
            }
        }
    }

    private static int[] toDateDifferences(OgdlEvent ev, String difference) {
        String[] splits = difference.split("\\.");
        if (splits.length != 2 && splits.length != 3) {
            throw new OgdlSyntaxException(ev, Utils.log("range difference syntax err. difference=", difference));
        }
        int[] differences = new int[]{5, 1, 0};
        if (splits.length == 3) {
            differences[2] = splits[2].equalsIgnoreCase("L") ? 1 : 0;
        }
        differences[1] = Integer.parseInt(splits[1]);
        Integer ofield = (Integer)OgdlCollectionParser.getCalendarConstants(ev).get(splits[0]);
        if (ofield == null) {
            throw new OgdlSyntaxException(ev, Utils.log("not is calendar field. field=", splits[0]));
        }
        differences[0] = ofield;
        return differences;
    }

    private static Object newCollectionInstance(OgdlEvent ev) {
        Object output;
        Class type = OgdlPrimitiveParser.evaluateClassByExtendName(ev);
        try {
            output = BeanIntrospectHelper.newInstance(type);
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
        return output;
    }

    private static Map getCalendarConstants(OgdlEvent ev) {
        Map consts = calendarConstants;
        try {
            return consts != null ? consts : (calendarConstants = BeanIntrospectHelper.getConstantFieldMap(Calendar.class));
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }
}

