/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.util.List;
import java.util.Map;
import shohaku.ogdl.OgdlContext;
import shohaku.ogdl.OgdlEvent;
import shohaku.ogdl.OgdlHelper;
import shohaku.ogdl.OgdlParseIndex;
import shohaku.ogdl.OgdlRuntime;
import shohaku.ogdl.OgdlSyntaxException;

public class Ogdl {
    private OgdlContext context;

    public Object evaluate(String pattern) throws OgdlSyntaxException {
        OgdlEvent ev = this.newOgdlEvent(pattern, new OgdlParseIndex(0));
        try {
            Object rvalue = OgdlRuntime.evaluate(ev);
            if (ev.hasNext()) {
                throw new OgdlSyntaxException(ev, "is not end index.");
            }
            return rvalue;
        }
        catch (OgdlSyntaxException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new OgdlSyntaxException(ev, "java runtime err.", e);
        }
    }

    public Object evaluate(String pattern, OgdlParseIndex offset) throws OgdlSyntaxException {
        OgdlEvent ev = this.newOgdlEvent(pattern, offset);
        try {
            return OgdlRuntime.evaluate(ev);
        }
        catch (OgdlSyntaxException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new OgdlSyntaxException(ev, "java runtime err.", e);
        }
    }

    public List evaluateList(String pattern, OgdlParseIndex offset, char open, char close) throws OgdlSyntaxException {
        OgdlEvent ev = this.newOgdlEvent(pattern, offset);
        try {
            return OgdlRuntime.evaluateList(ev.get(open, close));
        }
        catch (OgdlSyntaxException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new OgdlSyntaxException(ev, "java runtime err.", e);
        }
    }

    public List evaluateList(String pattern, OgdlParseIndex offset, char close) throws OgdlSyntaxException {
        OgdlEvent ev = this.newOgdlEvent(pattern, offset);
        try {
            return OgdlRuntime.evaluateCloseList(ev.get(0, close));
        }
        catch (OgdlSyntaxException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new OgdlSyntaxException(ev, "java runtime err.", e);
        }
    }

    public Map evaluateMap(String pattern, OgdlParseIndex offset, char open, char close) throws OgdlSyntaxException {
        OgdlEvent ev = this.newOgdlEvent(pattern, offset);
        try {
            return OgdlRuntime.evaluateMap(ev.get(open, close));
        }
        catch (OgdlSyntaxException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new OgdlSyntaxException(ev, "java runtime err.", e);
        }
    }

    public Map evaluateMap(String pattern, OgdlParseIndex offset, char close) throws OgdlSyntaxException {
        OgdlEvent ev = this.newOgdlEvent(pattern, offset);
        try {
            return OgdlRuntime.evaluateCloseMap(ev.get(0, close));
        }
        catch (OgdlSyntaxException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new OgdlSyntaxException(ev, "java runtime err.", e);
        }
    }

    OgdlEvent newOgdlEvent(String pattern, OgdlParseIndex offset) {
        return new OgdlEvent(pattern, offset, this.findClassLoader(), this.findContext());
    }

    ClassLoader findClassLoader() {
        return this.context.getClassLoader() == null ? Ogdl.class.getClassLoader() : this.context.getClassLoader();
    }

    OgdlContext findContext() {
        return this.context == null ? OgdlHelper.getOgdlContext() : this.context;
    }

    public OgdlContext getContext() {
        return this.context;
    }

    public void setContext(OgdlContext context) {
        this.context = context;
    }
}

