/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

final class Boxing {
    Boxing() {
    }

    public static Class boxClass(Class primitiveType) {
        if (primitiveType == null) {
            throw new NullPointerException();
        }
        if (Boolean.TYPE.equals(primitiveType)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(primitiveType)) {
            return Character.class;
        }
        if (Byte.TYPE.equals(primitiveType)) {
            return Byte.class;
        }
        if (Short.TYPE.equals(primitiveType)) {
            return Short.class;
        }
        if (Integer.TYPE.equals(primitiveType)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(primitiveType)) {
            return Long.class;
        }
        if (Float.TYPE.equals(primitiveType)) {
            return Float.class;
        }
        if (Double.TYPE.equals(primitiveType)) {
            return Double.class;
        }
        if (Void.TYPE.equals(primitiveType)) {
            return Void.class;
        }
        throw new IllegalArgumentException("It is not a primitive type.");
    }

    public static Class unboxClass(Class wrpperType) {
        if (wrpperType == null) {
            throw new NullPointerException();
        }
        if (Boolean.class.equals(wrpperType)) {
            return Boolean.TYPE;
        }
        if (Character.class.equals(wrpperType)) {
            return Character.TYPE;
        }
        if (Byte.class.equals(wrpperType)) {
            return Byte.TYPE;
        }
        if (Short.class.equals(wrpperType)) {
            return Short.TYPE;
        }
        if (Integer.class.equals(wrpperType)) {
            return Integer.TYPE;
        }
        if (Long.class.equals(wrpperType)) {
            return Long.TYPE;
        }
        if (Float.class.equals(wrpperType)) {
            return Float.TYPE;
        }
        if (Double.class.equals(wrpperType)) {
            return Double.TYPE;
        }
        if (Void.class.equals(wrpperType)) {
            return Void.TYPE;
        }
        throw new IllegalArgumentException("It is not a primitive wrpper type.");
    }

    public static char unbox(Character src) {
        return src.charValue();
    }

    public static boolean unbox(Boolean src) {
        return src;
    }

    public static byte unbox(Byte src) {
        return src;
    }

    public static short unbox(Short src) {
        return src;
    }

    public static int unbox(Integer src) {
        return src;
    }

    public static long unbox(Long src) {
        return src;
    }

    public static float unbox(Float src) {
        return src.floatValue();
    }

    public static double unbox(Double src) {
        return src;
    }

    public static char unbox(Character src, char nullValue) {
        return src == null ? nullValue : src.charValue();
    }

    public static boolean unbox(Boolean src, boolean nullValue) {
        return src == null ? nullValue : src;
    }

    public static byte unbox(Byte src, byte nullValue) {
        return src == null ? nullValue : src;
    }

    public static short unbox(Short src, short nullValue) {
        return src == null ? nullValue : src;
    }

    public static int unbox(Integer src, int nullValue) {
        return src == null ? nullValue : src;
    }

    public static long unbox(Long src, long nullValue) {
        return src == null ? nullValue : src;
    }

    public static float unbox(Float src, float nullValue) {
        return src == null ? nullValue : src.floatValue();
    }

    public static double unbox(Double src, double nullValue) {
        return src == null ? nullValue : src;
    }

    public static Character box(char src) {
        if (src <= '\u007f') {
            return CharacterCache.cache[src];
        }
        return new Character(src);
    }

    public static Boolean box(boolean src) {
        return src;
    }

    public static Byte box(byte src) {
        return ByteCache.cache[src + 128];
    }

    public static Short box(short src) {
        short asInt = src;
        if (asInt >= -128 && asInt <= 127) {
            return ShortCache.cache[asInt + 128];
        }
        return new Short(src);
    }

    public static Integer box(int src) {
        if (src >= -128 && src <= 127) {
            return IntegerCache.cache[src + 128];
        }
        return new Integer(src);
    }

    public static Long box(long src) {
        if (src >= -128L && src <= 127L) {
            return LongCache.cache[(int)src + 128];
        }
        return new Long(src);
    }

    public static Float box(float src) {
        return new Float(src);
    }

    public static Double box(double src) {
        return new Double(src);
    }

    public static char[] unbox(Character[] src) {
        int size = src.length;
        char[] a = new char[size];
        for (int i = 0; i < size; ++i) {
            a[i] = Boxing.unbox(src[i]);
        }
        return a;
    }

    public static boolean[] unbox(Boolean[] src) {
        int size = src.length;
        boolean[] a = new boolean[size];
        for (int i = 0; i < size; ++i) {
            a[i] = Boxing.unbox(src[i]);
        }
        return a;
    }

    public static byte[] unbox(Byte[] src) {
        int size = src.length;
        byte[] a = new byte[size];
        for (int i = 0; i < size; ++i) {
            a[i] = Boxing.unbox(src[i]);
        }
        return a;
    }

    public static short[] unbox(Short[] src) {
        int size = src.length;
        short[] a = new short[size];
        for (int i = 0; i < size; ++i) {
            a[i] = Boxing.unbox(src[i]);
        }
        return a;
    }

    public static int[] unbox(Integer[] src) {
        int size = src.length;
        int[] a = new int[size];
        for (int i = 0; i < size; ++i) {
            a[i] = Boxing.unbox(src[i]);
        }
        return a;
    }

    public static long[] unbox(Long[] src) {
        int size = src.length;
        long[] a = new long[size];
        for (int i = 0; i < size; ++i) {
            a[i] = Boxing.unbox(src[i]);
        }
        return a;
    }

    public static float[] unbox(Float[] src) {
        int size = src.length;
        float[] a = new float[size];
        for (int i = 0; i < size; ++i) {
            a[i] = Boxing.unbox(src[i]);
        }
        return a;
    }

    public static double[] unbox(Double[] src) {
        int size = src.length;
        double[] a = new double[size];
        for (int i = 0; i < size; ++i) {
            a[i] = Boxing.unbox(src[i]);
        }
        return a;
    }

    public static char[] unbox(Character[] src, char nullValue) {
        int size = src.length;
        char[] a = new char[size];
        for (int i = 0; i < size; ++i) {
            a[i] = Boxing.unbox(src[i], nullValue);
        }
        return a;
    }

    public static boolean[] unbox(Boolean[] src, boolean nullValue) {
        int size = src.length;
        boolean[] a = new boolean[size];
        for (int i = 0; i < size; ++i) {
            a[i] = Boxing.unbox(src[i], nullValue);
        }
        return a;
    }

    public static byte[] unbox(Byte[] src, byte nullValue) {
        int size = src.length;
        byte[] a = new byte[size];
        for (int i = 0; i < size; ++i) {
            a[i] = Boxing.unbox(src[i], nullValue);
        }
        return a;
    }

    public static short[] unbox(Short[] src, short nullValue) {
        int size = src.length;
        short[] a = new short[size];
        for (int i = 0; i < size; ++i) {
            a[i] = Boxing.unbox(src[i], nullValue);
        }
        return a;
    }

    public static int[] unbox(Integer[] src, int nullValue) {
        int size = src.length;
        int[] a = new int[size];
        for (int i = 0; i < size; ++i) {
            a[i] = Boxing.unbox(src[i], nullValue);
        }
        return a;
    }

    public static long[] unbox(Long[] src, long nullValue) {
        int size = src.length;
        long[] a = new long[size];
        for (int i = 0; i < size; ++i) {
            a[i] = Boxing.unbox(src[i], nullValue);
        }
        return a;
    }

    public static float[] unbox(Float[] src, float nullValue) {
        int size = src.length;
        float[] a = new float[size];
        for (int i = 0; i < size; ++i) {
            a[i] = Boxing.unbox(src[i], nullValue);
        }
        return a;
    }

    public static double[] unbox(Double[] src, double nullValue) {
        int size = src.length;
        double[] a = new double[size];
        for (int i = 0; i < size; ++i) {
            a[i] = Boxing.unbox(src[i], nullValue);
        }
        return a;
    }

    public static Character[] box(char[] src) {
        int len = src.length;
        Character[] a = new Character[len];
        for (int i = 0; i < len; ++i) {
            a[i] = Boxing.box(src[i]);
        }
        return a;
    }

    public static Boolean[] box(boolean[] src) {
        int len = src.length;
        Boolean[] a = new Boolean[len];
        for (int i = 0; i < len; ++i) {
            a[i] = Boxing.box(src[i]);
        }
        return a;
    }

    public static Byte[] box(byte[] src) {
        int len = src.length;
        Byte[] a = new Byte[len];
        for (int i = 0; i < len; ++i) {
            a[i] = Boxing.box(src[i]);
        }
        return a;
    }

    public static Short[] box(short[] src) {
        int len = src.length;
        Short[] a = new Short[len];
        for (int i = 0; i < len; ++i) {
            a[i] = Boxing.box(src[i]);
        }
        return a;
    }

    public static Integer[] box(int[] src) {
        int len = src.length;
        Integer[] a = new Integer[len];
        for (int i = 0; i < len; ++i) {
            a[i] = Boxing.box(src[i]);
        }
        return a;
    }

    public static Long[] box(long[] src) {
        int len = src.length;
        Long[] a = new Long[len];
        for (int i = 0; i < len; ++i) {
            a[i] = Boxing.box(src[i]);
        }
        return a;
    }

    public static Float[] box(float[] src) {
        int len = src.length;
        Float[] a = new Float[len];
        for (int i = 0; i < len; ++i) {
            a[i] = Boxing.box(src[i]);
        }
        return a;
    }

    public static Double[] box(double[] src) {
        int len = src.length;
        Double[] a = new Double[len];
        for (int i = 0; i < len; ++i) {
            a[i] = Boxing.box(src[i]);
        }
        return a;
    }

    private static class LongCache {
        static final Long[] cache = new Long[256];

        private LongCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                LongCache.cache[i] = new Long(i - 128);
            }
        }
    }

    private static class IntegerCache {
        static final Integer[] cache = new Integer[256];

        private IntegerCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                IntegerCache.cache[i] = new Integer(i - 128);
            }
        }
    }

    private static class ShortCache {
        static final Short[] cache = new Short[256];

        private ShortCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                ShortCache.cache[i] = new Short((short)(i - 128));
            }
        }
    }

    private static class ByteCache {
        static final Byte[] cache = new Byte[256];

        private ByteCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                ByteCache.cache[i] = new Byte((byte)(i - 128));
            }
        }
    }

    private static class CharacterCache {
        static final Character[] cache = new Character[128];

        private CharacterCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                CharacterCache.cache[i] = new Character((char)i);
            }
        }
    }
}

