/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import shohaku.ogdl.BeanIntrospectDescriptor;
import shohaku.ogdl.OgdlSyntaxException;
import shohaku.ogdl.Utils;

class BeanIntrospectHelper {
    static final Class[] EMPTY_ARG_TYPES = new Class[0];
    static final Object[] EMPTY_ARG_VALUES = new Object[0];

    BeanIntrospectHelper() {
    }

    static PropertyDescriptor getPropertyDescriptor(Class clazz, String propName) {
        return BeanIntrospectHelper.getBeanDescriptor(clazz).getPropertyDescriptor(propName);
    }

    static IndexedPropertyDescriptor getIndexedPropertyDescriptor(Class clazz, String propName) {
        PropertyDescriptor pd = BeanIntrospectHelper.getPropertyDescriptor(clazz, propName);
        if (pd instanceof IndexedPropertyDescriptor) {
            return (IndexedPropertyDescriptor)pd;
        }
        return null;
    }

    static Object getProperty(Object bean, Method readPropertyMethod) {
        if (Utils.isOrNull(bean, readPropertyMethod)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            return readPropertyMethod.invoke(bean, (Object[])null);
        }
        catch (IllegalArgumentException e) {
            throw new OgdlSyntaxException(Utils.log("get property err. ", bean.getClass(), readPropertyMethod), e);
        }
        catch (IllegalAccessException e) {
            throw new OgdlSyntaxException(Utils.log("get property err. ", bean.getClass(), readPropertyMethod), e);
        }
        catch (InvocationTargetException e) {
            throw new OgdlSyntaxException(Utils.log("get property err. ", bean.getClass(), readPropertyMethod), e);
        }
    }

    static Object getIndexedProperty(Object bean, Method readIndexedPropertyMethod, Integer index) {
        if (Utils.isOrNull(bean, readIndexedPropertyMethod)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            return readIndexedPropertyMethod.invoke(bean, index);
        }
        catch (IllegalArgumentException e) {
            throw new OgdlSyntaxException(Utils.log("get indexed property err. ", bean.getClass(), readIndexedPropertyMethod, index), e);
        }
        catch (IllegalAccessException e) {
            throw new OgdlSyntaxException(Utils.log("get indexed property err. ", bean.getClass(), readIndexedPropertyMethod, index), e);
        }
        catch (InvocationTargetException e) {
            throw new OgdlSyntaxException(Utils.log("get indexed property err. ", bean.getClass(), readIndexedPropertyMethod, index), e);
        }
    }

    static void setProperty(Object bean, Method writePropertyMethod, Object newValue) {
        if (Utils.isOrNull(bean, writePropertyMethod)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            writePropertyMethod.invoke(bean, newValue);
        }
        catch (IllegalArgumentException e) {
            throw new OgdlSyntaxException(Utils.log("set property err. ", bean.getClass(), writePropertyMethod, newValue), e);
        }
        catch (IllegalAccessException e) {
            throw new OgdlSyntaxException(Utils.log("set property err. ", bean.getClass(), writePropertyMethod, newValue), e);
        }
        catch (InvocationTargetException e) {
            throw new OgdlSyntaxException(Utils.log("set property err. ", bean.getClass(), writePropertyMethod, newValue), e);
        }
    }

    static void setIndexedProperty(Object bean, Method writeIndexedPropertyMethod, Integer index, Object newValue) {
        if (Utils.isOrNull(bean, writeIndexedPropertyMethod)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            writeIndexedPropertyMethod.invoke(bean, index, newValue);
        }
        catch (IllegalArgumentException e) {
            throw new OgdlSyntaxException(Utils.log("set property err. ", bean.getClass(), writeIndexedPropertyMethod, index, newValue), e);
        }
        catch (IllegalAccessException e) {
            throw new OgdlSyntaxException(Utils.log("set property err. ", bean.getClass(), writeIndexedPropertyMethod, index, newValue), e);
        }
        catch (InvocationTargetException e) {
            throw new OgdlSyntaxException(Utils.log("set property err. ", bean.getClass(), writeIndexedPropertyMethod, index, newValue), e);
        }
    }

    static Method getMethod(Class clazz, String methodName, Class[] paramTypes) {
        return BeanIntrospectHelper.getBeanDescriptor(clazz).getAssignmentMethod(methodName, paramTypes);
    }

    static Object invokeMethod(Class clazz, Object obj, String methodName, Object[] paramValues) {
        if (Utils.isOrNull(clazz, methodName, paramValues)) {
            throw new NullPointerException("argument is null.");
        }
        Class[] paramTypes = BeanIntrospectHelper.toClassArray(paramValues);
        Method method = BeanIntrospectHelper.getMethod(clazz, methodName, paramTypes);
        if (method == null) {
            throw new OgdlSyntaxException(Utils.log("not matching method, ", clazz, methodName, paramTypes, paramValues));
        }
        try {
            if (Modifier.isStatic(method.getModifiers())) {
                return method.invoke(null, paramValues);
            }
            if (obj == null) {
                throw new NullPointerException("argument obj is null.");
            }
            return method.invoke(obj, paramValues);
        }
        catch (IllegalArgumentException e) {
            throw new OgdlSyntaxException(Utils.log("method invocation err. ", clazz, methodName, paramTypes, paramValues), e);
        }
        catch (IllegalAccessException e) {
            throw new OgdlSyntaxException(Utils.log("method invocation err. ", clazz, methodName, paramTypes, paramValues), e);
        }
        catch (InvocationTargetException e) {
            throw new OgdlSyntaxException(Utils.log("method invocation err. ", clazz, methodName, paramTypes, paramValues), e);
        }
    }

    static Map getStaticMethodGroup(Class clazz) {
        return BeanIntrospectHelper.getBeanDescriptor(clazz).getStaticMethodGroup();
    }

    static Field getField(Class clazz, String fieldName) {
        return BeanIntrospectHelper.getBeanDescriptor(clazz).getField(fieldName);
    }

    static Object getFieldValue(Class clazz, Object obj, String fieldName) {
        try {
            return BeanIntrospectHelper.getField(clazz, fieldName).get(obj);
        }
        catch (IllegalArgumentException e) {
            throw new OgdlSyntaxException(Utils.log("get field err. ", (Object)clazz, fieldName), e);
        }
        catch (IllegalAccessException e) {
            throw new OgdlSyntaxException(Utils.log("get field err. ", (Object)clazz, fieldName), e);
        }
    }

    static Map getConstantFieldMap(Class clazz) {
        return BeanIntrospectHelper.getBeanDescriptor(clazz).getConstantFieldMap();
    }

    static Constructor getConstructor(Class clazz, Class[] paramTypes) {
        return BeanIntrospectHelper.getBeanDescriptor(clazz).getAssignmentConstructor(paramTypes);
    }

    static Object newInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (SecurityException e) {
            throw new OgdlSyntaxException(Utils.log("new instance err. type=", clazz), e);
        }
        catch (IllegalArgumentException e) {
            throw new OgdlSyntaxException(Utils.log("new instance err. type=", clazz), e);
        }
        catch (InstantiationException e) {
            throw new OgdlSyntaxException(Utils.log("new instance err. type=", clazz), e);
        }
        catch (IllegalAccessException e) {
            throw new OgdlSyntaxException(Utils.log("new instance err. type=", clazz), e);
        }
    }

    static Object newInstance(Class clazz, Object[] paramValues) {
        try {
            if (paramValues.length == 0) {
                return BeanIntrospectHelper.getConstructor(clazz, EMPTY_ARG_TYPES).newInstance(paramValues);
            }
            Class[] paramTypes = BeanIntrospectHelper.toClassArray(paramValues);
            return BeanIntrospectHelper.getConstructor(clazz, paramTypes).newInstance(paramValues);
        }
        catch (SecurityException e) {
            throw new OgdlSyntaxException(Utils.log("new instance err. ", (Object)clazz, paramValues), e);
        }
        catch (IllegalArgumentException e) {
            throw new OgdlSyntaxException(Utils.log("new instance err. ", (Object)clazz, paramValues), e);
        }
        catch (InstantiationException e) {
            throw new OgdlSyntaxException(Utils.log("new instance err. ", (Object)clazz, paramValues), e);
        }
        catch (IllegalAccessException e) {
            throw new OgdlSyntaxException(Utils.log("new instance err. ", (Object)clazz, paramValues), e);
        }
        catch (InvocationTargetException e) {
            throw new OgdlSyntaxException(Utils.log("new instance err. ", (Object)clazz, paramValues), e);
        }
    }

    static Class[] toClassArray(Object[] os) {
        Class[] cs = new Class[os.length];
        for (int i = 0; i < os.length; ++i) {
            cs[i] = os[i].getClass();
        }
        return cs;
    }

    static boolean isAssignmentCompatible(Class[] ts, Class[] ts2) {
        return BeanIntrospectDescriptor.isAssignmentCompatible(ts, ts2);
    }

    private static BeanIntrospectDescriptor getBeanDescriptor(Class clazz) {
        return BeanIntrospectDescriptor.forClass(clazz);
    }
}

