/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import shohaku.ogdl.Boxing;
import shohaku.ogdl.Widening;

class ArithmeticHelper {
    ArithmeticHelper() {
    }

    static Object add(Object v1, Object v2) {
        if (ArithmeticHelper.isStringOperand(v1, v2)) {
            return ArithmeticHelper.concat(v1, v2);
        }
        return ArithmeticHelper.arithmetic(0, v1, v2);
    }

    static Object arithmetic(int type, Object v1, Object v2) {
        try {
            if (ArithmeticHelper.isNumberOperand(v1, v2)) {
                Number[] nums = ArithmeticHelper.toNumber(v1, v2);
                int arithmeticType = Widening.arithmetic(nums);
                switch (arithmeticType) {
                    case 0: {
                        return ArithmeticHelper.arithmeticBigDecimal(type, (BigDecimal)nums[0], (BigDecimal)nums[1]);
                    }
                    case 1: {
                        return ArithmeticHelper.arithmeticBigInteger(type, (BigInteger)nums[0], (BigInteger)nums[1]);
                    }
                    case 2: {
                        return Boxing.box(ArithmeticHelper.arithmeticDouble(type, nums[0], nums[1]));
                    }
                    case 3: {
                        return Boxing.box(ArithmeticHelper.arithmeticFloat(type, nums[0], nums[1]));
                    }
                    case 4: {
                        return Boxing.box(ArithmeticHelper.arithmeticLong(type, nums[0], nums[1]));
                    }
                    case 5: {
                        return Boxing.box(ArithmeticHelper.arithmeticInteger(type, nums[0], nums[1]));
                    }
                }
            }
        }
        catch (ClassCastException e) {
            throw ArithmeticHelper.buildArithmeticException("is not Number.", e);
        }
        catch (NumberFormatException e) {
            throw ArithmeticHelper.buildArithmeticException("number format error.", e);
        }
        throw new ArithmeticException("illegal operand type.");
    }

    static Object add(List args) {
        ArithmeticHelper.ifIllegalArgumentsSize(args);
        if (ArithmeticHelper.isStringOperand(args.get(0), args.get(1))) {
            return ArithmeticHelper.concat(args);
        }
        return ArithmeticHelper.arithmetic(0, args);
    }

    static Object arithmetic(int type, List args) {
        try {
            if (ArithmeticHelper.isNumberOperand(args)) {
                Number[] nums = new Number[2];
                Iterator i = args.iterator();
                nums[0] = ArithmeticHelper.toNumber(i.next());
                block11: while (i.hasNext()) {
                    nums[1] = ArithmeticHelper.toNumber(i.next());
                    int arithmeticType = Widening.arithmetic(nums);
                    switch (arithmeticType) {
                        case 0: {
                            nums[0] = ArithmeticHelper.arithmeticBigDecimal(type, (BigDecimal)nums[0], (BigDecimal)nums[1]);
                            continue block11;
                        }
                        case 1: {
                            nums[0] = ArithmeticHelper.arithmeticBigInteger(type, (BigInteger)nums[0], (BigInteger)nums[1]);
                            continue block11;
                        }
                        case 2: {
                            nums[0] = Boxing.box(ArithmeticHelper.arithmeticDouble(type, nums[0], nums[1]));
                            continue block11;
                        }
                        case 3: {
                            nums[0] = Boxing.box(ArithmeticHelper.arithmeticFloat(type, nums[0], nums[1]));
                            continue block11;
                        }
                        case 4: {
                            nums[0] = Boxing.box(ArithmeticHelper.arithmeticLong(type, nums[0], nums[1]));
                            continue block11;
                        }
                        case 5: {
                            nums[0] = Boxing.box(ArithmeticHelper.arithmeticInteger(type, nums[0], nums[1]));
                            continue block11;
                        }
                    }
                    throw new ArithmeticException("illegal operand type.");
                }
                return nums[0];
            }
        }
        catch (ClassCastException e) {
            throw ArithmeticHelper.buildArithmeticException("is not Number.", e);
        }
        catch (NumberFormatException e) {
            throw ArithmeticHelper.buildArithmeticException("number format error.", e);
        }
        throw new ArithmeticException("illegal operand type.");
    }

    private static Number arithmeticBigDecimal(int type, BigDecimal v1, BigDecimal v2) {
        switch (type) {
            case 0: {
                return v1.add(v2);
            }
            case 1: {
                return v1.subtract(v2);
            }
            case 2: {
                return v1.multiply(v2);
            }
            case 3: {
                return v1.divide(v2, 6);
            }
            case 4: {
                return v1.subtract(new BigDecimal(v1.divide(v2, 1).toBigInteger()).multiply(v2));
            }
        }
        throw new ArithmeticException("illegal operand type.");
    }

    private static Number arithmeticBigInteger(int type, BigInteger v1, BigInteger v2) {
        switch (type) {
            case 0: {
                return v1.add(v2);
            }
            case 1: {
                return v1.subtract(v2);
            }
            case 2: {
                return v1.multiply(v2);
            }
            case 3: {
                return v1.divide(v2);
            }
            case 4: {
                return v1.mod(v2);
            }
        }
        throw new ArithmeticException("illegal operand type.");
    }

    private static double arithmeticDouble(int type, Number v1, Number v2) {
        switch (type) {
            case 0: {
                return v1.doubleValue() + v2.doubleValue();
            }
            case 1: {
                return v1.doubleValue() - v2.doubleValue();
            }
            case 2: {
                return v1.doubleValue() * v2.doubleValue();
            }
            case 3: {
                return v1.doubleValue() / v2.doubleValue();
            }
            case 4: {
                return v1.doubleValue() % v2.doubleValue();
            }
        }
        throw new ArithmeticException("illegal operand type.");
    }

    private static float arithmeticFloat(int type, Number v1, Number v2) {
        switch (type) {
            case 0: {
                return v1.floatValue() + v2.floatValue();
            }
            case 1: {
                return v1.floatValue() - v2.floatValue();
            }
            case 2: {
                return v1.floatValue() * v2.floatValue();
            }
            case 3: {
                return v1.floatValue() / v2.floatValue();
            }
            case 4: {
                return v1.floatValue() % v2.floatValue();
            }
        }
        throw new ArithmeticException("illegal operand type.");
    }

    private static long arithmeticLong(int type, Number v1, Number v2) {
        switch (type) {
            case 0: {
                return v1.longValue() + v2.longValue();
            }
            case 1: {
                return v1.longValue() - v2.longValue();
            }
            case 2: {
                return v1.longValue() * v2.longValue();
            }
            case 3: {
                return v1.longValue() / v2.longValue();
            }
            case 4: {
                return v1.longValue() % v2.longValue();
            }
        }
        throw new ArithmeticException("illegal operand type.");
    }

    private static int arithmeticInteger(int type, Number v1, Number v2) {
        switch (type) {
            case 0: {
                return v1.intValue() + v2.intValue();
            }
            case 1: {
                return v1.intValue() - v2.intValue();
            }
            case 2: {
                return v1.intValue() * v2.intValue();
            }
            case 3: {
                return v1.intValue() / v2.intValue();
            }
            case 4: {
                return v1.intValue() % v2.intValue();
            }
        }
        throw new ArithmeticException("illegal operand type.");
    }

    static int compare(Object v1, Object v2) {
        if (ArithmeticHelper.isNumberOperand(v1, v2)) {
            try {
                Number[] nums = ArithmeticHelper.toNumber(v1, v2);
                int arithmeticType = Widening.arithmetic(nums);
                switch (arithmeticType) {
                    case 0: {
                        return ((BigDecimal)nums[0]).compareTo((BigDecimal)nums[1]);
                    }
                    case 1: {
                        return ((BigInteger)nums[0]).compareTo((BigInteger)nums[1]);
                    }
                    case 2: {
                        return ((Double)nums[0]).compareTo((Double)nums[1]);
                    }
                    case 3: {
                        return ((Float)nums[0]).compareTo((Float)nums[1]);
                    }
                    case 4: {
                        return ((Long)nums[0]).compareTo((Long)nums[1]);
                    }
                    case 5: {
                        return ((Integer)nums[0]).compareTo((Integer)nums[1]);
                    }
                }
            }
            catch (ClassCastException e) {
                throw ArithmeticHelper.buildArithmeticException("is not Number.", e);
            }
            catch (NumberFormatException e) {
                throw ArithmeticHelper.buildArithmeticException("number format error.", e);
            }
        } else if (ArithmeticHelper.isComparableOperand(v1, v2)) {
            return ((Comparable)v1).compareTo((Comparable)v2);
        }
        throw new ArithmeticException("illegal operand type.");
    }

    static Boolean compare(int type, List args) {
        ArithmeticHelper.ifIllegalArgumentsSize(args);
        Object v1 = args.get(0);
        Object v2 = args.get(1);
        if (ArithmeticHelper.isNumberOperand(v1, v2)) {
            return ArithmeticHelper.compareNumber(type, args);
        }
        if (ArithmeticHelper.isComparableOperand(v1, v2)) {
            return ArithmeticHelper.compareComparable(type, args);
        }
        throw new ArithmeticException("illegal operand type.");
    }

    private static Boolean compareComparable(int type, List args) {
        try {
            Iterator i = args.iterator();
            Comparable comp1 = (Comparable)i.next();
            Comparable comp2 = null;
            while (i.hasNext()) {
                comp2 = (Comparable)i.next();
                if (ArithmeticHelper.compare(type, comp1, comp2)) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (ClassCastException e) {
            throw ArithmeticHelper.buildArithmeticException("is not Comparable.", e);
        }
    }

    private static Boolean compareNumber(int type, List args) {
        try {
            Number[] nums = new Number[2];
            Iterator i = args.iterator();
            nums[0] = ArithmeticHelper.toNumber(i.next());
            if (i.hasNext()) {
                nums[1] = ArithmeticHelper.toNumber(i.next());
                Widening.arithmetic(nums);
                if (!ArithmeticHelper.compare(type, (Comparable)((Object)nums[0]), (Comparable)((Object)nums[1]))) {
                    return Boolean.FALSE;
                }
            }
            return Boolean.TRUE;
        }
        catch (ClassCastException e) {
            throw ArithmeticHelper.buildArithmeticException("is not Number.", e);
        }
        catch (NumberFormatException e) {
            throw ArithmeticHelper.buildArithmeticException("is infinite or NaN.", e);
        }
    }

    private static boolean compare(int type, Comparable comp1, Comparable comp2) {
        switch (type) {
            case 32: {
                return comp1.compareTo(comp2) == 0;
            }
            case 34: {
                return comp1.compareTo(comp2) < 0;
            }
            case 35: {
                return comp1.compareTo(comp2) <= 0;
            }
            case 36: {
                return comp1.compareTo(comp2) > 0;
            }
            case 37: {
                return comp1.compareTo(comp2) >= 0;
            }
        }
        throw new ArithmeticException("illegal operand type.");
    }

    static Object bitwise(int type, Object v1, Object v2) {
        if (ArithmeticHelper.isNumberOperand(v1, v2)) {
            try {
                Number[] nums = ArithmeticHelper.toNumber(v1, v2);
                int arithmeticType = Widening.arithmetic(nums);
                switch (arithmeticType) {
                    case 1: {
                        switch (type) {
                            case 5: {
                                return ((BigInteger)nums[0]).and((BigInteger)nums[1]);
                            }
                            case 6: {
                                return ((BigInteger)nums[0]).xor((BigInteger)nums[1]);
                            }
                            case 7: {
                                return ((BigInteger)nums[0]).or((BigInteger)nums[1]);
                            }
                        }
                        break;
                    }
                    case 4: {
                        switch (type) {
                            case 5: {
                                return Boxing.box(nums[0].longValue() & nums[1].longValue());
                            }
                            case 6: {
                                return Boxing.box(nums[0].longValue() ^ nums[1].longValue());
                            }
                            case 7: {
                                return Boxing.box(nums[0].longValue() | nums[1].longValue());
                            }
                        }
                        break;
                    }
                    case 5: {
                        switch (type) {
                            case 5: {
                                return Boxing.box(nums[0].intValue() & nums[1].intValue());
                            }
                            case 6: {
                                return Boxing.box(nums[0].intValue() ^ nums[1].intValue());
                            }
                            case 7: {
                                return Boxing.box(nums[0].intValue() | nums[1].intValue());
                            }
                        }
                        break;
                    }
                    default: {
                        throw new ArithmeticException("illegal operand type.");
                    }
                }
            }
            catch (ClassCastException e) {
                throw ArithmeticHelper.buildArithmeticException("is not Number.", e);
            }
            catch (NumberFormatException e) {
                throw ArithmeticHelper.buildArithmeticException("number format error.", e);
            }
        }
        if (ArithmeticHelper.isBooleanOperand(v1, v2)) {
            Boolean bool1 = (Boolean)v1;
            Boolean bool2 = (Boolean)v2;
            switch (type) {
                case 5: {
                    return Boxing.box(bool1 & bool2);
                }
                case 6: {
                    return Boxing.box(bool1 ^ bool2);
                }
                case 7: {
                    return Boxing.box(bool1 | bool2);
                }
            }
            throw new ArithmeticException("illegal operand type.");
        }
        throw new ArithmeticException("illegal operand type.");
    }

    static Object bitwise(int type, List args) {
        ArithmeticHelper.ifIllegalArgumentsSize(args);
        Object v1 = args.get(0);
        Object v2 = args.get(1);
        if (ArithmeticHelper.isNumberOperand(v1, v2)) {
            return ArithmeticHelper.bitwiseNumber(type, args);
        }
        if (ArithmeticHelper.isBooleanOperand(v1, v2)) {
            return ArithmeticHelper.bitwiseBoolean(type, args);
        }
        throw new ArithmeticException("illegal operand type.");
    }

    private static Object bitwiseBoolean(int type, List args) {
        try {
            Iterator i = args.iterator();
            Boolean bool1 = (Boolean)i.next();
            Boolean bool2 = null;
            block7: while (i.hasNext()) {
                bool2 = (Boolean)i.next();
                switch (type) {
                    case 5: {
                        bool1 = Boxing.box(bool1 & bool2);
                        continue block7;
                    }
                    case 6: {
                        bool1 = Boxing.box(bool1 ^ bool2);
                        continue block7;
                    }
                    case 7: {
                        bool1 = Boxing.box(bool1 | bool2);
                        continue block7;
                    }
                }
                throw new ArithmeticException("illegal operand type.");
            }
            return bool1;
        }
        catch (ClassCastException e) {
            throw ArithmeticHelper.buildArithmeticException("is not Boolean.", e);
        }
    }

    private static Object bitwiseNumber(int type, List args) {
        try {
            Number[] nums = new Number[2];
            Iterator i = args.iterator();
            nums[0] = ArithmeticHelper.toNumber(i.next());
            block23: while (i.hasNext()) {
                nums[1] = ArithmeticHelper.toNumber(i.next());
                int arithmeticType = Widening.arithmetic(nums);
                switch (arithmeticType) {
                    case 1: {
                        switch (type) {
                            case 5: {
                                nums[0] = ((BigInteger)nums[0]).and((BigInteger)nums[1]);
                                continue block23;
                            }
                            case 6: {
                                nums[0] = ((BigInteger)nums[0]).xor((BigInteger)nums[1]);
                                continue block23;
                            }
                            case 7: {
                                nums[0] = ((BigInteger)nums[0]).or((BigInteger)nums[1]);
                                continue block23;
                            }
                        }
                        continue block23;
                    }
                    case 4: {
                        switch (type) {
                            case 5: {
                                nums[0] = Boxing.box(nums[0].longValue() & nums[1].longValue());
                                continue block23;
                            }
                            case 6: {
                                nums[0] = Boxing.box(nums[0].longValue() ^ nums[1].longValue());
                                continue block23;
                            }
                            case 7: {
                                nums[0] = Boxing.box(nums[0].longValue() | nums[1].longValue());
                                continue block23;
                            }
                        }
                        continue block23;
                    }
                    case 5: {
                        switch (type) {
                            case 5: {
                                nums[0] = Boxing.box(nums[0].intValue() & nums[1].intValue());
                                continue block23;
                            }
                            case 6: {
                                nums[0] = Boxing.box(nums[0].intValue() ^ nums[1].intValue());
                                continue block23;
                            }
                            case 7: {
                                nums[0] = Boxing.box(nums[0].intValue() | nums[1].intValue());
                                continue block23;
                            }
                        }
                        continue block23;
                    }
                }
                throw new ArithmeticException("illegal operand type.");
            }
            return nums[0];
        }
        catch (ClassCastException e) {
            throw ArithmeticHelper.buildArithmeticException("is not Number.", e);
        }
        catch (NumberFormatException e) {
            throw ArithmeticHelper.buildArithmeticException("number format error.", e);
        }
    }

    static Object shift(int type, Object v, Object n) {
        try {
            Number val = ArithmeticHelper.toNumber(v);
            Number shift = ArithmeticHelper.toNumber(n);
            if (!ArithmeticHelper.isShiftOperand(val, shift)) {
                throw new ArithmeticException("illegal operand type.");
            }
            if (val instanceof BigInteger && ArithmeticHelper.isIntegerOperand(shift)) {
                switch (type) {
                    case 16: {
                        return ((BigInteger)val).shiftLeft(shift.intValue());
                    }
                    case 17: {
                        return ((BigInteger)val).shiftRight(shift.intValue());
                    }
                    case 18: {
                        throw new ArithmeticException("illegal operand type.");
                    }
                }
            } else if (val instanceof Long && shift instanceof Long) {
                switch (type) {
                    case 16: {
                        return Boxing.box(val.longValue() << (int)shift.longValue());
                    }
                    case 17: {
                        return Boxing.box(val.longValue() >> (int)shift.longValue());
                    }
                    case 18: {
                        return Boxing.box(val.longValue() >>> (int)shift.longValue());
                    }
                }
            } else if (ArithmeticHelper.isIntegerOperand(val) && shift instanceof Long) {
                switch (type) {
                    case 16: {
                        return Boxing.box(val.intValue() << (int)shift.longValue());
                    }
                    case 17: {
                        return Boxing.box(val.intValue() >> (int)shift.longValue());
                    }
                    case 18: {
                        return Boxing.box(val.intValue() >>> (int)shift.longValue());
                    }
                }
            } else if (val instanceof Long && ArithmeticHelper.isIntegerOperand(shift)) {
                switch (type) {
                    case 16: {
                        return Boxing.box(val.longValue() << shift.intValue());
                    }
                    case 17: {
                        return Boxing.box(val.longValue() >> shift.intValue());
                    }
                    case 18: {
                        return Boxing.box(val.longValue() >>> shift.intValue());
                    }
                }
            } else if (ArithmeticHelper.isIntegerOperand(val, shift)) {
                switch (type) {
                    case 16: {
                        return Boxing.box(val.intValue() << shift.intValue());
                    }
                    case 17: {
                        return Boxing.box(val.intValue() >> shift.intValue());
                    }
                    case 18: {
                        return Boxing.box(val.intValue() >>> shift.intValue());
                    }
                }
            }
        }
        catch (ClassCastException e) {
            throw ArithmeticHelper.buildArithmeticException("is not Number.", e);
        }
        catch (NumberFormatException e) {
            throw ArithmeticHelper.buildArithmeticException("number format error.", e);
        }
        throw new ArithmeticException("illegal operand type.");
    }

    static Object shift(int type, List args) {
        if (ArithmeticHelper.isNumberOperand(args)) {
            return ArithmeticHelper.shiftNumber(type, args);
        }
        throw new ArithmeticException("illegal operand type.");
    }

    private static Object shiftNumber(int type, List args) {
        try {
            Iterator i = args.iterator();
            Number val = ArithmeticHelper.toNumber(i.next());
            Number shift = null;
            if (i.hasNext()) {
                shift = ArithmeticHelper.toNumber(i.next());
                if (!ArithmeticHelper.isShiftOperand(val, shift)) {
                    throw new ArithmeticException("illegal operand type.");
                }
                if (val instanceof BigInteger && ArithmeticHelper.isIntegerOperand(shift)) {
                    switch (type) {
                        case 16: {
                            val = ((BigInteger)val).shiftLeft(shift.intValue());
                            break;
                        }
                        case 17: {
                            val = ((BigInteger)val).shiftRight(shift.intValue());
                            break;
                        }
                        case 18: {
                            throw new ArithmeticException("illegal operand type.");
                        }
                    }
                } else if (val instanceof Long && shift instanceof Long) {
                    switch (type) {
                        case 16: {
                            val = Boxing.box(val.longValue() << (int)shift.longValue());
                            break;
                        }
                        case 17: {
                            val = Boxing.box(val.longValue() >> (int)shift.longValue());
                            break;
                        }
                        case 18: {
                            val = Boxing.box(val.longValue() >>> (int)shift.longValue());
                            break;
                        }
                    }
                } else if (ArithmeticHelper.isIntegerOperand(val) && shift instanceof Long) {
                    switch (type) {
                        case 16: {
                            val = Boxing.box(val.intValue() << (int)shift.longValue());
                            break;
                        }
                        case 17: {
                            val = Boxing.box(val.intValue() >> (int)shift.longValue());
                            break;
                        }
                        case 18: {
                            val = Boxing.box(val.intValue() >>> (int)shift.longValue());
                            break;
                        }
                    }
                } else if (val instanceof Long && ArithmeticHelper.isIntegerOperand(shift)) {
                    switch (type) {
                        case 16: {
                            val = Boxing.box(val.longValue() << shift.intValue());
                            break;
                        }
                        case 17: {
                            val = Boxing.box(val.longValue() >> shift.intValue());
                            break;
                        }
                        case 18: {
                            val = Boxing.box(val.longValue() >>> shift.intValue());
                            break;
                        }
                    }
                } else if (ArithmeticHelper.isIntegerOperand(val, shift)) {
                    switch (type) {
                        case 16: {
                            val = Boxing.box(val.intValue() << shift.intValue());
                            break;
                        }
                        case 17: {
                            val = Boxing.box(val.intValue() >> shift.intValue());
                            break;
                        }
                        case 18: {
                            val = Boxing.box(val.intValue() >>> shift.intValue());
                            break;
                        }
                    }
                } else {
                    throw new ArithmeticException("illegal operand type.");
                }
            }
            return val;
        }
        catch (ClassCastException e) {
            throw ArithmeticHelper.buildArithmeticException("is not Number.", e);
        }
        catch (NumberFormatException e) {
            throw ArithmeticHelper.buildArithmeticException("number format error.", e);
        }
    }

    static Boolean instanceOf(List args) {
        try {
            Iterator i = args.iterator();
            Object e = i.next();
            while (i.hasNext()) {
                if (((Class)i.next()).isInstance(e)) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (ClassCastException e) {
            throw ArithmeticHelper.buildArithmeticException("is not java.lang.Class.", e);
        }
    }

    static Boolean eqs(Object v1, Object v2) {
        return Boxing.box(ArithmeticHelper.isEquals(v1, v2));
    }

    static Boolean eqs(List args) {
        Iterator i = args.iterator();
        Object e = i.next();
        while (i.hasNext()) {
            if (ArithmeticHelper.isEquals(e, i.next())) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    static Boolean req(List args) {
        Iterator i = args.iterator();
        Object e = i.next();
        while (i.hasNext()) {
            if (e == i.next()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    static String concat(Object v1, Object v2) {
        StringBuffer sb = new StringBuffer();
        return sb.append(v1).append(v2).toString();
    }

    static String concat(List args) {
        StringBuffer sb = new StringBuffer();
        Iterator i = args.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
        }
        return sb.toString();
    }

    static String concatNvl(Object v1, Object v2) {
        StringBuffer sb = new StringBuffer();
        if (v1 != null) {
            sb.append(v1);
        }
        if (v2 != null) {
            sb.append(v2);
        }
        return sb.toString();
    }

    static String concatNvl(List args) {
        StringBuffer sb = new StringBuffer();
        Iterator i = args.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o == null) continue;
            sb.append(o);
        }
        return sb.toString();
    }

    static void ifIllegalArgumentsSize(List args) {
        if (2 > args.size()) {
            throw new ArithmeticException("illegal arguments size. 2 > size.");
        }
    }

    private static boolean isEquals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    private static Number[] toNumber(Object v1, Object v2) {
        return new Number[]{ArithmeticHelper.toNumber(v1), ArithmeticHelper.toNumber(v2)};
    }

    private static Number toNumber(Object o) {
        return o instanceof Character ? (Number)Boxing.box((int)((Character)o).charValue()) : (Number)((Number)o);
    }

    private static boolean isStringOperand(Object v1, Object v2) {
        return v1 instanceof String || v2 instanceof String;
    }

    private static boolean isBooleanOperand(Object v1, Object v2) {
        return v1 instanceof Boolean && v2 instanceof Boolean;
    }

    private static boolean isComparableOperand(Object v1, Object v2) {
        return v1 instanceof Comparable && v2 instanceof Comparable;
    }

    private static boolean isNumberOperand(Object v1, Object v2) {
        return ArithmeticHelper.isNumberOperand(v1) && ArithmeticHelper.isNumberOperand(v2);
    }

    private static boolean isNumberOperand(Object v) {
        return v instanceof Number || v instanceof Character;
    }

    private static boolean isShiftOperand(Object v1, Object v2) {
        return ArithmeticHelper.isShiftOperand(v1) && ArithmeticHelper.isShiftOperand(v2);
    }

    private static boolean isShiftOperand(Object v) {
        return !(v instanceof BigDecimal) && !(v instanceof Double) && !(v instanceof Float);
    }

    private static boolean isIntegerOperand(Object v1, Object v2) {
        return ArithmeticHelper.isIntegerOperand(v1) && ArithmeticHelper.isIntegerOperand(v2);
    }

    private static boolean isIntegerOperand(Object v) {
        return v instanceof Integer || v instanceof Short || v instanceof Byte;
    }

    private static boolean isNumberOperand(List args) {
        ArithmeticHelper.ifIllegalArgumentsSize(args);
        return ArithmeticHelper.isNumberOperand(args.get(0), args.get(1));
    }

    private static ArithmeticException buildArithmeticException(String msg, Exception cause) {
        ArithmeticException e = new ArithmeticException(msg);
        e.initCause(cause);
        return e;
    }
}

