/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import shohaku.ogdl.ArithmeticHelper;
import shohaku.ogdl.Boxing;

final class Arithmetic {
    public static final int ARITHMETIC_ADDITION = 0;
    public static final int ARITHMETIC_SUBTRACTION = 1;
    public static final int ARITHMETIC_MULTIPLICATION = 2;
    public static final int ARITHMETIC_DIVISION = 3;
    public static final int ARITHMETIC_REMAINDER = 4;
    public static final int BITWISE_AND = 5;
    public static final int BITWISE_XOR = 6;
    public static final int BITWISE_OR = 7;
    public static final int BIT_SHIFT_LEFT = 16;
    public static final int BIT_SHIFT_RIGHT = 17;
    public static final int BIT_SHIFT_LOGICAL_RIGHT = 18;
    public static final int COMPARATIVE_EQUALITY = 32;
    public static final int COMPARATIVE_INEQUALITY = 33;
    public static final int COMPARATIVE_LESS_THAN = 34;
    public static final int COMPARATIVE_GREATER_THAN = 35;
    public static final int COMPARATIVE_LESS_EQUALITY = 36;
    public static final int COMPARATIVE_GREATER_EQUALITY = 37;
    public static final int INSTANCE_OF = 48;
    public static final int STRING_BUILDING = 49;
    public static final int OBJECT_EQUALITY = 50;
    public static final int OBJECT_INEQUALITY = 51;
    public static final int REFERENCE_EQUALITY = 52;
    public static final int REFERENCE_INEQUALITY = 53;

    Arithmetic() {
    }

    public static Integer minus(Character v) {
        return Boxing.box((int)(-v.charValue()));
    }

    public static Integer minus(Byte v) {
        return Boxing.box((int)(-v.byteValue()));
    }

    public static Integer minus(Short v) {
        return Boxing.box((int)(-v.shortValue()));
    }

    public static Integer minus(Integer v) {
        return Boxing.box(-v.intValue());
    }

    public static Long minus(Long v) {
        return Boxing.box(-v.longValue());
    }

    public static Float minus(Float v) {
        return Boxing.box(-v.floatValue());
    }

    public static Double minus(Double v) {
        return Boxing.box(-v.doubleValue());
    }

    public static BigInteger minus(BigInteger v) {
        return v.negate();
    }

    public static BigDecimal minus(BigDecimal v) {
        return v.negate();
    }

    public static Integer not(Character v) {
        return Boxing.box((int)(~v.charValue()));
    }

    public static Integer not(Byte v) {
        return Boxing.box((int)(~v.byteValue()));
    }

    public static Integer not(Short v) {
        return Boxing.box((int)(~v.shortValue()));
    }

    public static Integer not(Integer v) {
        return Boxing.box(~v.intValue());
    }

    public static Long not(Long v) {
        return Boxing.box(v ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static BigInteger not(BigInteger v) {
        return v.not();
    }

    public static Boolean not(Boolean v) {
        return Boxing.box(v == false);
    }

    public static Object plus(Object v) {
        if (v instanceof Number) {
            return v;
        }
        throw new ArithmeticException("is not Number. " + v);
    }

    public static Object minus(Object v) {
        if (v instanceof Byte) {
            return Arithmetic.minus((Byte)v);
        }
        if (v instanceof Short) {
            return Arithmetic.minus((Short)v);
        }
        if (v instanceof Integer) {
            return Arithmetic.minus((Integer)v);
        }
        if (v instanceof Long) {
            return Arithmetic.minus((Long)v);
        }
        if (v instanceof Float) {
            return Arithmetic.minus((Float)v);
        }
        if (v instanceof Double) {
            return Arithmetic.minus((Double)v);
        }
        if (v instanceof BigInteger) {
            return Arithmetic.minus((BigInteger)v);
        }
        if (v instanceof BigDecimal) {
            return Arithmetic.minus((BigDecimal)v);
        }
        throw new ArithmeticException("is not Number. " + v);
    }

    public static Object bitwiseNot(Object v) {
        if (v instanceof Byte) {
            return Arithmetic.not((Byte)v);
        }
        if (v instanceof Short) {
            return Arithmetic.not((Short)v);
        }
        if (v instanceof Integer) {
            return Arithmetic.not((Integer)v);
        }
        if (v instanceof Long) {
            return Arithmetic.not((Long)v);
        }
        if (v instanceof BigInteger) {
            return Arithmetic.not((BigInteger)v);
        }
        if (v instanceof Number) {
            throw new ArithmeticException("is not integer. " + v);
        }
        throw new ArithmeticException("is not Number. " + v);
    }

    public static Object logicalNot(Object v) {
        if (v instanceof Boolean) {
            return Arithmetic.not((Boolean)v);
        }
        throw new ArithmeticException("is not Boolean. " + v);
    }

    public static Object add(Object v1, Object v2) {
        return ArithmeticHelper.add(v1, v2);
    }

    public static Object subtract(Object v1, Object v2) {
        return ArithmeticHelper.arithmetic(1, v1, v2);
    }

    public static Object multiply(Object v1, Object v2) {
        return ArithmeticHelper.arithmetic(2, v1, v2);
    }

    public static Object divide(Object v1, Object v2) {
        return ArithmeticHelper.arithmetic(3, v1, v2);
    }

    public static Object mod(Object v, Object modulus) {
        return ArithmeticHelper.arithmetic(4, v, modulus);
    }

    public static Object shl(Object v, Object n) {
        return ArithmeticHelper.shift(16, v, n);
    }

    public static Object shr(Object v, Object n) {
        return ArithmeticHelper.shift(17, v, n);
    }

    public static Object ushr(Object v, Object n) {
        return ArithmeticHelper.shift(18, v, n);
    }

    public static Object and(Object v1, Object v2) {
        return ArithmeticHelper.bitwise(5, v1, v2);
    }

    public static Object or(Object v1, Object v2) {
        return ArithmeticHelper.bitwise(7, v1, v2);
    }

    public static Object xor(Object v1, Object v2) {
        return ArithmeticHelper.bitwise(6, v1, v2);
    }

    public static Boolean eq(Object v1, Object v2) {
        return Boxing.box(ArithmeticHelper.compare(v1, v2) == 0);
    }

    public static Boolean ne(Object v1, Object v2) {
        return Boxing.box(ArithmeticHelper.compare(v1, v2) != 0);
    }

    public static Boolean lt(Object v1, Object v2) {
        return Boxing.box(ArithmeticHelper.compare(v1, v2) < 0);
    }

    public static Boolean gt(Object v1, Object v2) {
        return Boxing.box(ArithmeticHelper.compare(v1, v2) > 0);
    }

    public static Boolean le(Object v1, Object v2) {
        return Boxing.box(ArithmeticHelper.compare(v1, v2) <= 0);
    }

    public static Boolean ge(Object v1, Object v2) {
        return Boxing.box(ArithmeticHelper.compare(v1, v2) >= 0);
    }

    public static Boolean instanceOf(Object v, Object clazz) {
        return Boxing.box(((Class)clazz).isInstance(v));
    }

    public static String stringOf(Object v1, Object v2) {
        return ArithmeticHelper.concatNvl(v1, v2);
    }

    public static Boolean eqs(Object v1, Object v2) {
        return ArithmeticHelper.eqs(v1, v2);
    }

    public static Boolean nes(Object v1, Object v2) {
        return Arithmetic.not(Arithmetic.eqs(v1, v2));
    }

    public static Boolean req(Object v1, Object v2) {
        return Boxing.box(v1 == v2);
    }

    public static Boolean rne(Object v1, Object v2) {
        return Arithmetic.not(Arithmetic.req(v1, v2));
    }

    public static Object evaluate(int type, Object v1, Object v2) {
        switch (type) {
            case 0: {
                return Arithmetic.add(v1, v2);
            }
            case 1: {
                return Arithmetic.subtract(v1, v2);
            }
            case 2: {
                return Arithmetic.multiply(v1, v2);
            }
            case 3: {
                return Arithmetic.divide(v1, v2);
            }
            case 4: {
                return Arithmetic.mod(v1, v2);
            }
            case 5: {
                return Arithmetic.and(v1, v2);
            }
            case 6: {
                return Arithmetic.xor(v1, v2);
            }
            case 7: {
                return Arithmetic.or(v1, v2);
            }
            case 16: {
                return Arithmetic.shl(v1, v2);
            }
            case 17: {
                return Arithmetic.shr(v1, v2);
            }
            case 18: {
                return Arithmetic.ushr(v1, v2);
            }
            case 32: {
                return Arithmetic.eq(v1, v2);
            }
            case 33: {
                return Arithmetic.ne(v1, v2);
            }
            case 34: {
                return Arithmetic.lt(v1, v2);
            }
            case 35: {
                return Arithmetic.gt(v1, v2);
            }
            case 36: {
                return Arithmetic.le(v1, v2);
            }
            case 37: {
                return Arithmetic.ge(v1, v2);
            }
            case 48: {
                return Arithmetic.instanceOf(v1, v2);
            }
            case 49: {
                return Arithmetic.stringOf(v1, v2);
            }
            case 50: {
                return Arithmetic.eqs(v1, v2);
            }
            case 51: {
                return Arithmetic.nes(v1, v2);
            }
            case 52: {
                return Arithmetic.req(v1, v2);
            }
            case 53: {
                return Arithmetic.rne(v1, v2);
            }
        }
        throw new ArithmeticException("illegal operand type.");
    }

    public static Object add(List args) {
        return ArithmeticHelper.add(args);
    }

    public static Object subtract(List args) {
        return ArithmeticHelper.arithmetic(1, args);
    }

    public static Object multiply(List args) {
        return ArithmeticHelper.arithmetic(2, args);
    }

    public static Object divide(List args) {
        return ArithmeticHelper.arithmetic(3, args);
    }

    public static Object mod(List args) {
        return ArithmeticHelper.arithmetic(4, args);
    }

    public static Object shl(List args) {
        return ArithmeticHelper.shift(16, args);
    }

    public static Object shr(List args) {
        return ArithmeticHelper.shift(17, args);
    }

    public static Object ushr(List args) {
        return ArithmeticHelper.shift(18, args);
    }

    public static Object and(List args) {
        return ArithmeticHelper.bitwise(5, args);
    }

    public static Object or(List args) {
        return ArithmeticHelper.bitwise(7, args);
    }

    public static Object xor(List args) {
        return ArithmeticHelper.bitwise(6, args);
    }

    public static Boolean eq(List args) {
        return ArithmeticHelper.compare(32, args);
    }

    public static Boolean ne(List args) {
        return Arithmetic.not(Arithmetic.eq(args));
    }

    public static Boolean lt(List args) {
        return ArithmeticHelper.compare(34, args);
    }

    public static Boolean gt(List args) {
        return ArithmeticHelper.compare(35, args);
    }

    public static Boolean le(List args) {
        return ArithmeticHelper.compare(36, args);
    }

    public static Boolean ge(List args) {
        return ArithmeticHelper.compare(37, args);
    }

    public static Boolean instanceOf(List args) {
        return ArithmeticHelper.instanceOf(args);
    }

    public static String stringOf(List args) {
        return ArithmeticHelper.concatNvl(args);
    }

    public static Boolean eqs(List args) {
        return ArithmeticHelper.eqs(args);
    }

    public static Boolean nes(List args) {
        return Arithmetic.not(Arithmetic.eqs(args));
    }

    public static Boolean req(List args) {
        return ArithmeticHelper.req(args);
    }

    public static Boolean rne(List args) {
        return Arithmetic.not(Arithmetic.req(args));
    }

    public static Object evaluate(int type, List args) {
        ArithmeticHelper.ifIllegalArgumentsSize(args);
        switch (type) {
            case 0: {
                return Arithmetic.add(args);
            }
            case 1: {
                return Arithmetic.subtract(args);
            }
            case 2: {
                return Arithmetic.multiply(args);
            }
            case 3: {
                return Arithmetic.divide(args);
            }
            case 4: {
                return Arithmetic.mod(args);
            }
            case 5: {
                return Arithmetic.and(args);
            }
            case 6: {
                return Arithmetic.xor(args);
            }
            case 7: {
                return Arithmetic.or(args);
            }
            case 16: {
                return Arithmetic.shl(args);
            }
            case 17: {
                return Arithmetic.shr(args);
            }
            case 18: {
                return Arithmetic.ushr(args);
            }
            case 32: {
                return Arithmetic.eq(args);
            }
            case 33: {
                return Arithmetic.ne(args);
            }
            case 34: {
                return Arithmetic.lt(args);
            }
            case 35: {
                return Arithmetic.gt(args);
            }
            case 36: {
                return Arithmetic.le(args);
            }
            case 37: {
                return Arithmetic.ge(args);
            }
            case 48: {
                return Arithmetic.instanceOf(args);
            }
            case 49: {
                return Arithmetic.stringOf(args);
            }
            case 50: {
                return Arithmetic.eqs(args);
            }
            case 51: {
                return Arithmetic.nes(args);
            }
            case 52: {
                return Arithmetic.req(args);
            }
            case 53: {
                return Arithmetic.rne(args);
            }
        }
        throw new ArithmeticException("illegal operand type.");
    }
}

