/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import shohaku.core.collections.IteratorUtils;
import shohaku.core.helpers.HCoder;
import shohaku.core.lang.Concat;
import shohaku.core.lang.Eval;
import shohaku.core.lang.Predicate;

public class XProperties
implements Serializable {
    private static final long serialVersionUID = 5888396005126085399L;
    protected static final Charset DEFAULT_CHARSET = Charset.forName("8859_1");
    protected static final char[] keyValueSeparators = "=: \t\r\n\f".toCharArray();
    protected static final char[] strictKeyValueSeparators = "=:".toCharArray();
    protected static final char[] commentChars = "#!".toCharArray();
    protected static final String commentPrefix = "#";
    protected static final char[] whiteSpaceChars = " \t\r\n\f".toCharArray();
    protected static final char continueLineChar = '\\';
    protected static final char escapeChar = '\\';
    protected final Map lookup;
    protected XProperties defaults;

    public XProperties() {
        this(null, new LinkedHashMap());
    }

    public XProperties(XProperties defaults) {
        this(defaults, new LinkedHashMap());
    }

    protected XProperties(XProperties defaults, Map lookup) {
        this.defaults = defaults;
        this.lookup = lookup;
    }

    public void load(InputStream inStream) throws IOException {
        this.loadImpl(inStream, DEFAULT_CHARSET, true);
    }

    public void load(InputStream inStream, Charset charset) throws IOException {
        this.loadImpl(inStream, charset, false);
    }

    public void store(OutputStream outStream, String header) throws IOException {
        this.storeImpl(outStream, header, DEFAULT_CHARSET, true);
    }

    public void store(OutputStream outStream, Charset charset, String header) throws IOException {
        this.storeImpl(outStream, header, charset, false);
    }

    public Iterator getKeys() {
        if (this.defaults != null) {
            Iterator[] is = new Iterator[]{this.lookup.keySet().iterator(), IteratorUtils.predicateIterator(this.defaults.getKeys(), new Predicate(){

                public boolean evaluate(Object o) {
                    return !XProperties.this.lookup.containsKey(o);
                }
            })};
            return IteratorUtils.compositeIterator(is);
        }
        return this.lookup.keySet().iterator();
    }

    public Map toMap() {
        return this.toMap(new LinkedHashMap());
    }

    public Map toMap(Map map) {
        if (this.defaults != null) {
            this.defaults.toMap(map);
        }
        map.putAll(this.lookup);
        return map;
    }

    public Object getProperty(Object key) {
        if (this.lookup.containsKey(key)) {
            return this.lookup.get(key);
        }
        return this.defaults != null ? this.defaults.getProperty(key) : null;
    }

    public Object getProperty(Object key, Object defaultValue) {
        Object o = this.getProperty(key);
        return o != null ? o : defaultValue;
    }

    public Object setProperty(Object key, Object value) {
        return this.lookup.put(key, value);
    }

    public boolean containsKey(Object key) {
        return this.lookup.containsKey(key) || this.defaults != null && this.defaults.containsKey(key);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        Iterator i = this.lookup.entrySet().iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Map.Entry e = i.next();
            Object key = e.getKey();
            Object value = e.getValue();
            buf.append(key);
            buf.append('=');
            buf.append(value);
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    protected synchronized void loadImpl(InputStream inStream, Charset charset, boolean isEscapes) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream, charset));
        String line;
        while ((line = in.readLine()) != null) {
            int valueIndex;
            int separatorIndex;
            char firstChar;
            int keyStart;
            if (line.length() <= 0) continue;
            int len = line.length();
            for (keyStart = 0; keyStart < len && this.isWhiteSpaceChars(line.charAt(keyStart)); ++keyStart) {
            }
            if (keyStart == len || !this.isNotCommentChars(firstChar = line.charAt(keyStart))) continue;
            while (this.continueLine(line)) {
                int startIndex;
                String nextLine = in.readLine();
                if (nextLine == null) {
                    nextLine = "";
                }
                String loppedLine = line.substring(0, len - 1);
                for (startIndex = 0; startIndex < nextLine.length() && this.isWhiteSpaceChars(nextLine.charAt(startIndex)); ++startIndex) {
                }
                nextLine = nextLine.substring(startIndex, nextLine.length());
                line = Concat.get(loppedLine, nextLine);
                len = line.length();
            }
            for (separatorIndex = keyStart; separatorIndex < len; ++separatorIndex) {
                char currentChar = line.charAt(separatorIndex);
                if (this.isEscapeChar(currentChar)) {
                    ++separatorIndex;
                    continue;
                }
                if (this.isKeyValueSeparators(currentChar)) break;
            }
            for (valueIndex = separatorIndex; valueIndex < len && this.isWhiteSpaceChars(line.charAt(valueIndex)); ++valueIndex) {
            }
            if (valueIndex < len && this.isKeyValueSeparators(line.charAt(valueIndex))) {
                ++valueIndex;
            }
            while (valueIndex < len && this.isWhiteSpaceChars(line.charAt(valueIndex))) {
                ++valueIndex;
            }
            String key = line.substring(keyStart, separatorIndex);
            String value = separatorIndex < len ? line.substring(valueIndex, len) : "";
            this.putProperty(key, value, isEscapes);
        }
        return;
    }

    protected synchronized void storeImpl(OutputStream outStream, String header, Charset charset, boolean isEscapes) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(outStream, charset));
        if (header != null) {
            writer.print(this.getCommentPrefix());
            writer.println(header);
        }
        writer.print(this.getCommentPrefix());
        writer.println(Calendar.getInstance().getTime());
        Iterator i = this.lookup.entrySet().iterator();
        StringBuffer buf = new StringBuffer();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Object key = e.getKey();
            Object value = e.getValue();
            this.storeProperty(buf, key, value, isEscapes);
            writer.println(buf);
            buf.setLength(0);
        }
        writer.flush();
    }

    protected void putProperty(String key, String value, boolean isEscapes) throws IOException {
        String k = key;
        String v = value;
        if (isEscapes) {
            k = HCoder.decodePropertiesEscapes(k);
            v = HCoder.decodePropertiesEscapes(v);
        } else {
            k = this.deleteEscapeChar(k);
        }
        this.lookup.put(k, v);
    }

    protected void storeProperty(StringBuffer buf, Object key, Object value, boolean isEscapes) throws IOException {
        Object k = key;
        Object v = value;
        if (isEscapes) {
            k = HCoder.encodePropertiesEscapes(String.valueOf(k));
            v = HCoder.encodePropertiesEscapes(String.valueOf(v));
        } else {
            k = this.appendEscapeChar(k);
        }
        buf.append(k);
        buf.append('=');
        buf.append(v);
    }

    protected boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    protected String getCommentPrefix() {
        return commentPrefix;
    }

    protected boolean isNotCommentChars(char c) {
        return !Eval.isContains(commentChars, c);
    }

    protected boolean isKeyValueSeparators(char c) {
        return Eval.isContains(keyValueSeparators, c);
    }

    protected boolean isWhiteSpaceChars(char c) {
        return Eval.isContains(whiteSpaceChars, c);
    }

    protected boolean isEscapeChar(char c) {
        return c == '\\';
    }

    protected String appendEscapeChar(Object o) {
        return String.valueOf(o).replaceAll("([=:\\])", "\\$1");
    }

    protected String deleteEscapeChar(String s) {
        return s.replaceAll("\\\\([^\\\\])", "$1");
    }
}

