/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util;

import java.util.Iterator;
import java.util.Map;

public class AsciiBitSet {
    public static final int UPPER = 1;
    public static final int LOWER = 2;
    public static final int BINARY = 4;
    public static final int OCTAL = 8;
    public static final int DIGIT = 16;
    public static final int HEX = 32;
    public static final int SPACE = 64;
    public static final int PUNCT = 128;
    public static final int CNTRL = 256;
    public static final int BLANK = 512;
    public static final int PRINT = 1024;
    public static final int UNDER = 2048;
    public static final int ALPHA = 3;
    public static final int ALNUM = 19;
    public static final int GRAPH = 147;
    public static final int WORD = 2067;
    private final int[] cclazz = new int[255];
    protected static final int[] DEFAULT_CHAR_CLAZZ;

    public AsciiBitSet() {
        this.init();
    }

    public AsciiBitSet(Map charInt) {
        this();
        Iterator i = charInt.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Character ch = (Character)e.getKey();
            Integer set = (Integer)e.getValue();
            this.add(ch.charValue(), set);
        }
    }

    protected void init() {
        System.arraycopy(DEFAULT_CHAR_CLAZZ, 0, this.cclazz, 0, DEFAULT_CHAR_CLAZZ.length);
    }

    protected int add(int ch, int set) {
        if (!this.isAscii(ch)) {
            throw new IllegalArgumentException("is not Ascii. char=" + ch);
        }
        int n = ch;
        this.cclazz[n] = this.cclazz[n] + set;
        return this.cclazz[ch];
    }

    public int getClazz(int ch) {
        return this.isAscii(ch) ? this.cclazz[ch] : 0;
    }

    public boolean isClazz(int ch, int clazz) {
        return (this.getClazz(ch) & clazz) != 0;
    }

    public boolean isAscii(int ch) {
        return (ch & 0xFFFFFF80) == 0;
    }

    public boolean isAlpha(int ch) {
        return this.isClazz(ch, 3);
    }

    public boolean isBinaryDigit(int ch) {
        return this.isClazz(ch, 4);
    }

    public boolean isOctDigit(int ch) {
        return this.isClazz(ch, 8);
    }

    public boolean isDigit(int ch) {
        return this.isClazz(ch, 16);
    }

    public boolean isHexDigit(int ch) {
        return this.isClazz(ch, 32);
    }

    public boolean isAlnum(int ch) {
        return this.isClazz(ch, 19);
    }

    public boolean isGraph(int ch) {
        return this.isClazz(ch, 147);
    }

    public boolean isPrint(int ch) {
        return this.isClazz(ch, 1024);
    }

    public boolean isPunct(int ch) {
        return this.isClazz(ch, 128);
    }

    public boolean isSpace(int ch) {
        return this.isClazz(ch, 64);
    }

    public boolean isCntrl(int ch) {
        return this.isClazz(ch, 256);
    }

    public boolean isLower(int ch) {
        return this.isClazz(ch, 2);
    }

    public boolean isUpper(int ch) {
        return this.isClazz(ch, 1);
    }

    public boolean isWord(int ch) {
        return this.isClazz(ch, 2067);
    }

    public int toLower(int ch) {
        return this.isUpper(ch) ? ch + 32 : ch;
    }

    public int toUpper(int ch) {
        return this.isLower(ch) ? ch - 32 : ch;
    }

    static {
        int[] cclazz = new int[255];
        cclazz[0] = 256;
        cclazz[1] = 256;
        cclazz[2] = 256;
        cclazz[3] = 256;
        cclazz[4] = 256;
        cclazz[5] = 256;
        cclazz[6] = 256;
        cclazz[7] = 256;
        cclazz[8] = 256;
        cclazz[9] = 832;
        cclazz[10] = 320;
        cclazz[11] = 320;
        cclazz[12] = 320;
        cclazz[13] = 320;
        cclazz[14] = 256;
        cclazz[15] = 256;
        cclazz[16] = 256;
        cclazz[17] = 256;
        cclazz[18] = 256;
        cclazz[19] = 256;
        cclazz[20] = 256;
        cclazz[21] = 256;
        cclazz[22] = 256;
        cclazz[23] = 256;
        cclazz[24] = 256;
        cclazz[25] = 256;
        cclazz[26] = 256;
        cclazz[27] = 256;
        cclazz[28] = 256;
        cclazz[29] = 256;
        cclazz[30] = 256;
        cclazz[31] = 256;
        cclazz[32] = 1600;
        cclazz[33] = 1152;
        cclazz[34] = 1152;
        cclazz[35] = 1152;
        cclazz[36] = 1152;
        cclazz[37] = 1152;
        cclazz[38] = 1152;
        cclazz[39] = 1152;
        cclazz[40] = 1152;
        cclazz[41] = 1152;
        cclazz[42] = 1152;
        cclazz[43] = 1152;
        cclazz[44] = 1152;
        cclazz[45] = 1152;
        cclazz[46] = 1152;
        cclazz[47] = 1152;
        cclazz[48] = 1084;
        cclazz[49] = 1084;
        cclazz[50] = 1080;
        cclazz[51] = 1080;
        cclazz[52] = 1080;
        cclazz[53] = 1080;
        cclazz[54] = 1080;
        cclazz[55] = 1080;
        cclazz[56] = 1072;
        cclazz[57] = 1072;
        cclazz[58] = 1152;
        cclazz[59] = 1152;
        cclazz[60] = 1152;
        cclazz[61] = 1152;
        cclazz[62] = 1152;
        cclazz[63] = 1152;
        cclazz[64] = 1152;
        cclazz[65] = 1057;
        cclazz[66] = 1057;
        cclazz[67] = 1057;
        cclazz[68] = 1057;
        cclazz[69] = 1057;
        cclazz[70] = 1057;
        cclazz[71] = 1025;
        cclazz[72] = 1025;
        cclazz[73] = 1025;
        cclazz[74] = 1025;
        cclazz[75] = 1025;
        cclazz[76] = 1025;
        cclazz[77] = 1025;
        cclazz[78] = 1025;
        cclazz[79] = 1025;
        cclazz[80] = 1025;
        cclazz[81] = 1025;
        cclazz[82] = 1025;
        cclazz[83] = 1025;
        cclazz[84] = 1025;
        cclazz[85] = 1025;
        cclazz[86] = 1025;
        cclazz[87] = 1025;
        cclazz[88] = 1057;
        cclazz[89] = 1025;
        cclazz[90] = 1025;
        cclazz[91] = 1152;
        cclazz[92] = 1152;
        cclazz[93] = 1152;
        cclazz[94] = 1152;
        cclazz[95] = 3200;
        cclazz[96] = 1152;
        cclazz[97] = 1058;
        cclazz[98] = 1058;
        cclazz[99] = 1058;
        cclazz[100] = 1058;
        cclazz[101] = 1058;
        cclazz[102] = 1058;
        cclazz[103] = 1026;
        cclazz[104] = 1026;
        cclazz[105] = 1026;
        cclazz[106] = 1026;
        cclazz[107] = 1026;
        cclazz[108] = 1026;
        cclazz[109] = 1026;
        cclazz[110] = 1026;
        cclazz[111] = 1026;
        cclazz[112] = 1026;
        cclazz[113] = 1026;
        cclazz[114] = 1026;
        cclazz[115] = 1026;
        cclazz[116] = 1026;
        cclazz[117] = 1026;
        cclazz[118] = 1026;
        cclazz[119] = 1026;
        cclazz[120] = 1058;
        cclazz[121] = 1026;
        cclazz[122] = 1026;
        cclazz[123] = 1152;
        cclazz[124] = 1152;
        cclazz[125] = 1152;
        cclazz[126] = 1152;
        cclazz[127] = 256;
        DEFAULT_CHAR_CLAZZ = cclazz;
    }
}

