/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.resource;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import shohaku.core.lang.Concat;
import shohaku.core.lang.Eval;
import shohaku.core.resource.ClassPathIOResource;
import shohaku.core.resource.FileSystemIOResource;
import shohaku.core.resource.IOResource;
import shohaku.core.resource.UrlIOResource;

public class IOResourceLoader {
    static final String CLASSPATH_URI_SCHEME = "classpath";
    public static final String CLASSPATH_URI_PREFIX = "classpath:";
    public static final String FILE_URI_PREFIX = "file:";
    private ClassLoader classLoader;
    private String uriPrefix;

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getUriPrefix() {
        return this.uriPrefix;
    }

    public void setUriPrefix(String prefix) {
        this.uriPrefix = prefix;
    }

    public IOResource getIOResource(String uri) throws IOException, URISyntaxException {
        String prefix = this.getUriPrefix();
        ClassLoader loader = this.getClassLoader();
        URI resourceUri = this.getResourceUri(prefix, uri);
        String scheme = resourceUri.getScheme();
        if (Eval.isPrefix(scheme, CLASSPATH_URI_SCHEME)) {
            String classpath = resourceUri.toString().substring(CLASSPATH_URI_PREFIX.length());
            return new ClassPathIOResource(classpath, loader);
        }
        if (Eval.isPrefix(scheme, FILE_URI_PREFIX)) {
            return new FileSystemIOResource(resourceUri);
        }
        return new UrlIOResource(resourceUri.toString());
    }

    protected URI getResourceUri(String prefix, String uri) throws URISyntaxException {
        URI relativeUri = new URI(uri);
        if (relativeUri.isAbsolute() || Eval.isBlank(prefix)) {
            return relativeUri;
        }
        String relative = relativeUri.toString();
        StringBuffer sb = new StringBuffer(Concat.size(prefix, relative));
        sb.append(prefix);
        if (prefix.endsWith("/")) {
            if (relative.startsWith("/")) {
                sb.append(relative.substring(1, relative.length()));
            }
        } else {
            if (!relative.startsWith("/")) {
                sb.append("/");
            }
            sb.append(relative);
        }
        return new URI(sb.toString());
    }
}

