/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import shohaku.core.resource.IOResource;

public class FileSystemIOResource
implements IOResource {
    private final File file;

    public FileSystemIOResource(String path) {
        this(new File(path));
    }

    public FileSystemIOResource(URI uri) {
        this(new File(uri));
    }

    public FileSystemIOResource(File file) {
        this.file = file;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }

    public boolean exists() {
        return this.file.exists();
    }

    public long getLastModified() throws IOException {
        return this.file.lastModified();
    }
}

