/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import shohaku.core.lang.Eval;
import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.lang.feature.FeatureFactory;
import shohaku.core.resource.IOResource;

public class ClassPathIOResource
implements IOResource {
    private final String path;
    private final ClassLoader classLoader;
    private final Class clazz;

    public ClassPathIOResource(String path) {
        this(path, null, null);
    }

    public ClassPathIOResource(String path, ClassLoader classLoader) {
        this(path, classLoader, null);
    }

    public ClassPathIOResource(String path, Class clazz) {
        this(path, null, clazz);
    }

    private ClassPathIOResource(String path, ClassLoader classLoader, Class clazz) {
        if (Eval.isBlank(path)) {
            throw new IllegalArgumentException("path is blank");
        }
        this.path = path.startsWith("/") ? path.substring(1) : path;
        this.classLoader = classLoader;
        this.clazz = clazz;
    }

    public InputStream getInputStream() throws IOException {
        Object r = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    URLConnection con = ClassPathIOResource.this.getURL().openConnection();
                    con.setUseCaches(false);
                    return con.getInputStream();
                }
                catch (IOException e) {
                    return e;
                }
                catch (NoSuchResourceException e) {
                    FileNotFoundException fe = new FileNotFoundException("resource not exist.");
                    fe.initCause(e);
                    return fe;
                }
            }
        });
        if (r instanceof IOException) {
            throw (IOException)r;
        }
        return (InputStream)r;
    }

    public OutputStream getOutputStream() throws IOException {
        Object r = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    URI uri = new URI(ClassPathIOResource.this.getURL().toString());
                    return new FileOutputStream(new File(uri));
                }
                catch (IOException e) {
                    return e;
                }
                catch (URISyntaxException e) {
                    FileNotFoundException fe = new FileNotFoundException("resource not exist.");
                    fe.initCause(e);
                    return fe;
                }
                catch (NoSuchResourceException e) {
                    FileNotFoundException fe = new FileNotFoundException("resource not exist.");
                    fe.initCause(e);
                    return fe;
                }
            }
        });
        if (r instanceof IOException) {
            throw (IOException)r;
        }
        return (OutputStream)r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean exists() {
        InputStream is = null;
        URLConnection con = this.getURL().openConnection();
        con.setUseCaches(false);
        is = con.getInputStream();
        boolean bl = true;
        Object var5_8 = null;
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e2) {
            // empty catch block
        }
        return bl;
        catch (IOException e) {
            boolean bl2 = false;
            Object var5_9 = null;
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            return bl2;
        }
        catch (NoSuchResourceException e) {
            boolean bl3 = false;
            Object var5_10 = null;
            {
                catch (Throwable throwable) {
                    Object var5_11 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e2) {}
                    throw throwable;
                }
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            return bl3;
        }
    }

    public long getLastModified() throws IOException {
        try {
            URLConnection con = this.getURL().openConnection();
            con.setUseCaches(false);
            return con.getLastModified();
        }
        catch (NoSuchResourceException e) {
            FileNotFoundException fe = new FileNotFoundException("resource not exist.");
            fe.initCause(e);
            throw fe;
        }
    }

    URL getURL() throws NoSuchResourceException {
        if (this.classLoader != null) {
            return FeatureFactory.getLoader().getResource(this.path, this.classLoader);
        }
        if (this.clazz != null) {
            return FeatureFactory.getLoader().getResource(this.path, this.clazz);
        }
        return FeatureFactory.getLoader().getResource(this.path);
    }
}

