/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.lang.feature.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import shohaku.core.lang.feature.LogFeature;

class JDKLogFeature
implements LogFeature {
    private final Logger log;

    public JDKLogFeature(Logger logger) {
        this.log = logger;
    }

    public boolean isTraceEnabled() {
        return this.log.isLoggable(Level.FINER);
    }

    public boolean isDebugEnabled() {
        return this.log.isLoggable(Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.log.isLoggable(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.log.isLoggable(Level.WARNING);
    }

    public boolean isErrorEnabled() {
        return this.log.isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.log.isLoggable(Level.SEVERE);
    }

    public void trace(Object message) {
        this.log.log(Level.FINER, String.valueOf(message));
    }

    public void trace(Object message, Throwable t) {
        this.log.log(Level.FINER, String.valueOf(message), t);
    }

    public void debug(Object message) {
        this.log.log(Level.FINE, String.valueOf(message));
    }

    public void debug(Object message, Throwable t) {
        this.log.log(Level.FINE, String.valueOf(message), t);
    }

    public void info(Object message) {
        this.log.log(Level.INFO, String.valueOf(message));
    }

    public void info(Object message, Throwable t) {
        this.log.log(Level.INFO, String.valueOf(message), t);
    }

    public void warn(Object message) {
        this.log.log(Level.WARNING, String.valueOf(message));
    }

    public void warn(Object message, Throwable t) {
        this.log.log(Level.WARNING, String.valueOf(message), t);
    }

    public void error(Object message) {
        this.log.log(Level.SEVERE, String.valueOf(message));
    }

    public void error(Object message, Throwable t) {
        this.log.log(Level.SEVERE, String.valueOf(message), t);
    }

    public void fatal(Object message) {
        this.log.log(Level.SEVERE, String.valueOf(message));
    }

    public void fatal(Object message, Throwable t) {
        this.log.log(Level.SEVERE, String.valueOf(message), t);
    }
}

