/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.lang.feature;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import shohaku.core.lang.ConfigurationException;
import shohaku.core.lang.feature.LogFeature;
import shohaku.core.lang.feature.ResourceLoader;
import shohaku.core.lang.feature.impl.DefaultFeatureFactory;

public abstract class FeatureFactory {
    protected final Map features = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$shohaku$core$lang$feature$FeatureFactory;
    static /* synthetic */ Class class$java$util$Map;

    protected FeatureFactory(Map properties) {
        this.initialize(properties);
    }

    protected void initialize(Map properties) {
        Iterator i = properties.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            Class id = FeatureFactory.loadClass(key);
            Object impl = FeatureFactory.getInstance(value);
            this.addFeature(id, impl);
        }
    }

    public abstract ResourceLoader getResourceLoader();

    public abstract LogFeature getLogFeature(Class var1);

    public abstract LogFeature getLogFeature(String var1);

    public Object getFeature(Class id) {
        if (id == null) {
            throw new ConfigurationException("id is null.");
        }
        return this.features.get(id);
    }

    public void addFeature(Class id, Object newFeature) {
        if (id == null) {
            throw new ConfigurationException("id is null.");
        }
        if (newFeature == null) {
            throw new ConfigurationException("feature is null.");
        }
        if (!id.isInstance(newFeature)) {
            throw new ConfigurationException("!(id Instanceof feature).");
        }
        this.features.put(id, newFeature);
    }

    public static ResourceLoader getLoader() {
        return FeatureFactory.getFactory().getResourceLoader();
    }

    public static LogFeature getLog(Class clazz) {
        return FeatureFactory.getFactory().getLogFeature(clazz);
    }

    public static LogFeature getLog(String name) {
        return FeatureFactory.getFactory().getLogFeature(name);
    }

    public static FeatureFactory getFactory() {
        return FactoryCache.featureFactory;
    }

    protected static Object getInstance(String name) {
        Class clazz = FeatureFactory.loadClass(name);
        if (clazz != null) {
            try {
                return clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected static Class loadClass(String name) {
        ClassLoader loader;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(name);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                loader = Thread.currentThread().getContextClassLoader();
                if (loader != null) {
                    clazz = loader.loadClass(name);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (clazz == null) {
            try {
                loader = ClassLoader.getSystemClassLoader();
                clazz = loader.loadClass(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return clazz;
    }

    static InputStream getResourceAsStream(final String name) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader threadCL = Thread.currentThread().getContextClassLoader();
                if (threadCL != null) {
                    return threadCL.getResourceAsStream(name);
                }
                return ClassLoader.getSystemResourceAsStream(name);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties loadProperties(String path) {
        Properties properties = new Properties();
        InputStream in = FeatureFactory.getResourceAsStream(path);
        if (null != in) {
            try {
                properties.load(in);
            }
            catch (IOException e) {
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }

    private static final class FactoryCache {
        static final FeatureFactory featureFactory;

        private FactoryCache() {
        }

        static {
            Properties defaultProperties = FeatureFactory.loadProperties("shohaku-feature-defaults.properties");
            Properties extendProperties = FeatureFactory.loadProperties("shohaku-feature-extends.properties");
            HashMap<Object, Object> properties = new HashMap<Object, Object>(defaultProperties);
            properties.putAll(extendProperties);
            String className = (String)properties.get((class$shohaku$core$lang$feature$FeatureFactory == null ? (class$shohaku$core$lang$feature$FeatureFactory = FeatureFactory.class$("shohaku.core.lang.feature.FeatureFactory")) : class$shohaku$core$lang$feature$FeatureFactory).getName());
            FeatureFactory _factory = null;
            if (className == null) {
                _factory = new DefaultFeatureFactory(properties);
            } else {
                properties.remove((class$shohaku$core$lang$feature$FeatureFactory == null ? (class$shohaku$core$lang$feature$FeatureFactory = FeatureFactory.class$("shohaku.core.lang.feature.FeatureFactory")) : class$shohaku$core$lang$feature$FeatureFactory).getName());
                try {
                    Class c = FeatureFactory.loadClass(className);
                    Constructor con = c.getConstructor(class$java$util$Map == null ? (class$java$util$Map = FeatureFactory.class$("java.util.Map")) : class$java$util$Map);
                    _factory = (FeatureFactory)con.newInstance(properties);
                }
                catch (Exception e) {
                    throw new InstantiationError("shohaku FeatureFactory creation err. " + className);
                }
            }
            properties.remove((class$shohaku$core$lang$feature$FeatureFactory == null ? (class$shohaku$core$lang$feature$FeatureFactory = FeatureFactory.class$("shohaku.core.lang.feature.FeatureFactory")) : class$shohaku$core$lang$feature$FeatureFactory).getName());
            featureFactory = _factory;
        }
    }
}

