/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.lang;

import shohaku.core.lang.Boxing;
import shohaku.core.lang.VariableNumber;

public final class VariableLong
implements VariableNumber,
Comparable {
    private static final long serialVersionUID = 6955628218091162086L;
    private long value;

    public VariableLong() {
        this(0L);
    }

    public VariableLong(long value) {
        this.value = value;
    }

    public VariableLong(String s) throws NumberFormatException {
        this.value = Long.parseLong(s, 10);
    }

    public VariableLong(Number value) {
        this.value = value.longValue();
    }

    public VariableLong(VariableNumber value) {
        this.value = value.longValue();
    }

    public long get() {
        return this.value;
    }

    public void set(long value) {
        this.value = value;
    }

    public long add(long val) {
        this.value += val;
        return this.value;
    }

    public long subtract(long val) {
        this.value -= val;
        return this.value;
    }

    public long multiply(long val) {
        this.value *= val;
        return this.value;
    }

    public long divide(long val) {
        this.value /= val;
        return this.value;
    }

    public long increment() {
        ++this.value;
        return this.value;
    }

    public long decrement() {
        --this.value;
        return this.value;
    }

    public Number getValue() {
        return Boxing.box(this.value);
    }

    public void setValue(Number value) {
        this.set(value.longValue());
    }

    public void setValue(VariableNumber value) {
        this.set(value.longValue());
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int compareTo(Object obj) {
        VariableLong anotherLong = (VariableLong)obj;
        long thisVal = this.value;
        long anotherVal = anotherLong.value;
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof VariableLong) {
            return this.value == ((VariableLong)obj).longValue();
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

