/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.lang;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shohaku.core.lang.Boxing;
import shohaku.core.lang.Closure;

public final class ValueOf {
    private static final String NULL_SYMBOL = "null";
    private static final String NEGATIVE_SIGN = "-";
    private static final Pattern dateTimePattern;
    private static final char[] hexDigit;

    public static Object decode(String src) {
        Position pos = new Position(0, src.length());
        ValueOf.next(src, pos);
        Object reValue = ValueOf.decodeVlaue(src, pos);
        ValueOf.next(src, pos);
        if (pos.index + 1 < pos.len) {
            throw ValueOf.newIllegalArgumentEx("pattern err.", src, pos.index);
        }
        return reValue;
    }

    public static BigDecimal decodeBigDecimal(String src) {
        int suffix = src.endsWith("g") || src.endsWith("G") ? src.length() - 1 : src.length();
        return new BigDecimal(src.substring(0, suffix));
    }

    public static BigInteger decodeBigInteger(String src) {
        int index = 0;
        boolean negative = false;
        if (src.startsWith(NEGATIVE_SIGN)) {
            negative = true;
            ++index;
        }
        int radix = 10;
        if (src.startsWith("0x", index) || src.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (src.startsWith("0b", index) || src.startsWith("0B", index)) {
            index += 2;
            radix = 2;
        } else if (src.startsWith("0", index) && src.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        int suffix = src.endsWith("h") || src.endsWith("H") ? src.length() - 1 : src.length();
        String _num = negative ? NEGATIVE_SIGN.concat(src.substring(index, suffix)) : src.substring(index, suffix);
        return new BigInteger(_num, radix);
    }

    public static Boolean decodeBoolean(String src) {
        if (src == null) {
            throw ValueOf.newIllegalArgumentEx("is not Boolean.", src, 0);
        }
        if (src.equals("false")) {
            return Boolean.FALSE;
        }
        if (src.equals("true")) {
            return Boolean.TRUE;
        }
        throw ValueOf.newIllegalArgumentEx("is not Boolean.", src, 0);
    }

    public static Byte decodeByte(String src) {
        int index = 0;
        boolean negative = false;
        if (src.startsWith(NEGATIVE_SIGN)) {
            negative = true;
            ++index;
        }
        int radix = 10;
        if (src.startsWith("0x", index) || src.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (src.startsWith("0b", index) || src.startsWith("0B", index)) {
            index += 2;
            radix = 2;
        } else if (src.startsWith("0", index) && src.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        int suffix = src.endsWith("u") || src.endsWith("U") ? src.length() - 1 : src.length();
        String _num = negative ? NEGATIVE_SIGN.concat(src.substring(index, suffix)) : src.substring(index, suffix);
        return Byte.valueOf(_num, radix);
    }

    public static Character decodeCharacter(String src) {
        if (src == null) {
            throw ValueOf.newIllegalArgumentEx("Malformed character encoding.", src, 0);
        }
        int srcLength = src.length();
        if (srcLength == 0) {
            throw ValueOf.newIllegalArgumentEx("Malformed character encoding.", src, 0);
        }
        char c = src.charAt(0);
        if (c == '\\') {
            if (srcLength < 2) {
                throw ValueOf.newIllegalArgumentEx("Malformed character encoding.", src, 0);
            }
            c = src.charAt(1);
            if (c == 'u') {
                if (srcLength != 6) {
                    throw ValueOf.newIllegalArgumentEx("Malformed \\uxxxx encoding.", src, 1);
                }
                return Boxing.box(ValueOf.decodeHexCharacter(src, 2));
            }
            if (srcLength != 2) {
                throw ValueOf.newIllegalArgumentEx("Malformed \\x encoding.", src, 1);
            }
            return Boxing.box(ValueOf.decodeCntrlCharacter(src, c, 1));
        }
        if (srcLength != 1) {
            throw ValueOf.newIllegalArgumentEx("Malformed 'x' encoding.", src, 1);
        }
        return Boxing.box(c);
    }

    public static Object decodeDateTime(String src) {
        if (src.length() == 0) {
            throw ValueOf.newIllegalArgumentEx("pattern err.", src, 0);
        }
        Matcher match = dateTimePattern.matcher(src);
        if (match.find()) {
            int n;
            int s;
            int i;
            int h;
            int d;
            int m;
            int y;
            String year = match.group(1);
            String month = match.group(2);
            String day = match.group(3);
            String deli = match.group(4);
            String hour = match.group(5);
            String minute = match.group(6);
            String second = match.group(7);
            String nano = match.group(8);
            String zoneSign = match.group(9);
            String zoneHour = match.group(10);
            String zoneMinute = match.group(11);
            String type = match.group(12);
            if (year != null && hour != null && deli == null) {
                throw ValueOf.newIllegalArgumentEx("pattern err.", src, 0);
            }
            if (deli != null && (year == null || hour == null)) {
                throw ValueOf.newIllegalArgumentEx("pattern err.", src, 0);
            }
            if (year != null) {
                y = Integer.parseInt(year);
                m = Integer.parseInt(month) - 1;
                d = Integer.parseInt(day);
            } else {
                y = 1970;
                m = 0;
                d = 1;
            }
            if (hour != null) {
                h = Integer.parseInt(hour);
                i = Integer.parseInt(minute);
                s = Integer.parseInt(second);
                n = nano != null ? Integer.parseInt(nano) : 0;
            } else {
                h = 0;
                i = 0;
                s = 0;
                n = 0;
            }
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(1, y);
            cal.set(2, m);
            cal.set(5, d);
            cal.set(11, h);
            cal.set(12, i);
            cal.set(13, s);
            cal.set(14, n);
            if (zoneSign != null) {
                int zh = Integer.parseInt(zoneHour);
                int zm = Integer.parseInt(zoneMinute);
                int zone = zh * 60 * 60 * 1000 + zm * 60 * 1000;
                int z = zoneSign.equals("+") ? zone : -zone;
                cal.set(15, z);
            }
            if (type != null) {
                int _type = ValueOf.toUpper(type.charAt(0));
                switch (_type) {
                    case 68: {
                        return cal.getTime();
                    }
                    case 71: {
                        return cal;
                    }
                    case 76: {
                        return Boxing.box(cal.getTimeInMillis());
                    }
                }
            }
            return cal.getTime();
        }
        throw ValueOf.newIllegalArgumentEx("pattern err.", src, 0);
    }

    public static Double decodeDouble(String src) {
        int suffix = src.endsWith("d") || src.endsWith("D") ? src.length() - 1 : src.length();
        return Double.valueOf(src.substring(0, suffix));
    }

    public static Float decodeFloat(String src) {
        int suffix = src.endsWith("f") || src.endsWith("F") ? src.length() - 1 : src.length();
        return Float.valueOf(src.substring(0, suffix));
    }

    public static Integer decodeInteger(String src) {
        int index = 0;
        boolean negative = false;
        if (src.startsWith(NEGATIVE_SIGN)) {
            negative = true;
            ++index;
        }
        int radix = 10;
        if (src.startsWith("0x", index) || src.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (src.startsWith("0b", index) || src.startsWith("0B", index)) {
            index += 2;
            radix = 2;
        } else if (src.startsWith("0", index) && src.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        int suffix = src.endsWith("i") || src.endsWith("I") ? src.length() - 1 : src.length();
        String _num = negative ? NEGATIVE_SIGN.concat(src.substring(index, suffix)) : src.substring(index, suffix);
        return Integer.valueOf(_num, radix);
    }

    public static List decodeList(String src) {
        return ValueOf.decodeList(src, new Position(0, src.length()));
    }

    public static Long decodeLong(String src) {
        int index = 0;
        boolean negative = false;
        if (src.startsWith(NEGATIVE_SIGN)) {
            negative = true;
            ++index;
        }
        int radix = 10;
        if (src.startsWith("0x", index) || src.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (src.startsWith("0b", index) || src.startsWith("0B", index)) {
            index += 2;
            radix = 2;
        } else if (src.startsWith("0", index) && src.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        int suffix = src.endsWith("l") || src.endsWith("L") ? src.length() - 1 : src.length();
        String _num = negative ? NEGATIVE_SIGN.concat(src.substring(index, suffix)) : src.substring(index, suffix);
        return Long.valueOf(_num, radix);
    }

    public static Map decodeMap(String src) {
        return ValueOf.decodeMap(src, new Position(0, src.length()));
    }

    public static Object decodeNull(String src) {
        if (src == null) {
            throw ValueOf.newIllegalArgumentEx("is not Null.", src, 0);
        }
        if (src.equals(NULL_SYMBOL)) {
            return null;
        }
        throw ValueOf.newIllegalArgumentEx("is not Null.", src, 0);
    }

    public static Number decodeNumber(String src) {
        int srcLength = src.length();
        if (srcLength == 1) {
            return Integer.valueOf(src, 10);
        }
        int negative = src.startsWith(NEGATIVE_SIGN) ? 1 : 0;
        int suffix = ValueOf.toUpper(src.charAt(srcLength - 1));
        if (-1 < src.indexOf(46, negative)) {
            switch (suffix) {
                case 68: {
                    return Double.valueOf(ValueOf.numstr(negative, src, 0, true));
                }
                case 70: {
                    return Float.valueOf(ValueOf.numstr(negative, src, 0, true));
                }
                case 71: {
                    return new BigDecimal(ValueOf.numstr(negative, src, 0, true));
                }
            }
            return Double.valueOf(ValueOf.numstr(negative, src, 0, false));
        }
        if (src.startsWith("0", negative)) {
            int radixNm = ValueOf.toUpper(src.charAt(negative + 1));
            if (88 == radixNm) {
                switch (suffix) {
                    case 72: {
                        return new BigInteger(ValueOf.numstr(negative, src, 16, true), 16);
                    }
                    case 73: {
                        return Integer.valueOf(ValueOf.numstr(negative, src, 16, true), 16);
                    }
                    case 76: {
                        return Long.valueOf(ValueOf.numstr(negative, src, 16, true), 16);
                    }
                    case 83: {
                        return Short.valueOf(ValueOf.numstr(negative, src, 16, true), 16);
                    }
                    case 85: {
                        return Byte.valueOf(ValueOf.numstr(negative, src, 16, true), 16);
                    }
                }
                return Integer.valueOf(ValueOf.numstr(negative, src, 16, false), 16);
            }
            if (66 == radixNm) {
                switch (suffix) {
                    case 72: {
                        return new BigInteger(ValueOf.numstr(negative, src, 2, true), 2);
                    }
                    case 73: {
                        return Integer.valueOf(ValueOf.numstr(negative, src, 2, true), 2);
                    }
                    case 76: {
                        return Long.valueOf(ValueOf.numstr(negative, src, 2, true), 2);
                    }
                    case 83: {
                        return Short.valueOf(ValueOf.numstr(negative, src, 2, true), 2);
                    }
                    case 85: {
                        return Byte.valueOf(ValueOf.numstr(negative, src, 2, true), 2);
                    }
                }
                return Integer.valueOf(ValueOf.numstr(negative, src, 2, false), 2);
            }
            if (src.length() == 2 + negative) {
                switch (suffix) {
                    case 68: {
                        return new Double(negative == 0 ? 0.0 : -0.0);
                    }
                    case 70: {
                        return new Float(negative == 0 ? 0.0f : -0.0f);
                    }
                    case 71: {
                        return new BigDecimal(BigInteger.ZERO, 0);
                    }
                    case 72: {
                        return BigInteger.ZERO;
                    }
                    case 73: {
                        return new Integer(0);
                    }
                    case 76: {
                        return new Long(0L);
                    }
                    case 83: {
                        return new Short(0);
                    }
                    case 85: {
                        return new Byte(0);
                    }
                }
            }
            switch (suffix) {
                case 72: {
                    return new BigInteger(ValueOf.numstr(negative, src, 8, true), 8);
                }
                case 73: {
                    return Integer.valueOf(ValueOf.numstr(negative, src, 8, true), 8);
                }
                case 76: {
                    return Long.valueOf(ValueOf.numstr(negative, src, 8, true), 8);
                }
                case 83: {
                    return Short.valueOf(ValueOf.numstr(negative, src, 8, true), 8);
                }
                case 85: {
                    return Byte.valueOf(ValueOf.numstr(negative, src, 8, true), 8);
                }
            }
            return Integer.valueOf(ValueOf.numstr(negative, src, 8, false), 8);
        }
        switch (suffix) {
            case 68: {
                return Double.valueOf(ValueOf.numstr(negative, src, 0, true));
            }
            case 70: {
                return Float.valueOf(ValueOf.numstr(negative, src, 0, true));
            }
            case 71: {
                return new BigDecimal(ValueOf.numstr(negative, src, 0, true));
            }
            case 72: {
                return new BigInteger(ValueOf.numstr(negative, src, 10, true), 10);
            }
            case 73: {
                return Integer.valueOf(ValueOf.numstr(negative, src, 10, true), 10);
            }
            case 76: {
                return Long.valueOf(ValueOf.numstr(negative, src, 10, true), 10);
            }
            case 83: {
                return Short.valueOf(ValueOf.numstr(negative, src, 10, true), 10);
            }
            case 85: {
                return Byte.valueOf(ValueOf.numstr(negative, src, 10, true), 10);
            }
        }
        if (src.startsWith("I", negative)) {
            return Double.valueOf(src);
        }
        if (src.startsWith("N", negative)) {
            return Double.valueOf(src);
        }
        return Integer.valueOf(ValueOf.numstr(negative, src, 10, false), 10);
    }

    public static Set decodeSet(String src) {
        return ValueOf.decodeSet(src, new Position(0, src.length()));
    }

    public static Short decodeShort(String src) {
        int index = 0;
        boolean negative = false;
        if (src.startsWith(NEGATIVE_SIGN)) {
            negative = true;
            ++index;
        }
        int radix = 10;
        if (src.startsWith("0x", index) || src.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (src.startsWith("0b", index) || src.startsWith("0B", index)) {
            index += 2;
            radix = 2;
        } else if (src.startsWith("0", index) && src.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        int suffix = src.endsWith("s") || src.endsWith("S") ? src.length() - 1 : src.length();
        String _num = negative ? NEGATIVE_SIGN.concat(src.substring(index, suffix)) : src.substring(index, suffix);
        return Short.valueOf(_num, radix);
    }

    public static String decodeString(String src) {
        if (src == null) {
            throw ValueOf.newIllegalArgumentEx("Malformed character encoding.", src, 0);
        }
        int srcLength = src.length();
        StringBuffer sb = new StringBuffer(srcLength);
        for (int i = 0; i < srcLength; ++i) {
            char c = src.charAt(i);
            if (c == '\\') {
                if (i + 1 >= srcLength) {
                    throw ValueOf.newIllegalArgumentEx("Malformed character encoding.", src, i);
                }
                char next = src.charAt(i + 1);
                if (next == 'u') {
                    if (i + 5 >= srcLength) {
                        throw ValueOf.newIllegalArgumentEx("Malformed \\uxxxx encoding.", src, i);
                    }
                    sb.append(ValueOf.decodeHexCharacter(src, i + 2));
                    i += 5;
                    continue;
                }
                if (i + 1 >= srcLength) {
                    throw ValueOf.newIllegalArgumentEx("Malformed \\x encoding.", src, i);
                }
                sb.append(ValueOf.decodeCntrlCharacter(src, next, i));
                ++i;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String encode(Object src) {
        StringBuffer sb = new StringBuffer();
        ValueOf.encodeVlaue(sb, src);
        return sb.toString();
    }

    public static String encodeBigDecimal(BigDecimal src) {
        return ValueOf.encodeNumber(src, 'G');
    }

    public static String encodeBigInteger(BigInteger src) {
        return ValueOf.encodeNumber(src, 'H');
    }

    public static String encodeBoolean(Boolean src) {
        return src.toString();
    }

    public static String encodeByte(Byte src) {
        return ValueOf.encodeNumber(src, 'U');
    }

    public static String encodeCharacter(Character src) {
        StringBuffer sb = new StringBuffer(7);
        char c = src.charValue();
        ValueOf.addUnicodeEscapeChar(sb, c);
        return sb.toString();
    }

    public static String encodeDateTime(Calendar cal) {
        return ValueOf.encodeDateTime(cal, 'G');
    }

    public static String encodeDateTime(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.clear();
        cal.setTimeInMillis(date.getTime());
        return ValueOf.encodeDateTime(cal, 'D');
    }

    public static String encodeDateTime(Long millis) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.clear();
        cal.setTimeInMillis(millis);
        return ValueOf.encodeDateTime(cal, 'L');
    }

    public static String encodeDouble(Double src) {
        return ValueOf.encodeNumber(src, 'D');
    }

    public static String encodeFloat(Float src) {
        return ValueOf.encodeNumber(src, 'F');
    }

    public static String encodeInteger(Integer src) {
        return ValueOf.encodeNumber(src, 'i');
    }

    public static String encodeList(List src) {
        StringBuffer sb = new StringBuffer();
        ValueOf.encodeList(sb, src);
        return sb.toString();
    }

    public static String encodeLong(Long src) {
        return ValueOf.encodeNumber(src, 'L');
    }

    public static String encodeMap(Map src) {
        StringBuffer sb = new StringBuffer();
        ValueOf.encodeMap(sb, src);
        return sb.toString();
    }

    public static String encodeNull() {
        return NULL_SYMBOL;
    }

    public static String encodeNumber(Number src) {
        if (src instanceof Byte) {
            return ValueOf.encodeByte((Byte)src);
        }
        if (src instanceof Short) {
            return ValueOf.encodeShort((Short)src);
        }
        if (src instanceof Integer) {
            return ValueOf.encodeInteger((Integer)src);
        }
        if (src instanceof Long) {
            return ValueOf.encodeLong((Long)src);
        }
        if (src instanceof Float) {
            return ValueOf.encodeFloat((Float)src);
        }
        if (src instanceof Double) {
            return ValueOf.encodeDouble((Double)src);
        }
        if (src instanceof BigInteger) {
            return ValueOf.encodeBigInteger((BigInteger)src);
        }
        if (src instanceof BigDecimal) {
            return ValueOf.encodeBigDecimal((BigDecimal)src);
        }
        throw ValueOf.newIllegalArgumentEx("Unsupported type.", src, 0);
    }

    public static String encodeSet(Set src) {
        StringBuffer sb = new StringBuffer();
        ValueOf.encodeSet(sb, src);
        return sb.toString();
    }

    public static String encodeShort(Short src) {
        return ValueOf.encodeNumber(src, 'S');
    }

    public static String encodeString(String src) {
        int srcLength = src.length();
        StringBuffer sb = new StringBuffer(srcLength * 7);
        for (int i = 0; i < srcLength; ++i) {
            char c = src.charAt(i);
            ValueOf.addUnicodeEscapeChar(sb, c);
        }
        return sb.toString();
    }

    public static Object macro(String src, Map macros, Map context) {
        Position pos = new Position(0, src.length());
        ValueOf.next(src, pos);
        Object reValue = ValueOf.macroVlaue(src, macros, context, pos);
        ValueOf.next(src, pos);
        if (pos.index + 1 < pos.len) {
            throw ValueOf.newIllegalArgumentEx("pattern err.", src, pos.index);
        }
        return reValue;
    }

    private static void addUnicodeEscapeChar(StringBuffer sb, char c) {
        sb.append('\\');
        sb.append('u');
        sb.append(ValueOf.toHex(c >> 12 & 0xF));
        sb.append(ValueOf.toHex(c >> 8 & 0xF));
        sb.append(ValueOf.toHex(c >> 4 & 0xF));
        sb.append(ValueOf.toHex(c & 0xF));
    }

    private static String cutDateTimeString(String src, Position pos) {
        int bigin = pos.index;
        int off = pos.index;
        if (off + 1 >= pos.len) {
            throw ValueOf.newIllegalArgumentEx("not find close char.", src, pos.index);
        }
        while (off < pos.len && !ValueOf.isNotDateTimeChar(src.charAt(++off))) {
        }
        if (off >= pos.len || src.charAt(off) != '/') {
            throw ValueOf.newIllegalArgumentEx("not find close char.", src, pos.index);
        }
        pos.index = ++off;
        return src.substring(bigin + 1, off - 1);
    }

    private static String cutNumberString(String src, Position pos) {
        int off;
        int bigin = pos.index;
        for (off = pos.index; off < pos.len && !ValueOf.isNotNumChar(src.charAt(off)); ++off) {
        }
        pos.index = off;
        return src.substring(bigin, off);
    }

    /*
     * WARNING - void declaration
     */
    private static Boolean decodeBoolean(String src, Position pos) {
        void var2_2;
        Boolean b;
        if (src.startsWith("false", pos.index)) {
            b = Boolean.FALSE;
            pos.index += 5;
        } else if (src.startsWith("true", pos.index)) {
            b = Boolean.TRUE;
            pos.index += 4;
        } else {
            throw ValueOf.newIllegalArgumentEx("is not Boolean.", src, pos.index);
        }
        return var2_2;
    }

    private static Character decodeCharacter(String src, Position pos) {
        char c;
        if (src == null) {
            throw ValueOf.newIllegalArgumentEx("Malformed character encoding.", src, pos.index);
        }
        int off = pos.index;
        if (off + 1 >= pos.len) {
            throw ValueOf.newIllegalArgumentEx("not find close char.", src, pos.index);
        }
        if ((c = src.charAt(++off)) == '\\') {
            if (off + 1 >= pos.len) {
                throw ValueOf.newIllegalArgumentEx("Malformed character encoding.", src, pos.index);
            }
            char next = src.charAt(off + 1);
            if (next == 'u') {
                if (off + 5 >= pos.len) {
                    throw ValueOf.newIllegalArgumentEx("Malformed \\uxxxx encoding.", src, pos.index);
                }
                c = ValueOf.decodeHexCharacter(src, off + 2);
                off += 5;
            } else {
                if (off + 1 >= pos.len) {
                    throw ValueOf.newIllegalArgumentEx("Malformed \\x encoding.", src, pos.index);
                }
                c = ValueOf.decodeCntrlCharacter(src, next, pos.index);
                ++off;
            }
        }
        if (++off >= pos.len || src.charAt(off) != '`') {
            throw ValueOf.newIllegalArgumentEx("not find close char.", src, pos.index);
        }
        pos.index = ++off;
        return Boxing.box(c);
    }

    private static char decodeCntrlCharacter(CharSequence src, char c, int index) {
        switch (c) {
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '0': {
                return '\u0000';
            }
            case '1': {
                return '\u0001';
            }
            case '2': {
                return '\u0002';
            }
            case '3': {
                return '\u0003';
            }
            case '4': {
                return '\u0004';
            }
            case '5': {
                return '\u0005';
            }
            case '6': {
                return '\u0006';
            }
            case '7': {
                return '\u0007';
            }
            case '\\': {
                return '\\';
            }
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
        }
        throw ValueOf.newIllegalArgumentEx("Malformed \\x encoding.", src, index);
    }

    private static Collection decodeCollection(String src, Position pos, int open, int close, Collection coll) {
        ValueOf.next(src, pos);
        char openChar = src.charAt(pos.index);
        if (openChar != open) {
            throw ValueOf.newIllegalArgumentEx("pattern err.", src, pos.index);
        }
        ++pos.index;
        ValueOf.next(src, pos);
        char closeChar = src.charAt(pos.index);
        if (closeChar == close) {
            ++pos.index;
            return coll;
        }
        while (pos.index < pos.len) {
            coll.add(ValueOf.decodeVlaue(src, pos));
            ValueOf.next(src, pos);
            char next = src.charAt(pos.index);
            if (next == close) {
                ++pos.index;
                break;
            }
            if (next == ',') {
                ++pos.index;
            } else {
                throw ValueOf.newIllegalArgumentEx("pattern err.", src, pos.index);
            }
            ValueOf.next(src, pos);
        }
        return coll;
    }

    private static char decodeHexCharacter(CharSequence src, int index) {
        int value = 0;
        block5: for (int i = index; i < index + 4; ++i) {
            char c = src.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value = (value << 4) + c - 48;
                    continue block5;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    value = (value << 4) + 10 + c - 65;
                    continue block5;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    value = (value << 4) + 10 + c - 97;
                    continue block5;
                }
                default: {
                    throw ValueOf.newIllegalArgumentEx("Malformed \\uxxxx encoding.", src, index);
                }
            }
        }
        return (char)value;
    }

    private static List decodeList(String src, Position pos) {
        ArrayList list = new ArrayList();
        return Collections.unmodifiableList((List)ValueOf.decodeCollection(src, pos, 91, 93, list));
    }

    private static Map decodeMap(String src, Position pos) {
        LinkedHashMap map = new LinkedHashMap();
        return Collections.unmodifiableMap(ValueOf.decodeMap(src, pos, 123, 125, 61, map));
    }

    private static Map decodeMap(String src, Position pos, int open, int close, int delimiter, Map map) {
        ValueOf.next(src, pos);
        char openChar = src.charAt(pos.index);
        if (openChar != open) {
            throw ValueOf.newIllegalArgumentEx("pattern err.", src, pos.index);
        }
        ++pos.index;
        ValueOf.next(src, pos);
        char closeChar = src.charAt(pos.index);
        if (closeChar == close) {
            ++pos.index;
            return map;
        }
        while (pos.index < pos.len) {
            Object key = ValueOf.decodeVlaue(src, pos);
            ValueOf.next(src, pos);
            char delimiterChar = src.charAt(pos.index);
            if (delimiterChar != delimiter) {
                throw ValueOf.newIllegalArgumentEx("pattern err.", src, pos.index);
            }
            ++pos.index;
            ValueOf.next(src, pos);
            Object value = ValueOf.decodeVlaue(src, pos);
            map.put(key, value);
            ValueOf.next(src, pos);
            char next = src.charAt(pos.index);
            if (next == close) {
                ++pos.index;
                break;
            }
            if (next == ',') {
                ++pos.index;
            } else {
                throw ValueOf.newIllegalArgumentEx("pattern err.", src, pos.index);
            }
            ValueOf.next(src, pos);
        }
        return map;
    }

    private static Object decodeNull(String src, Position pos) {
        if (src.startsWith(NULL_SYMBOL, pos.index)) {
            pos.index += 4;
            return null;
        }
        throw ValueOf.newIllegalArgumentEx("is not null.", src, pos.index);
    }

    private static Set decodeSet(String src, Position pos) {
        LinkedHashSet set = new LinkedHashSet();
        return Collections.unmodifiableSet((Set)ValueOf.decodeCollection(src, pos, 40, 41, set));
    }

    private static String decodeString(String src, Position pos) {
        char c;
        if (src == null) {
            throw ValueOf.newIllegalArgumentEx("Malformed character encoding.", src, pos.index);
        }
        StringBuffer sb = new StringBuffer();
        int off = pos.index;
        if (off + 1 >= pos.len) {
            throw ValueOf.newIllegalArgumentEx("not find close char.", src, pos.index);
        }
        while (off < pos.len && (c = src.charAt(++off)) != '\'') {
            if (c == '\\') {
                if (off + 2 >= pos.len) {
                    throw ValueOf.newIllegalArgumentEx("Malformed character encoding.", src, pos.index);
                }
                char next = src.charAt(off + 1);
                if (next == 'u') {
                    if (off + 6 >= pos.len) {
                        throw ValueOf.newIllegalArgumentEx("Malformed \\uxxxx encoding.", src, pos.index);
                    }
                    sb.append(ValueOf.decodeHexCharacter(src, off + 2));
                    off += 5;
                    continue;
                }
                if (off + 2 >= pos.len) {
                    throw ValueOf.newIllegalArgumentEx("Malformed \\x encoding.", src, pos.index);
                }
                sb.append(ValueOf.decodeCntrlCharacter(src, next, pos.index));
                ++off;
                continue;
            }
            sb.append(c);
        }
        if (off >= pos.len || src.charAt(off) != '\'') {
            throw ValueOf.newIllegalArgumentEx("not find close char.", src, pos.index);
        }
        pos.index = ++off;
        return sb.toString();
    }

    private static Object decodeVlaue(String src, Position pos) {
        char ch = src.charAt(pos.index);
        switch (ch) {
            case '\'': {
                return ValueOf.decodeString(src, pos);
            }
            case '(': {
                return ValueOf.decodeSet(src, pos);
            }
            case '/': {
                return ValueOf.decodeDateTime(ValueOf.cutDateTimeString(src, pos));
            }
            case '[': {
                return ValueOf.decodeList(src, pos);
            }
            case '`': {
                return ValueOf.decodeCharacter(src, pos);
            }
            case 'f': {
                return ValueOf.decodeBoolean(src, pos);
            }
            case 'n': {
                return ValueOf.decodeNull(src, pos);
            }
            case 't': {
                return ValueOf.decodeBoolean(src, pos);
            }
            case '{': {
                return ValueOf.decodeMap(src, pos);
            }
        }
        if (ValueOf.isBeginNumberChar(ch)) {
            return ValueOf.decodeNumber(ValueOf.cutNumberString(src, pos));
        }
        throw ValueOf.newIllegalArgumentEx("pattern err.", src, pos.index);
    }

    private static void encodeCollection(StringBuffer sb, Collection src) {
        Iterator i = src.iterator();
        while (i.hasNext()) {
            ValueOf.encodeVlaue(sb, i.next());
            if (!i.hasNext()) continue;
            sb.append(',');
        }
    }

    private static String encodeDateTime(Calendar cal, char type) {
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int date = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int nanos = cal.get(14);
        int zone = cal.get(15);
        char zsign = 0 > zone ? (char)'-' : '+';
        int zabs = Math.abs(zone);
        int zhour = zabs / 3600000;
        int zminute = (zabs - zhour * 3600000) / 60000;
        StringBuffer sb = new StringBuffer(28);
        ValueOf.padZero(sb, year, 4);
        sb.append('-');
        ValueOf.padZero(sb, month, 2);
        sb.append('-');
        ValueOf.padZero(sb, date, 2);
        sb.append('T');
        ValueOf.padZero(sb, hour, 2);
        sb.append(':');
        ValueOf.padZero(sb, minute, 2);
        sb.append(':');
        ValueOf.padZero(sb, second, 2);
        sb.append('.');
        ValueOf.padZero(sb, nanos, 3);
        sb.append(zsign);
        ValueOf.padZero(sb, zhour, 2);
        sb.append(':');
        ValueOf.padZero(sb, zminute, 2);
        sb.append(type);
        return sb.toString();
    }

    private static void encodeList(StringBuffer sb, List src) {
        sb.append('[');
        ValueOf.encodeCollection(sb, src);
        sb.append(']');
    }

    private static void encodeMap(StringBuffer sb, Map src) {
        sb.append('{');
        Iterator i = src.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            ValueOf.encodeVlaue(sb, e.getKey());
            sb.append('=');
            ValueOf.encodeVlaue(sb, e.getValue());
            if (!i.hasNext()) continue;
            sb.append(',');
        }
        sb.append('}');
    }

    private static String encodeNumber(Number src, char suffix) {
        String _src = src.toString();
        int capacity = _src.length() + 1;
        return new StringBuffer(capacity).append(_src).append(suffix).toString();
    }

    private static void encodeSet(StringBuffer sb, Set src) {
        sb.append('(');
        ValueOf.encodeCollection(sb, src);
        sb.append(')');
    }

    private static void encodeVlaue(StringBuffer sb, Object src) {
        if (src == null) {
            sb.append(NULL_SYMBOL);
            return;
        }
        if (src instanceof Number) {
            if (src instanceof Byte) {
                sb.append(ValueOf.encodeByte((Byte)src));
                return;
            }
            if (src instanceof Short) {
                sb.append(ValueOf.encodeShort((Short)src));
                return;
            }
            if (src instanceof Integer) {
                sb.append(ValueOf.encodeInteger((Integer)src));
                return;
            }
            if (src instanceof Long) {
                sb.append(ValueOf.encodeLong((Long)src));
                return;
            }
            if (src instanceof Float) {
                sb.append(ValueOf.encodeFloat((Float)src));
                return;
            }
            if (src instanceof Double) {
                sb.append(ValueOf.encodeDouble((Double)src));
                return;
            }
            if (src instanceof BigInteger) {
                sb.append(ValueOf.encodeBigInteger((BigInteger)src));
                return;
            }
            if (src instanceof BigDecimal) {
                sb.append(ValueOf.encodeBigDecimal((BigDecimal)src));
                return;
            }
            throw ValueOf.newIllegalArgumentEx("Unsupported type.", src, 0);
        }
        if (src instanceof String) {
            sb.append('\'');
            sb.append(ValueOf.encodeString((String)src));
            sb.append('\'');
            return;
        }
        if (src instanceof Character) {
            sb.append('`');
            sb.append(ValueOf.encodeCharacter((Character)src));
            sb.append('`');
            return;
        }
        if (src instanceof Calendar) {
            sb.append('/');
            sb.append(ValueOf.encodeDateTime((Calendar)src));
            sb.append('/');
            return;
        }
        if (src instanceof Boolean) {
            sb.append(ValueOf.encodeBoolean((Boolean)src));
            return;
        }
        if (src instanceof Date) {
            sb.append('/');
            sb.append(ValueOf.encodeDateTime((Date)src));
            sb.append('/');
            return;
        }
        if (src instanceof List) {
            ValueOf.encodeList(sb, (List)src);
            return;
        }
        if (src instanceof Set) {
            ValueOf.encodeSet(sb, (Set)src);
            return;
        }
        if (src instanceof Map) {
            ValueOf.encodeMap(sb, (Map)src);
            return;
        }
        throw ValueOf.newIllegalArgumentEx("Unsupported type.", src, 0);
    }

    private static boolean isBeginNumberChar(int ch) {
        switch (ch) {
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 73: 
            case 78: {
                return true;
            }
        }
        return false;
    }

    private static boolean isNotDateTimeChar(int ch) {
        switch (ch) {
            case 32: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 68: 
            case 71: 
            case 76: 
            case 84: 
            case 100: 
            case 103: 
            case 108: {
                return false;
            }
        }
        return true;
    }

    private static boolean isNotNumChar(int ch) {
        switch (ch) {
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 78: 
            case 83: 
            case 85: 
            case 88: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 108: 
            case 110: 
            case 115: 
            case 116: 
            case 117: 
            case 120: 
            case 121: {
                return false;
            }
        }
        return true;
    }

    private static boolean isNotSpaceChar(int ch) {
        switch (ch) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 32: {
                return false;
            }
        }
        return true;
    }

    private static Object macro(String src, Map macros, Map context, Position pos) {
        ++pos.index;
        int endIndex = ValueOf.macroIdEndIndexOf(src, pos);
        if (endIndex < 0) {
            throw ValueOf.newIllegalArgumentEx("not find args.", src, pos.index);
        }
        String key = src.substring(pos.index, endIndex);
        Object macro = macros.get(key);
        if (macro == null) {
            throw ValueOf.newIllegalArgumentEx("is not contains macro id.", src, pos.index);
        }
        if (!(macro instanceof Closure)) {
            throw ValueOf.newIllegalArgumentEx("illegal Macro Object.", src, pos.index);
        }
        pos.index = endIndex;
        ValueOf.next(src, pos);
        char argsType = src.charAt(pos.index);
        if (argsType == '(') {
            List listArgs = ValueOf.macroArgsList(src, macros, context, pos);
            return ((Closure)macro).evaluate(listArgs);
        }
        throw ValueOf.newIllegalArgumentEx("illegal Macro Arguments.", src, pos.index);
    }

    private static List macroArgsList(String src, Map macros, Map context, Position pos) {
        ArrayList args = new ArrayList(8);
        ValueOf.macroCollection(src, macros, context, pos, 40, 41, args);
        return args;
    }

    private static Collection macroCollection(String src, Map macros, Map context, Position pos, int open, int close, Collection coll) {
        ValueOf.next(src, pos);
        char openChar = src.charAt(pos.index);
        if (openChar != open) {
            throw ValueOf.newIllegalArgumentEx("pattern err.", src, pos.index);
        }
        ++pos.index;
        ValueOf.next(src, pos);
        char closeChar = src.charAt(pos.index);
        if (closeChar == close) {
            ++pos.index;
            return coll;
        }
        while (pos.index < pos.len) {
            coll.add(ValueOf.macroVlaue(src, macros, context, pos));
            ValueOf.next(src, pos);
            char next = src.charAt(pos.index);
            if (next == close) {
                ++pos.index;
                break;
            }
            if (next == ',') {
                ++pos.index;
            } else {
                throw ValueOf.newIllegalArgumentEx("pattern err.", src, pos.index);
            }
            ValueOf.next(src, pos);
        }
        return coll;
    }

    private static Object macroContext(String src, Map context, Position pos) {
        char openChar = src.charAt(pos.index);
        if (openChar != '#') {
            throw ValueOf.newIllegalArgumentEx("not find open char.", src, pos.index);
        }
        ++pos.index;
        int endIndex = src.indexOf(35, pos.index);
        if (endIndex < 0) {
            throw ValueOf.newIllegalArgumentEx("not find close char.", src, pos.index);
        }
        String key = src.substring(pos.index, endIndex);
        Object val = context.get(key);
        if (val == null && !context.containsKey(key)) {
            throw ValueOf.newIllegalArgumentEx("is not contains context key.", src, pos.index);
        }
        pos.index = endIndex;
        ++pos.index;
        return val;
    }

    private static int macroIdEndIndexOf(String src, Position pos) {
        block3: for (int i = pos.index; i < pos.len; ++i) {
            char ch = src.charAt(i);
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    continue block3;
                }
                default: {
                    if (i == pos.index) {
                        return -1;
                    }
                    return i;
                }
            }
        }
        return -1;
    }

    private static List macroList(String src, Map macros, Map context, Position pos) {
        ArrayList list = new ArrayList();
        return Collections.unmodifiableList((List)ValueOf.macroCollection(src, macros, context, pos, 91, 93, list));
    }

    private static Map macroMap(String src, Map macros, Map context, Position pos) {
        LinkedHashMap map = new LinkedHashMap();
        return Collections.unmodifiableMap(ValueOf.macroMap(src, macros, context, pos, 123, 125, 61, map));
    }

    private static Map macroMap(String src, Map macros, Map context, Position pos, int open, int close, int delimiter, Map map) {
        ValueOf.next(src, pos);
        char openChar = src.charAt(pos.index);
        if (openChar != open) {
            throw ValueOf.newIllegalArgumentEx("pattern err.", src, pos.index);
        }
        ++pos.index;
        ValueOf.next(src, pos);
        char closeChar = src.charAt(pos.index);
        if (closeChar == close) {
            ++pos.index;
            return map;
        }
        while (pos.index < pos.len) {
            Object key = ValueOf.macroVlaue(src, macros, context, pos);
            ValueOf.next(src, pos);
            char delimiterChar = src.charAt(pos.index);
            if (delimiterChar != delimiter) {
                throw ValueOf.newIllegalArgumentEx("pattern err.", src, pos.index);
            }
            ++pos.index;
            ValueOf.next(src, pos);
            Object value = ValueOf.macroVlaue(src, macros, context, pos);
            map.put(key, value);
            ValueOf.next(src, pos);
            char next = src.charAt(pos.index);
            if (next == close) {
                ++pos.index;
                break;
            }
            if (next == ',') {
                ++pos.index;
            } else {
                throw ValueOf.newIllegalArgumentEx("pattern err.", src, pos.index);
            }
            ValueOf.next(src, pos);
        }
        return map;
    }

    private static Set macroSet(String src, Map macros, Map context, Position pos) {
        LinkedHashSet set = new LinkedHashSet();
        return Collections.unmodifiableSet((Set)ValueOf.macroCollection(src, macros, context, pos, 40, 41, set));
    }

    private static Object macroVlaue(String src, Map macros, Map context, Position pos) {
        char ch = src.charAt(pos.index);
        switch (ch) {
            case '#': {
                return ValueOf.macroContext(src, context, pos);
            }
            case '$': {
                return ValueOf.macro(src, macros, context, pos);
            }
            case '\'': {
                return ValueOf.decodeString(src, pos);
            }
            case '(': {
                return ValueOf.macroSet(src, macros, context, pos);
            }
            case '/': {
                return ValueOf.decodeDateTime(ValueOf.cutDateTimeString(src, pos));
            }
            case '[': {
                return ValueOf.macroList(src, macros, context, pos);
            }
            case '`': {
                return ValueOf.decodeCharacter(src, pos);
            }
            case 'f': {
                return ValueOf.decodeBoolean(src, pos);
            }
            case 'n': {
                return ValueOf.decodeNull(src, pos);
            }
            case 't': {
                return ValueOf.decodeBoolean(src, pos);
            }
            case '{': {
                return ValueOf.macroMap(src, macros, context, pos);
            }
        }
        if (ValueOf.isBeginNumberChar(ch)) {
            return ValueOf.decodeNumber(ValueOf.cutNumberString(src, pos));
        }
        throw ValueOf.newIllegalArgumentEx("pattern err.", src, pos.index);
    }

    private static IllegalArgumentException newIllegalArgumentEx(String msg, Object src, int index) {
        throw new IllegalArgumentException(msg + "\u3000src=" + src + ", pos=" + index);
    }

    private static void next(String src, Position pos) {
        while (pos.index < pos.len && !ValueOf.isNotSpaceChar(src.charAt(pos.index))) {
            ++pos.index;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String numstr(int negative, String src, int radix, boolean hasSuffix) {
        void var5_5;
        int endIndex = hasSuffix ? src.length() - 1 : src.length();
        switch (radix) {
            case 2: {
                String _num = src.substring(negative + 2, endIndex);
                break;
            }
            case 8: {
                String _num = src.substring(negative + 1, endIndex);
                break;
            }
            case 10: {
                String _num = src.substring(negative + 0, endIndex);
                break;
            }
            case 16: {
                String _num = src.substring(negative + 2, endIndex);
                break;
            }
            default: {
                return src.substring(0, endIndex);
            }
        }
        return negative == 1 ? NEGATIVE_SIGN.concat((String)var5_5) : var5_5;
    }

    private static void padZero(StringBuffer sb, int value, int n) {
        int size = 10;
        for (int i = 1; i < n; ++i) {
            if (value < size) {
                for (int j = i; j < n; ++j) {
                    sb.append('0');
                }
                break;
            }
            size *= 10;
        }
        sb.append(value);
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    private static int toUpper(int ch) {
        return (ch - 97 | 122 - ch) >= 0 ? ch - 32 : ch;
    }

    static {
        hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer p = new StringBuffer();
        p.append("^");
        p.append("(?:(\\d{4})-(\\d{2})-(\\d{2}))?");
        p.append("(T|\\u0020+)?");
        p.append("(?:(?:(\\d{2}):(\\d{2}):(\\d{2}))(?:(?:\\.(\\d{3}))?)?(?:(?:\\u0020*)(?:([-+])(\\d{2}):(\\d{2})))?)?(l|L|d|D|g|G)?");
        p.append("$");
        dateTimePattern = Pattern.compile(p.toString());
    }

    static class Position {
        final int len;
        int index;

        Position(int index, int len) {
            this.index = index;
            this.len = len;
        }
    }
}

