/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.lang;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import shohaku.core.lang.Concat;

public class SystemUtils {
    public static final String FILE_ENCODING = SystemUtils.getSystemProperty("file.encoding");
    public static final String FILE_SEPARATOR = SystemUtils.getSystemProperty("file.separator");
    public static final String JAVA_VERSION = SystemUtils.getSystemProperty("java.version");
    public static final String LINE_SEPARATOR = SystemUtils.getSystemProperty("line.separator");

    public static Properties getSystemProperties() {
        return (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperties();
            }
        });
    }

    public static String getSystemProperty(String key) {
        final String _key = key;
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(_key);
            }
        });
    }

    public static String getLibraryVersion(Class clazz) {
        return clazz.getPackage().getImplementationVersion();
    }

    public static Map getLibraryProperties(Class clazz) {
        String path = clazz.getName().substring("shohaku.".length());
        String libraryName = path.substring(0, path.indexOf(46));
        Properties properties = new Properties();
        SystemUtils.loadProperties(properties, Concat.get("shohaku-", libraryName, "-system-defaults.properties"));
        SystemUtils.loadProperties(properties, Concat.get("shohaku-", libraryName, "-system-extends.properties"));
        return new HashMap(SystemUtils.convertProperties(properties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadProperties(Properties properties, String path) {
        InputStream in = SystemUtils.getResourceAsStream(path);
        if (null != in) {
            try {
                properties.load(in);
            }
            catch (IOException e) {
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    static Map convertProperties(Map properties) {
        Iterator i = properties.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            e.setValue(SystemUtils.convertProperty((String)e.getValue()));
        }
        return properties;
    }

    static Object convertProperty(String property) {
        String prop = property.trim();
        if (prop.length() == 0) {
            return "";
        }
        if (prop.startsWith("\"") && prop.endsWith("\"")) {
            return prop.substring(1, prop.length() - 1);
        }
        if (prop.startsWith("[") && prop.endsWith("]")) {
            String listString = prop.substring(1, prop.length() - 1);
            String[] elements = listString.split(",");
            ArrayList<Object> list = new ArrayList<Object>(elements.length);
            for (int i = 0; i < elements.length; ++i) {
                list.add(SystemUtils.convertProperty(elements[i].trim()));
            }
            return list;
        }
        if (prop.length() == 3 && prop.startsWith("'") && prop.endsWith("'")) {
            return new Character(prop.charAt(1));
        }
        if (prop.equalsIgnoreCase("true") || prop.equalsIgnoreCase("false")) {
            return Boolean.valueOf(prop.toLowerCase());
        }
        try {
            char suffix = Character.toUpperCase(prop.charAt(prop.length() - 1));
            String num = prop.substring(0, prop.length() - 1);
            switch (suffix) {
                case 'B': {
                    return Byte.valueOf(num);
                }
                case 'S': {
                    return Short.valueOf(num);
                }
                case 'I': {
                    return Integer.valueOf(num);
                }
                case 'L': {
                    return Long.valueOf(num);
                }
                case 'F': {
                    return Float.valueOf(num);
                }
                case 'D': {
                    return Double.valueOf(num);
                }
            }
            if (-1 < prop.indexOf(46)) {
                return Double.valueOf(prop);
            }
            return Integer.valueOf(prop);
        }
        catch (NumberFormatException numberFormatException) {
            return prop;
        }
    }

    static InputStream getResourceAsStream(final String name) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader threadCL = Thread.currentThread().getContextClassLoader();
                if (threadCL != null) {
                    return threadCL.getResourceAsStream(name);
                }
                return ClassLoader.getSystemResourceAsStream(name);
            }
        });
    }
}

