/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.lang;

import shohaku.core.lang.Boxing;
import shohaku.core.lang.Concat;
import shohaku.core.lang.RangeNumber;

public final class RangeLong
implements RangeNumber {
    private static final long serialVersionUID = -2255778083152234701L;
    private final long min;
    private final long max;

    public RangeLong() {
        this.min = 0L;
        this.max = 0L;
    }

    public RangeLong(long min, long max) {
        this.min = min;
        this.max = max;
    }

    public Number getMaxValue() {
        return Boxing.box(this.max);
    }

    public Number getMinValue() {
        return Boxing.box(this.min);
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }

    public boolean contain(long n) {
        return this.min <= n && n <= this.max;
    }

    public int hashCode() {
        return (int)(this.min ^ this.min >>> 32) + (int)(this.max ^ this.max >>> 32);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangeLong)) {
            return false;
        }
        RangeLong r = (RangeLong)o;
        return r.min == this.min && r.max == this.max;
    }

    public String toString() {
        return Concat.get(String.valueOf(this.min), ":", String.valueOf(this.max));
    }
}

