/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.lang;

import shohaku.core.lang.Boxing;
import shohaku.core.lang.Concat;
import shohaku.core.lang.RangeNumber;

public final class RangeInt
implements RangeNumber {
    private static final long serialVersionUID = 5210716783487090274L;
    private final int min;
    private final int max;

    public RangeInt() {
        this.min = 0;
        this.max = 0;
    }

    public RangeInt(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public Number getMaxValue() {
        return Boxing.box(this.max);
    }

    public Number getMinValue() {
        return Boxing.box(this.min);
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public boolean contain(int n) {
        return this.min <= n && n <= this.max;
    }

    public int hashCode() {
        return this.min + this.max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangeInt)) {
            return false;
        }
        RangeInt r = (RangeInt)o;
        return r.min == this.min && r.max == this.max;
    }

    public String toString() {
        return Concat.get(String.valueOf(this.min), ":", String.valueOf(this.max));
    }
}

