/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.lang;

import shohaku.core.lang.Boxing;
import shohaku.core.lang.Concat;
import shohaku.core.lang.RangeNumber;

public final class RangeDouble
implements RangeNumber {
    private static final long serialVersionUID = -5154999490875732308L;
    private final double min;
    private final double max;

    public RangeDouble() {
        this.min = 0.0;
        this.max = 0.0;
    }

    public RangeDouble(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public Number getMaxValue() {
        return Boxing.box(this.max);
    }

    public Number getMinValue() {
        return Boxing.box(this.min);
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public boolean contain(double n) {
        return this.min <= n && n <= this.max;
    }

    public int hashCode() {
        long bitsMin = Double.doubleToLongBits(this.min);
        long bitsMax = Double.doubleToLongBits(this.max);
        return (int)(bitsMin ^ bitsMin >>> 32) + (int)(bitsMax ^ bitsMax >>> 32);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangeDouble)) {
            return false;
        }
        RangeDouble r = (RangeDouble)o;
        return r.min == this.min && r.max == this.max;
    }

    public String toString() {
        return Concat.get(String.valueOf(this.min), ":", String.valueOf(this.max));
    }
}

