/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.lang;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import shohaku.core.lang.Boxing;

public final class Fast {
    public static String nvl(Object o) {
        return o == null ? "" : String.valueOf(o);
    }

    public static String nvl(Object o, String substitute) {
        return o == null ? substitute : String.valueOf(o);
    }

    public static String bvl(String s) {
        return s == null || Fast.trimLength(s) == 0 ? "" : s;
    }

    public static String bvl(String s, String substitute) {
        return s == null || Fast.trimLength(s) == 0 ? substitute : s;
    }

    public static String wvl(String s) {
        return s == null || Fast.trimWhiteLength(s) == 0 ? "" : s;
    }

    public static String wvl(String s, String substitute) {
        return s == null || Fast.trimWhiteLength(s) == 0 ? substitute : s;
    }

    static int trimWhiteLength(CharSequence cs) {
        int st;
        int ed = cs.length();
        for (st = 0; st < ed && Character.isWhitespace(cs.charAt(st)); ++st) {
        }
        while (st < ed && Character.isWhitespace(cs.charAt(ed - 1))) {
            --ed;
        }
        return ed - st;
    }

    static int trimLength(CharSequence cs) {
        int st;
        int ed = cs.length();
        for (st = 0; st < ed && cs.charAt(st) <= ' '; ++st) {
        }
        while (st < ed && cs.charAt(ed - 1) <= ' ') {
            --ed;
        }
        return ed - st;
    }

    public static void arraycopy(Object src, Object dest) {
        System.arraycopy(src, 0, dest, 0, Math.min(Array.getLength(src), Array.getLength(dest)));
    }

    public static Map fixedMap(Object[] keyValue) {
        int size = keyValue.length;
        if (size % 2 != 0) {
            throw new IllegalArgumentException("keyValue size err ((keyValue.length % 2) != 0).");
        }
        if (size == 0) {
            return Collections.EMPTY_MAP;
        }
        if (size == 2) {
            return Collections.singletonMap(keyValue[0], keyValue[1]);
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(size / 2);
        for (int i = 0; i < size; i += 2) {
            map.put(keyValue[i], keyValue[i + 1]);
        }
        return Collections.unmodifiableMap(map);
    }

    public static Map fixedMap(Collection keyValue) {
        int size = keyValue.size();
        if (size % 2 != 0) {
            throw new IllegalArgumentException("keyValue size err ((keyValue.size() % 2) != 0).");
        }
        if (size == 0) {
            return Collections.EMPTY_MAP;
        }
        if (size == 2) {
            Iterator i = keyValue.iterator();
            return Collections.singletonMap(i.next(), i.next());
        }
        LinkedHashMap map = new LinkedHashMap(size / 2);
        Iterator i = keyValue.iterator();
        while (i.hasNext()) {
            map.put(i.next(), i.next());
        }
        return Collections.unmodifiableMap(map);
    }

    public static Map fixedReferenceMap(Object[] keyValue) {
        int size = keyValue.length;
        if (size % 2 != 0) {
            throw new IllegalArgumentException("keyValue size err ((keyValue.length % 2) != 0).");
        }
        if (size == 0) {
            return Collections.EMPTY_MAP;
        }
        IdentityHashMap<Object, Object> map = new IdentityHashMap<Object, Object>(size / 2);
        for (int i = 0; i < size; i += 2) {
            map.put(keyValue[i], keyValue[i + 1]);
        }
        return Collections.unmodifiableMap(map);
    }

    public static Map fixedReferenceMap(Collection keyValue) {
        int size = keyValue.size();
        if (size % 2 != 0) {
            throw new IllegalArgumentException("keyValue size err ((keyValue.size() % 2) != 0).");
        }
        if (size == 0) {
            return Collections.EMPTY_MAP;
        }
        IdentityHashMap map = new IdentityHashMap(size / 2);
        Iterator i = keyValue.iterator();
        while (i.hasNext()) {
            map.put(i.next(), i.next());
        }
        return Collections.unmodifiableMap(map);
    }

    public static SortedMap fixedSortedMap(Object[] keyValue) {
        int size = keyValue.length;
        if (size % 2 != 0) {
            throw new IllegalArgumentException("keyValue size err ((keyValue.length % 2) != 0).");
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>(size / 2);
        for (int i = 0; i < size; i += 2) {
            map.put(keyValue[i], keyValue[i + 1]);
        }
        TreeMap sortedMap = new TreeMap(map);
        return Collections.unmodifiableSortedMap(sortedMap);
    }

    public static SortedMap fixedSortedMap(Collection keyValue) {
        int size = keyValue.size();
        if (size % 2 != 0) {
            throw new IllegalArgumentException("keyValue size err ((keyValue.size() % 2) != 0).");
        }
        HashMap map = new HashMap(size / 2);
        Iterator i = keyValue.iterator();
        while (i.hasNext()) {
            map.put(i.next(), i.next());
        }
        TreeMap sortedMap = new TreeMap(map);
        return Collections.unmodifiableSortedMap(sortedMap);
    }

    public static SortedMap fixedSortedMap(Object[] keyValue, Comparator c) {
        int size = keyValue.length;
        if (size % 2 != 0) {
            throw new IllegalArgumentException("keyValue size err ((keyValue.length % 2) != 0).");
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>(size / 2);
        for (int i = 0; i < size; i += 2) {
            map.put(keyValue[i], keyValue[i + 1]);
        }
        TreeMap<Object, Object> sortedMap = new TreeMap<Object, Object>(c);
        sortedMap.putAll(map);
        return Collections.unmodifiableSortedMap(sortedMap);
    }

    public static SortedMap fixedSortedMap(Collection keyValue, Comparator c) {
        int size = keyValue.size();
        if (size % 2 != 0) {
            throw new IllegalArgumentException("keyValue size err ((keyValue.size() % 2) != 0).");
        }
        HashMap map = new HashMap(size / 2);
        Iterator i = keyValue.iterator();
        while (i.hasNext()) {
            map.put(i.next(), i.next());
        }
        TreeMap sortedMap = new TreeMap(c);
        sortedMap.putAll(map);
        return Collections.unmodifiableSortedMap(sortedMap);
    }

    public static List fixedList(Object[] a) {
        if (a.length == 0) {
            return Collections.EMPTY_LIST;
        }
        if (a.length == 1) {
            return Collections.singletonList(a[0]);
        }
        return Collections.unmodifiableList(Fast.asArrayList(a));
    }

    public static Set fixedSet(Object[] a) {
        if (a.length == 0) {
            return Collections.EMPTY_SET;
        }
        if (a.length == 1) {
            return Collections.singleton(a[0]);
        }
        return Collections.unmodifiableSet(Fast.asLinkedHashSet(a));
    }

    public static Collection fixedListCollection(Object[] a) {
        return Collections.unmodifiableCollection(Fast.asArrayList(a));
    }

    public static Collection fixedSetCollection(Object[] a) {
        return Collections.unmodifiableCollection(Fast.asLinkedHashSet(a));
    }

    public static Collection fixedSetArrayCollection(Object[] a) {
        return Collections.unmodifiableCollection(Fast.asSetArrayList(a));
    }

    public static ArrayList asSetArrayList(Object[] a) {
        return Fast.asArrayList(Fast.asHashSet(a).toArray());
    }

    public static ArrayList asArrayList(Object[] a) {
        return new ArrayList<Object>(Arrays.asList(a));
    }

    public static LinkedList asLinkedList(Object[] a) {
        return new LinkedList<Object>(Arrays.asList(a));
    }

    public static HashSet asHashSet(Object[] a) {
        return new HashSet<Object>(Arrays.asList(a));
    }

    public static LinkedHashSet asLinkedHashSet(Object[] a) {
        return new LinkedHashSet<Object>(Arrays.asList(a));
    }

    public static HashMap asHashMap(Object[] keyValue) {
        int size = keyValue.length;
        if (size % 2 != 0) {
            throw new IllegalArgumentException("keyValue size err ((keyValue.size() % 2) != 0).");
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>(size / 2);
        for (int i = 0; i < size; i += 2) {
            map.put(keyValue[i], keyValue[i + 1]);
        }
        return map;
    }

    public static LinkedHashMap asLinkedHashMap(Object[] keyValue) {
        int size = keyValue.length;
        if (size % 2 != 0) {
            throw new IllegalArgumentException("keyValue size err ((keyValue.size() % 2) != 0).");
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(size / 2);
        for (int i = 0; i < size; i += 2) {
            map.put(keyValue[i], keyValue[i + 1]);
        }
        return map;
    }

    public static Object[] asArray(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9, Object o10, Object o11, Object o12) {
        return new Object[]{o1, o2, o3, o4, o5, o6, o7, o8, o9, o10, o11, o12};
    }

    public static Object[] asArray(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9, Object o10, Object o11) {
        return new Object[]{o1, o2, o3, o4, o5, o6, o7, o8, o9, o10, o11};
    }

    public static Object[] asArray(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9, Object o10) {
        return new Object[]{o1, o2, o3, o4, o5, o6, o7, o8, o9, o10};
    }

    public static Object[] asArray(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9) {
        return new Object[]{o1, o2, o3, o4, o5, o6, o7, o8, o9};
    }

    public static Object[] asArray(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8) {
        return new Object[]{o1, o2, o3, o4, o5, o6, o7, o8};
    }

    public static Object[] asArray(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7) {
        return new Object[]{o1, o2, o3, o4, o5, o6, o7};
    }

    public static Object[] asArray(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6) {
        return new Object[]{o1, o2, o3, o4, o5, o6};
    }

    public static Object[] asArray(Object o1, Object o2, Object o3, Object o4, Object o5) {
        return new Object[]{o1, o2, o3, o4, o5};
    }

    public static Object[] asArray(Object o1, Object o2, Object o3, Object o4) {
        return new Object[]{o1, o2, o3, o4};
    }

    public static Object[] asArray(Object o1, Object o2, Object o3) {
        return new Object[]{o1, o2, o3};
    }

    public static Object[] asArray(Object o1, Object o2) {
        return new Object[]{o1, o2};
    }

    public static Object[] asArray(Object o1) {
        return new Object[]{o1};
    }

    public static Object[] asArray() {
        return new Object[0];
    }

    public static Calendar getDateTimeCalendar(int year, int month, int date, int hour, int minute, int second, int milliSecond, int zoneOffset) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.clear();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, date);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, milliSecond);
        cal.set(15, zoneOffset);
        return cal;
    }

    public static Calendar getDateTimeCalendar(int year, int month, int date, int hour, int minute, int second, int milliSecond) {
        return Fast.getDateTimeCalendar(year, month, date, hour, minute, second, milliSecond, TimeZone.getDefault().getRawOffset());
    }

    public static Calendar getDateTimeCalendar(int year, int month, int date, int hour, int minute, int second) {
        return Fast.getDateTimeCalendar(year, month, date, hour, minute, second, 0, TimeZone.getDefault().getRawOffset());
    }

    public static Calendar getTimeCalendar(int hour, int minute, int second, int milliSecond, int zoneOffset) {
        return Fast.getDateTimeCalendar(1970, 1, 1, hour, minute, second, milliSecond, zoneOffset);
    }

    public static Calendar getTimeCalendar(int hour, int minute, int second, int milliSecond) {
        return Fast.getDateTimeCalendar(1970, 1, 1, hour, minute, second, milliSecond, TimeZone.getDefault().getRawOffset());
    }

    public static Calendar getTimeCalendar(int hour, int minute, int second) {
        return Fast.getDateTimeCalendar(1970, 1, 1, hour, minute, second, 0, TimeZone.getDefault().getRawOffset());
    }

    public static Calendar getDateCalendar(int year, int month, int date) {
        return Fast.getDateTimeCalendar(year, month, date, 0, 0, 0, 0, TimeZone.getDefault().getRawOffset());
    }

    public static Calendar getDateCalendar(int year, int month, int date, int zoneOffset) {
        return Fast.getDateTimeCalendar(year, month, date, 0, 0, 0, 0, zoneOffset);
    }

    public static Date getDateTime(int year, int month, int date, int hour, int minute, int second, int milliSecond, int zoneOffset) {
        Calendar cal = Fast.getDateTimeCalendar(year, month, date, hour, minute, second, milliSecond, zoneOffset);
        return cal.getTime();
    }

    public static Date getDateTime(int year, int month, int date, int hour, int minute, int second, int milliSecond) {
        return Fast.getDateTime(year, month, date, hour, minute, second, milliSecond, TimeZone.getDefault().getRawOffset());
    }

    public static Date getDateTime(int year, int month, int date, int hour, int minute, int second) {
        return Fast.getDateTime(year, month, date, hour, minute, second, 0, TimeZone.getDefault().getRawOffset());
    }

    public static Date getTime(int hour, int minute, int second, int milliSecond, int zoneOffset) {
        return Fast.getDateTime(1970, 1, 1, hour, minute, second, milliSecond, zoneOffset);
    }

    public static Date getTime(int hour, int minute, int second, int milliSecond) {
        return Fast.getDateTime(1970, 1, 1, hour, minute, second, milliSecond, TimeZone.getDefault().getRawOffset());
    }

    public static Date getTime(int hour, int minute, int second) {
        return Fast.getDateTime(1970, 1, 1, hour, minute, second, 0, TimeZone.getDefault().getRawOffset());
    }

    public static Date getDate(int year, int month, int date) {
        return Fast.getDateTime(year, month, date, 0, 0, 0, 0, TimeZone.getDefault().getRawOffset());
    }

    public static Date getDate(int year, int month, int date, int zoneOffset) {
        return Fast.getDateTime(year, month, date, 0, 0, 0, 0, zoneOffset);
    }

    public static Long getDateTimeInMillis(int year, int month, int date, int hour, int minute, int second, int milliSecond, int zoneOffset) {
        Calendar cal = Fast.getDateTimeCalendar(year, month, date, hour, minute, second, milliSecond, zoneOffset);
        return Boxing.box(cal.getTimeInMillis());
    }

    public static Long getDateTimeInMillis(int year, int month, int date, int hour, int minute, int second, int milliSecond) {
        return Fast.getDateTimeInMillis(year, month, date, hour, minute, second, milliSecond, TimeZone.getDefault().getRawOffset());
    }

    public static Long getDateTimeInMillis(int year, int month, int date, int hour, int minute, int second) {
        return Fast.getDateTimeInMillis(year, month, date, hour, minute, second, 0, TimeZone.getDefault().getRawOffset());
    }

    public static Long getTimeInMillis(int hour, int minute, int second, int milliSecond, int zoneOffset) {
        return Fast.getDateTimeInMillis(1970, 1, 1, hour, minute, second, milliSecond, zoneOffset);
    }

    public static Long getTimeInMillis(int hour, int minute, int second, int milliSecond) {
        return Fast.getDateTimeInMillis(1970, 1, 1, hour, minute, second, milliSecond, TimeZone.getDefault().getRawOffset());
    }

    public static Long getTimeInMillis(int hour, int minute, int second) {
        return Fast.getDateTimeInMillis(1970, 1, 1, hour, minute, second, 0, TimeZone.getDefault().getRawOffset());
    }

    public static Long getDateInMillis(int year, int month, int date) {
        return Fast.getDateTimeInMillis(year, month, date, 0, 0, 0, 0, TimeZone.getDefault().getRawOffset());
    }

    public static Long getDateInMillis(int year, int month, int date, int zoneOffset) {
        return Fast.getDateTimeInMillis(year, month, date, 0, 0, 0, 0, zoneOffset);
    }
}

